/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.entity.projectile;

import chumbanotz.mutantbeasts.entity.MBEntityType;
import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import chumbanotz.mutantbeasts.entity.mutant.MutantSnowGolemEntity;
import chumbanotz.mutantbeasts.item.MBItems;
import chumbanotz.mutantbeasts.util.EntityUtil;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class ThrowableBlockEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<OptionalInt> OWNER_ENTITY_ID = EntityDataManager.func_187226_a(ThrowableBlockEntity.class, (IDataSerializer)DataSerializers.field_218814_r);
    private static final DataParameter<Boolean> HELD = EntityDataManager.func_187226_a(ThrowableBlockEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockState blockState = Blocks.field_196658_i.func_176223_P();
    @Nullable
    private EntityType<?> ownerType;

    public ThrowableBlockEntity(EntityType<? extends ThrowableBlockEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ThrowableBlockEntity(double x, double y, double z, LivingEntity livingEntityIn) {
        super(MBEntityType.THROWABLE_BLOCK, x, y, z, livingEntityIn.field_70170_p);
        this.func_212361_a((Entity)livingEntityIn);
        this.ownerType = livingEntityIn.func_200600_R();
    }

    public ThrowableBlockEntity(MutantEndermanEntity enderman, int id) {
        this(enderman.func_226277_ct_(), enderman.func_226278_cu_() + 4.7, enderman.func_226281_cx_(), (LivingEntity)enderman);
        this.blockState = Block.func_196257_b((int)enderman.getHeldBlock(id));
        boolean outer = id <= 1;
        boolean right = (id & 1) == 0;
        LivingEntity attackTarget = enderman.func_70638_az();
        Vector3d forward = EntityUtil.getDirVector(this.field_70177_z, outer ? 2.7f : 1.4f);
        Vector3d strafe = EntityUtil.getDirVector(this.field_70177_z + (right ? 90.0f : -90.0f), outer ? 2.2f : 2.0f);
        this.func_70107_b(this.func_226277_ct_() + forward.field_72450_a + strafe.field_72450_a, this.func_226278_cu_() + (double)(outer ? 2.8f : 1.1f) - 4.8, this.func_226281_cx_() + forward.field_72449_c + strafe.field_72449_c);
        if (attackTarget != null) {
            double d0 = attackTarget.func_226277_ct_() - this.func_226277_ct_();
            double d1 = attackTarget.func_226283_e_(0.33) - this.func_226278_cu_();
            double d2 = attackTarget.func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            this.func_70186_c(d0, d1 + d3 * 0.1, d2, 1.4f, 1.0f);
        } else {
            this.throwBlock((LivingEntity)enderman);
        }
    }

    public ThrowableBlockEntity(MutantSnowGolemEntity mutantSnowGolem) {
        this(mutantSnowGolem.func_226277_ct_(), mutantSnowGolem.func_226278_cu_() + 1.955 - 0.1 + 1.0, mutantSnowGolem.func_226281_cx_(), (LivingEntity)mutantSnowGolem);
        this.field_70177_z = mutantSnowGolem.field_70177_z;
        this.blockState = Blocks.field_150432_aD.func_176223_P();
    }

    public ThrowableBlockEntity(PlayerEntity player, BlockState blockState, BlockPos pos) {
        this((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (LivingEntity)player);
        this.blockState = blockState;
        this.setHeld(true);
    }

    public ThrowableBlockEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        this(MBEntityType.THROWABLE_BLOCK, worldIn);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_ENTITY_ID, (Object)OptionalInt.empty());
        this.field_70180_af.func_187214_a(HELD, (Object)false);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    @Nullable
    public EntityType<?> getOwnerType() {
        return this.ownerType;
    }

    public boolean isHeld() {
        return (Boolean)this.field_70180_af.func_187225_a(HELD);
    }

    private void setHeld(boolean held) {
        this.field_70180_af.func_187227_b(HELD, (Object)held);
    }

    public void func_212361_a(Entity entityIn) {
        super.func_212361_a(entityIn);
        if (entityIn != null) {
            this.field_70180_af.func_187227_b(OWNER_ENTITY_ID, (Object)OptionalInt.of(entityIn.func_145782_y()));
        }
    }

    protected float func_70185_h() {
        if (this.ownerType == EntityType.field_200729_aH) {
            return 0.04f;
        }
        if (this.ownerType == MBEntityType.MUTANT_SNOW_GOLEM) {
            return 0.06f;
        }
        return 0.01f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70067_L() {
        return this.func_70089_S() && this.ownerType != MBEntityType.MUTANT_SNOW_GOLEM;
    }

    public boolean func_70104_M() {
        return this.isHeld() && this.func_70089_S();
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn != this.func_234616_v_()) {
            super.func_70108_f(entityIn);
        }
    }

    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 60; ++i) {
                double x = this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
                double y = this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg());
                double z = this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf();
                double motx = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                double moty = 0.5f + this.field_70146_Z.nextFloat() * 2.0f;
                double motz = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 3.0f;
                this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.blockState), x, y, z, motx, moty, motz);
            }
        }
    }

    public void func_70071_h_() {
        if (this.isHeld()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70052_a(6, this.func_225510_bt_());
            }
            this.func_70030_z();
            Entity thrower = this.func_234616_v_();
            if (thrower == null) {
                Entity entity;
                OptionalInt optionalInt = (OptionalInt)this.field_70180_af.func_187225_a(OWNER_ENTITY_ID);
                if (optionalInt.isPresent() && (entity = this.field_70170_p.func_73045_a(optionalInt.getAsInt())) instanceof LivingEntity) {
                    thrower = entity;
                }
                if (thrower != null) {
                    this.func_212361_a(thrower);
                }
            } else if (thrower instanceof LivingEntity) {
                Vector3d vec = thrower.func_70040_Z();
                double x = thrower.func_226277_ct_() + vec.field_72450_a * 1.6 - this.func_226277_ct_();
                double y = thrower.func_226280_cw_() + vec.field_72448_b * 1.6 - this.func_226278_cu_();
                double z = thrower.func_226281_cx_() + vec.field_72449_c * 1.6 - this.func_226281_cx_();
                float offset = 0.6f;
                this.func_213293_j(x * (double)offset, y * (double)offset, z * (double)offset);
                this.func_213315_a(MoverType.SELF, this.func_213322_ci());
                if (!(this.field_70170_p.field_72995_K || thrower.func_70089_S() && !thrower.func_175149_v() && ((LivingEntity)thrower).func_233631_a_(MBItems.ENDERSOUL_HAND))) {
                    this.setHeld(false);
                }
            }
        } else {
            super.func_70071_h_();
        }
    }

    protected boolean func_230298_a_(Entity entity) {
        if (!super.func_230298_a_(entity)) {
            return false;
        }
        return this.ownerType != MBEntityType.MUTANT_SNOW_GOLEM || MutantSnowGolemEntity.canHarm(this.func_234616_v_(), entity);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (itemStack.func_77973_b() != MBItems.ENDERSOUL_HAND) {
            return ActionResultType.PASS;
        }
        if (this.isHeld()) {
            if (this.func_234616_v_() == player) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setHeld(false);
                    this.throwBlock((LivingEntity)player);
                }
                itemStack.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setHeld(true);
            this.func_212361_a((Entity)player);
        }
        return ActionResultType.SUCCESS;
    }

    private void throwBlock(LivingEntity thrower) {
        this.field_70177_z = thrower.field_70177_z;
        this.field_70125_A = thrower.field_70125_A;
        float f = 0.4f;
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f, -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f, MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f, 1.4f, 1.0f);
    }

    protected void func_70227_a(RayTraceResult result) {
        LivingEntity livingEntity;
        Entity thrower = this.func_234616_v_();
        LivingEntity livingEntity2 = livingEntity = thrower instanceof LivingEntity ? (LivingEntity)thrower : null;
        if (this.ownerType == MBEntityType.MUTANT_SNOW_GOLEM) {
            Entity entity;
            for (MobEntity mobEntity : this.field_70170_p.func_175647_a(MobEntity.class, this.func_174813_aQ().func_72314_b(2.5, 2.0, 2.5), this::func_230298_a_)) {
                if (!(this.func_70068_e((Entity)mobEntity) <= 6.25)) continue;
                mobEntity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)livingEntity), 4.0f + (float)this.field_70146_Z.nextInt(3));
            }
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = ((EntityRayTraceResult)result).func_216348_a()).func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)livingEntity), 4.0f) && entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
            }
            this.func_184185_a(this.blockState.func_215695_r().func_185845_c(), 0.8f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.8f);
        } else {
            boolean canOwnerPlace;
            boolean bl = canOwnerPlace = livingEntity instanceof PlayerEntity && ((PlayerEntity)livingEntity).func_175142_cm() || livingEntity instanceof MobEntity && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)livingEntity);
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
                this.func_230299_a_(blockRayTraceResult);
                if (!this.field_70170_p.field_72995_K) {
                    if (canOwnerPlace && this.blockState.func_196955_c((IWorldReader)this.field_70170_p, this.func_233580_cy_())) {
                        this.field_70170_p.func_175656_a(this.func_233580_cy_(), this.blockState);
                        this.blockState.func_177230_c().func_180633_a(this.field_70170_p, this.func_233580_cy_(), this.blockState, livingEntity, ItemStack.field_190927_a);
                        SoundType soundType = this.blockState.getSoundType((IWorldReader)this.field_70170_p, this.func_233580_cy_(), (Entity)livingEntity);
                        this.func_184185_a(soundType.func_185841_e(), (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
                    } else {
                        this.field_70170_p.func_217379_c(2001, this.func_233580_cy_(), Block.func_196246_j((BlockState)this.blockState));
                        if (canOwnerPlace && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            this.func_199703_a((IItemProvider)this.blockState.func_177230_c());
                        }
                    }
                }
            } else if (result.func_216346_c() == RayTraceResult.Type.ENTITY && !this.field_70170_p.field_72995_K) {
                Entity entity = ((EntityRayTraceResult)result).func_216348_a();
                if (entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)livingEntity), 4.0f) && entity.func_200600_R() == EntityType.field_200803_q) {
                    return;
                }
                this.field_70170_p.func_217379_c(2001, this.func_233580_cy_(), Block.func_196246_j((BlockState)this.blockState));
                if (canOwnerPlace && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a((IItemProvider)this.blockState.func_177230_c());
                }
            }
            for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(2.0), this::func_230298_a_)) {
                if (entity.func_70028_i((Entity)livingEntity) || !(this.func_70068_e(entity) <= 4.0)) continue;
                entity.func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)livingEntity), (float)(6 + this.field_70146_Z.nextInt(3)));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_218657_a("BlockState", (INBT)NBTUtil.func_190009_a((BlockState)this.blockState));
        compound.func_74757_a("Held", this.isHeld());
        if (this.ownerType != null) {
            compound.func_74778_a("OwnerType", this.ownerType.getRegistryName().toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setHeld(compound.func_74767_n("Held"));
        if (compound.func_150297_b("BlockState", 10)) {
            this.blockState = NBTUtil.func_190008_d((CompoundNBT)compound.func_74775_l("BlockState"));
        }
        if (compound.func_74764_b("OwnerType")) {
            this.ownerType = EntityType.func_220327_a((String)compound.func_74779_i("OwnerType")).orElse(null);
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.func_150787_b(Block.func_196246_j((BlockState)this.blockState));
        buffer.func_180714_a(this.ownerType == null ? "" : this.ownerType.getRegistryName().toString());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.blockState = Block.func_196257_b((int)additionalData.func_150792_a());
        this.ownerType = EntityType.func_220327_a((String)additionalData.func_150789_c(Short.MAX_VALUE)).orElse(null);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

