/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;

public class ArmorBlockItem
extends WallOrFloorItem
implements IArmorVanishable {
    private static final UUID ARMOR_MODIFIER = UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150");
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final IArmorMaterial material;

    public ArmorBlockItem(IArmorMaterial material, Block floorBlock, Block wallBlockIn, Item.Properties propertiesIn) {
        super(floorBlock, wallBlockIn, propertiesIn.func_200915_b(material.func_200896_a(EquipmentSlotType.HEAD)));
        this.material = material;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233826_i_, (Object)new AttributeModifier(ARMOR_MODIFIER, "Armor modifier", (double)material.func_200902_b(EquipmentSlotType.HEAD), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233827_j_, (Object)new AttributeModifier(ARMOR_MODIFIER, "Armor toughness", (double)material.func_200901_e(), AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        DispenserBlock.func_199774_a((IItemProvider)this, (IDispenseItemBehavior)ArmorItem.field_96605_cw);
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        return EquipmentSlotType.HEAD;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlotType armorType, Entity entity) {
        return armorType == EquipmentSlotType.HEAD;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.material.func_200900_a();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.material.func_200898_c().test(repair);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.field_77351_y == EnchantmentType.ARMOR || enchantment.field_77351_y == EnchantmentType.ARMOR_HEAD;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return slot == EquipmentSlotType.HEAD ? this.attributeModifiers : super.getAttributeModifiers(slot, stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ActionResultType actionresulttype = this.func_195942_a(new BlockItemUseContext(context));
        return actionresulttype != ActionResultType.SUCCESS ? this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a() : actionresulttype;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstack);
        ItemStack itemstack1 = playerIn.func_184582_a(equipmentslottype);
        if (itemstack1.func_190926_b()) {
            playerIn.func_184201_a(equipmentslottype, itemstack.func_77946_l());
            itemstack.func_190920_e(0);
            return ActionResult.func_233538_a_((Object)itemstack, (boolean)worldIn.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }
}

