/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class HeldBlockPacket {
    private final int entityId;
    private final int blockId;
    private final byte index;

    public HeldBlockPacket(MutantEndermanEntity mutantEnderman, int blockId, int index) {
        this.entityId = mutantEnderman.func_145782_y();
        this.blockId = blockId;
        this.index = (byte)index;
    }

    void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.entityId);
        buffer.func_150787_b(this.blockId);
        buffer.writeByte((int)this.index);
    }

    HeldBlockPacket(PacketBuffer buffer) {
        this.entityId = buffer.func_150792_a();
        this.blockId = buffer.func_150792_a();
        this.index = buffer.readByte();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.ifPresent(world -> {
                Entity entity = world.func_73045_a(this.entityId);
                if (entity instanceof MutantEndermanEntity) {
                    ((MutantEndermanEntity)entity).setHeldBlock(this.index, this.blockId, 0);
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

