/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpawnParticlePacket {
    private final IParticleData particleData;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final double speedX;
    private final double speedY;
    private final double speedZ;
    private final int amount;

    public SpawnParticlePacket(IParticleData particleData, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, int amount) {
        this.particleData = particleData;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.speedX = speedX;
        this.speedY = speedY;
        this.speedZ = speedZ;
        this.amount = amount;
    }

    void encode(PacketBuffer buffer) {
        buffer.func_150787_b(Registry.field_212632_u.func_148757_b((Object)this.particleData.func_197554_b()));
        this.particleData.func_197553_a(buffer);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
        buffer.writeDouble(this.speedX);
        buffer.writeDouble(this.speedY);
        buffer.writeDouble(this.speedZ);
        buffer.func_150787_b(this.amount);
    }

    SpawnParticlePacket(PacketBuffer buffer) {
        ParticleType particletype = (ParticleType)Registry.field_212632_u.func_148745_a(buffer.func_150792_a());
        if (particletype == null) {
            particletype = ParticleTypes.field_197610_c;
        }
        this.particleData = this.readParticle(buffer, particletype);
        this.posX = buffer.readDouble();
        this.posY = buffer.readDouble();
        this.posZ = buffer.readDouble();
        this.speedX = buffer.readDouble();
        this.speedY = buffer.readDouble();
        this.speedZ = buffer.readDouble();
        this.amount = buffer.func_150792_a();
    }

    private <T extends IParticleData> T readParticle(PacketBuffer packetBuffer, ParticleType<T> particleType) {
        return (T)particleType.func_197571_g().func_197543_b(particleType, packetBuffer);
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optional = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optional.ifPresent(world -> {
                if (this.particleData == MBParticleTypes.ENDERSOUL) {
                    for (int i = 0; i < this.amount; ++i) {
                        float f = (world.field_73012_v.nextFloat() - 0.5f) * 1.8f;
                        float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 1.8f;
                        float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 1.8f;
                        double tempX = this.posX + (double)(world.field_73012_v.nextFloat() - 0.5f) * this.speedX;
                        double tempY = this.posY + (double)(world.field_73012_v.nextFloat() - 0.5f) * this.speedY + 0.5;
                        double tempZ = this.posZ + (double)(world.field_73012_v.nextFloat() - 0.5f) * this.speedZ;
                        world.func_217404_b((IParticleData)MBParticleTypes.ENDERSOUL, true, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
                    }
                } else {
                    for (int i = 0; i < this.amount; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.02;
                        double d1 = world.field_73012_v.nextGaussian() * 0.02;
                        double d2 = world.field_73012_v.nextGaussian() * 0.02;
                        world.func_195594_a(this.particleData, this.posX, this.posY, this.posZ, d0, d1, d2);
                    }
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

