local modName = "No Skill Message Spam"
local description =
    "Your <COL YEL>skills</COL> have activated.\nBut you won't see their messages!"
local version = "Version: 2.1.0"
local author = "Made by Raff"

local modUtils = require(modName .. "/mod_utils")

local blockableSkills = {
    1686706946, -- Agitator (does send)
    1686707072, -- Bladescale Hone (does send)
    1686707060, -- Coalescence (does send)
    1686707001, -- Divine Blessing (apparently does not send)
    1686707034, -- Free Meal (does send)
    1686706981, -- Offensive Guard (apparently does not send)
    1686706947, -- Peak Performance (unknown?)
    --1686706949, -- Ressucitate (apparently does not send)
    1686706948, -- Resentment (apparently does not send)
    1686707066, -- Redirection (does send)
    1686706968, -- Spare Shot (does send)
}

local defaultBlockableSkills = {}
for _, value in ipairs(blockableSkills) do defaultBlockableSkills[tostring(value)] = true end

log.info(modName .. " loaded!")

local settings = modUtils.getConfigHandler({enabled = true}, modName)

local blockedSkillSettings = modUtils.getConfigHandler(defaultBlockableSkills,
    modName, "blockedSkills")

local modReady = modUtils.getCurrentPlayer()

local dataShortcut = sdk.find_type_definition("snow.data.DataShortcut")
local getName = dataShortcut:get_method(
    "getName(snow.data.DataDef.PlEquipSkillId)")

local skillNames = nil;
local originalChatMessage = nil;

local function initSkillNames()
    if modReady and not skillNames then
        skillNames = {}
        for _, value in ipairs(blockableSkills) do
            local skillName = getName(nil, value)
            if skillName then skillNames[value] = skillName end
        end
    end
end

-- (System.String, System.UInt32)
sdk.hook(sdk.find_type_definition("snow.gui.ChatManager"):get_method(
    "reqAddChatInfomation"), function(args)
    if not modReady or not settings.data.enabled then return end

    -- log.debug("----")
    -- local initial = 1686706968 - 23

    -- local final = 1686706968 + 150
    -- for i=initial,final,1 do log.debug(getName(nil, i) .. " - " ..tostring(i)) end
    -- log.debug("----")

    initSkillNames()

    local chatMessage = sdk.to_managed_object(args[3]):call("ToString")
    -- log.debug(chatMessage)
    -- log.info(chatMessage)

    if chatMessage then
        local cutChatMessage = chatMessage:gsub("\r\n", ""):gsub("\n", "")
        for key, value in pairs(skillNames) do
            if blockedSkillSettings.data[tostring(key)]
                and (cutChatMessage:find("<COL YEL>" .. value .. "</COL>") or cutChatMessage:find("≪" .. value .. "≫")) then
                -- log.debug("Blocked!")
                return sdk.PreHookResult.SKIP_ORIGINAL
            end
        end
    end
end)

sdk.hook(sdk.find_type_definition("snow.gui.GuiManager"):get_method(
    "notifyReturnInVillage"), function(args) modReady = true end)

initSkillNames()

-- UI code

re.on_draw_ui(function()
    if imgui.tree_node(modName) then

        settings.imgui("enabled", imgui.checkbox, "Enabled")

        if imgui.tree_node("Skill message blocks") then
            imgui.text("I don't know how to display all fonts properly here.")
            imgui.text("If any text shows up as ???, try using the mod's in-game menu.")
            imgui.text("(get it at the mod's description page)")
            if skillNames then
                for key, value in pairs(skillNames) do
                    blockedSkillSettings.imgui(tostring(key), imgui.checkbox,
                    value)
                end
            else
                imgui.text("")
                imgui.text(
                    "Wait until you're in the village for the settings to initialize.")
            end
            imgui.tree_pop()
        end

        imgui.text(version)
        imgui.text(author)
        imgui.tree_pop()
    end
end)

-- for use with @Bolt's 'Custom In-Game Mod Menu API'

function IsModuleAvailable(name)
    if package.loaded[name] then
        return true
    else
        for _, searcher in ipairs(package.searchers or package.loaders) do
            local loader = searcher(name)
            if type(loader) == 'function' then
                package.preload[name] = loader
                return true
            end
        end
        return false
    end
end

local apiPackageName = "ModOptionsMenu.ModMenuApi";
local modUI = nil;

if IsModuleAvailable(apiPackageName) then modUI = require(apiPackageName); end

if modUI then
    modUI.OnMenu(modName, description, function()
        modUI.Header("Settings")
        local changedEnabled, userEnabled =
            modUI.CheckBox("Enabled", settings.data.enabled,
                "Enable or disable the mod's functionality.")
        settings.handleChange(changedEnabled, userEnabled, "enabled")

        modUI.Header("Skill message blocks")
        if skillNames then
            for key, value in pairs(skillNames) do
                local changedEnabled, userEnabled =
                    modUI.CheckBox(value,
                        blockedSkillSettings.data[tostring(key)],
                        "Disable this skill's notification.")
                blockedSkillSettings.handleChange(changedEnabled, userEnabled,
                    tostring(key))
            end
        else
            modUI.Label(
                "Wait until you're in the village for the settings to initialize.")
        end

        modUI.Header("Credits")
        modUI.Label(version)
        modUI.Label(author, "")
    end)
end
