/**
 * [OEUI] (C)2010-2099 oephp.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * $ LastTime 2021.04,27 Update by CL $
*/
$(function(){

    function OEStatement(){
        this.api_url = _OECPFILE+'&c=statement';
        this.elm = null;
        this.clickAudit();
    }

    OEStatement.prototype={
        
        //审核
        clickAudit:function() {
            var _this = this;
            
            $(document).on("click", "[f='but_statement_audit']", function(){
                var id = $(this).attr("data-id");
                var type = $(this).attr("data-type");
                _this.elm = this;
                
                if (type == 'pass') {
                    layer.confirm("确定审核通过吗？一旦操作不可撤回！", {
                        btn: ["确定","取消"] //按钮
                    }, 
                    function(){
                        layer.closeAll();
                        _this.sendAudit(id, type);
                        
                    }, 
                    function(){
                        layer.closeAll();
                    }
                ); 
                }
                else {
                    $("#fail_dialog").show();
                }
            });
            
            //选择不通过原因
            $(document).on("click", "[f='sel_fail_type']", function(){
                var fail_type = $(this).attr('data-type');
                $("#fail_type").val(fail_type);
                
                $("[f='sel_fail_type']").removeClass('current');
                $(this).addClass('current');
                $("[f='but_submit_fail']").removeClass('bg_de').addClass('bg_main');
            });
            //关闭弹出窗口
            $(document).on("click", "[f='but_close_fail_dialog']", function(){
                $("#fail_dialog").hide();
            });
            
            //确定不通过
            $(document).on("click", "[f='but_submit_fail']", function(){
                var id = $(this).attr("data-id");
                var fail_type = $("#fail_type").val();
                if (fail_type == '') {
                    layer.msg("请选择不通过原因");
                    return false;
                }
                _this.elm = this;
                
                _this.sendAudit(id, 'fail');
            });
            
        },
        
        //发送审核
        sendAudit:function(id, type) {
            var _this = this;
            
            if (!$(_this.elm).hasClass("forbid_submit")) {
                $(_this.elm).find("i").show();
                
                var auditremark = '';
                if (type == 'fail') {
                    auditremark = $("#fail_type").val(); //不通过原因
                }
                $.ajax({
                    type: 'POST',
                    url: _this.api_url,
                    data: {
                        a:type, id:id, auditremark:auditremark
                    },
                    dataType: 'json',
                    success: function (data) {
                        var response = data.response;
                        var result = data.result;
                        
                        if (response == '1') {
                            layer.msg("操作成功");
                            setTimeout(function(){
                                window.location.reload();
                            }, 800);
                        }
                        else {
                            if (result == '' || result == null) {
                                result = '操作失败，请检查！';
                            }
                            layer.msg(result);
                        }
                        $(_this.elm).find("i").hide();
                        $(_this.elm).removeClass("forbid_submit");
                    },
                    error: function () {
                        $(_this.elm).find("i").hide();
                        $(_this.elm).removeClass("forbid_submit");
                        layer.msg("网络繁忙，请稍后再试！");
                    }
                });
            } 
        }
    }

    new OEStatement();

});