/**
 * [OEUI] (C)2010-2099 oephp.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * $ LastTime 2021.04,27 Update by BO $
 */
$(function(){

    //印章
    function OESeal (text) {
        this.canvas = null;
        this.ctx = null;
        this.company = text;

        this.createCanvas();
        this.drawBorder();
        this.drawStart();
        this.drawText();
    }
    OESeal.prototype = {
        
        createCanvas: function () {
            this.canvas = document.createElement('canvas');
            this.canvas.setAttribute('width', '200');
            this.canvas.setAttribute('height', '200');
            this.ctx = this.canvas.getContext('2d');
        },
          
        drawBorder: function () {
            this.ctx.lineWidth=6;
            this.ctx.strokeStyle="#e60012";
            this.ctx.beginPath();
            this.ctx.arc(100, 100, 94, 0, Math.PI*2);
            this.ctx.closePath();
            this.ctx.stroke();
        },
        
        drawStart: function () {
            this.ctx.save();  
            this.ctx.fillStyle='#e60012';  
            this.ctx.translate(100, 100);//移动坐标原点  
            this.ctx.rotate(Math.PI+0);//旋转  
            this.ctx.beginPath();//创建路径  
            var x = Math.sin(0);  
            var y= Math.cos(0);  
            var dig = Math.PI/5 *4;  
            for(var i = 0;i< 5;i++){//画五角星的五条边
                var x = Math.sin(i*dig);  
                var y = Math.cos(i*dig);  
                this.ctx.lineTo(x*20, y*20);
            }   
            this.ctx.closePath();  
            this.ctx.stroke();  
            this.ctx.fill();  
            this.ctx.restore();  
        },
        
        drawText: function () {
            this.ctx.textBaseline = 'middle';//设置文本的垂直对齐方式
            this.ctx.textAlign = 'center'; //设置文本的水平对对齐方式
            this.ctx.lineWidth=1;
            this.ctx.fillStyle = '#e60012';

            //绘制印章单位   
            this.ctx.translate(100, 100);// 平移到此位置,
            this.ctx.font = '900 22px Helvetica'
            var count = this.company.length;// 字数   
            var angle = 4*Math.PI/(3*(count - 1));// 字间角度   
            var chars = this.company.split("");   
            var c;
            
            for (var i = 0; i < count; i++) {
                c = chars[i];// 需要绘制的字符   
                if(i==0)
                  this.ctx.rotate(5*Math.PI/6);
                else
                  this.ctx.rotate(angle);
                this.ctx.save(); 
                this.ctx.translate(74, 0);// 平移到此位置,此时字和x轴垂直   
                this.ctx.rotate(Math.PI/2);// 旋转90度,让字平行于x轴   
                this.ctx.fillText(c, 0, 5);// 此点为字的中心点   
                this.ctx.restore();             
            }
        },
        
        export: function () {
            return this.canvas.toDataURL("image/png");
        }
    }
    
    window.OESeal = OESeal;
    //调用 var seal = new Seal('xx市xx有限公司');
    //$('#seal').attr('src', seal.export());
});
