/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 *  Last update 2020/11/06 by BO 
*/
$(function () {
    function Home () {
        this.is_http = false;
        this.follow();
        this.black();
        this.report();
        this.loadQR();
        this.contact();
        this.secretTips();
        this.mydataTips();
        this.mydataTips();
        this.addFriend();
        this.chat();
        this.goToLogin();
    }
    Home.prototype = {
        //关注会员
        follow: function () {
            var is_http = false;
            $('[f="follow"]').on('click', function () {
                if (is_http) return;
                is_http = true;

                var target = $(this);
                var el = this;
                var id = target.attr('data-id');
                var follow = target.attr('data-follow');
                var url = '';
                if (follow == '0') {
                    url = _ROOT_PATH + 'index.php?c=home&a=addlisten';
                } else {
                    url = _ROOT_PATH + 'index.php?c=home&a=dellisten';
                }

                var loading, timer;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 

                $.ajax({
                    type: 'POST',
                    url: url,
                    data: {
                        id:id
                    },
                    success: function (json) {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        var res = JSON.parse(json);
                        if (res.response == '1') {
                            if (follow == '0') {
                                target.attr('data-follow', '1').addClass('bo_eb color_9').removeClass('color_main bo_main').html('<i class="iconfont icon-xinaixin fz14 vam color_main"></i> 已关注');  
                            } else {
                                target.attr('data-follow', '0').removeClass('bo_eb color_main').addClass('color_main bo_main').html('<i class="iconfont icon-xinaixin1 fz14 vam"></i> 关注');  
                            }
                        } else {
                            if (res.result) {
                                OEUI.message.msg({text: res.result});
                            } else {
                                OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                            }
                        }
                    },
                    error: function () {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        //拉黑
        black: function () {
            var _this = this;
            $('[f="black"]').on('click', function () {
                var target = $(this);
                var id = target.attr('data-id');
                var black = target.attr('data-black');
                var el = this;
                if (black == '0') {
                    OEUI.modal.info({
                        title: '温馨提示',
                        text: '将TA拉黑后，TA不能再对你发起任何互动，TA将进入你的黑名单',
                        confirm: function () {
                            _this.httpBlack(id, 'add', el);
                        },
                        confirmText: '拉黑'
                    });
                } else {
                    _this.httpBlack(id, 'cancel', el);
                }
            });
        },
        httpBlack: function (homeuid, type, el) {
            if (this.is_http) return;
                this.is_http = true;

            var _this = this;
            var target = $(el);
            var loading, timer;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 
            $.ajax({
                type: 'POST',
                url: _ROOT_PATH + 'index.php?c=home&a=doblack',
                data: {
                    homeuid: homeuid,
                    type: type
                },
                success: function (json) {
                    _this.is_http = false;
                    clearTimeout(timer);
                    timer = null;
                    loading &&　loading.remove();
                    var res = JSON.parse(json);
                    if (res.response == '1') {
                        if (type == 'add') {
                            target.attr('data-black', '1').html('已拉黑');  
                            OEUI.message.msg({text: '拉黑成功'});
                        } else {
                            target.attr('data-black', '0').html('拉黑');  
                            OEUI.message.msg({text: '取消拉黑'});
                        }
                    } else {
                        if (res.result) {
                            OEUI.message.msg({text: res.result});
                        } else {
                            OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                        }
                    }
                },
                error: function () {
                    _this.is_http = false;
                    clearTimeout(timer);
                    timer = null;
                    loading &&　loading.remove();
                    OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                }
            });
        },
        //举报
        report: function () {
            $('[f="report"]').on('click', function () {
                var id = $(this).attr('data-id');
                window.report_dialog = OEUI.modal.dialog({
                    type: 'iframe',
                    title: '举报投诉',
                    width: 583,
                    height: 530,
                    content:  _ROOT_PATH + 'index.php?c=jubao&homeuid=' + id
                });
            });
        },
        //加载二维码
        loadQR: function () {
            setTimeout(function(){
                $("#qr_img").attr("src", _ROOT_PATH + "index.php?c=scan&a=scan&id="+ document.getElementById('userid').value+"&mod=home");
            }, 300);
        },
        //联系TA
        contact: function () {
            var _this = this;
            $('[f="contact"]').on('click', function () {
                var id = $(this).attr('data-id');
                $.ajax({
                    type: 'POST',
                    url: _ROOT_PATH + "index.php?c=view",
                    data: {
                        a:"contact", id: id
                    },
                    success: function (json) {
                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            _this.viewContact(id);
                        } else if (res.response == '2') {
                            //没有权限
                            OEUI.modal.info({
                                title: '温馨提示',
                                text: '你没有权限执行此操作，请先升级会员',
                                confirmText: '去升级',
                                confirm: function () {
                                    var back_url = _ROOT_PATH+"index.php?c=home&a=detail&id="+ id;
                                    window.location.href = _ROOT_PATH+"index.php?m=user&c=vip&fromurl="+encodeURIComponent(back_url);
                                }
                            });
                        } else if (res.response == '3') {
                            //需支付
                            _this.tipsPayView(id, res.result);
                        } else if (res.response == '4') {
                            OEUI.modal.info({
                                title: '温馨提示',
                                text: '查看次数已用完，请升级VIP或明日再查看',
                                confirm: function () {
                                    var back_url = _ROOT_PATH+"index.php?c=home&a=detail&id="+ id;
                                    window.location.href = _ROOT_PATH+"index.php?m=user&c=vip&fromurl="+encodeURIComponent(back_url);
                                },
                                confirmText: '立即升级'
                            });
                        } else if (res.response == '12') {
                            _this.tipsShowKefu(); 
                        } else {
                            //加群
                            if (res.result == "20") {
                                //跳到着陆页
                                window.location.href = _ROOT_PATH+"index.php?c=qzform&a=land&uid="+ id;
                                return false;
                            }
                            else {
                                if (res.result.length == 0) {
                                    OEUI.message.msg({text: '查看失败，请检查权限'});
                                }
                                else {
                                    OEUI.message.msg({text: res.result});
                                }
                            }
                        }
                    },
                    error: function () {
                        OEUI.message.msg({text: '网络繁忙，请稍后再试'});
                    }
                });
            });
        },
        tipsShowKefu: function () {
            $.ajax({
                type: "POST",
                url: _ROOT_PATH + "index.php?c=ajax",
                cache: false,
                data: {
                    a: "kefu"
                },
                success: function(json) {
                    var res = JSON.parse(json);
                    if (res.response == "1") {
                        OEUI.modal.dialog({
                            title: '联系客服',
                            width: '520',
                            height: '500',
                            content: res.result,
                        });
                    } else {
                        OEUI.message.msg({text: '该会员已隐藏联系方式，请与网站客服联系'});
                    }
                },
                error: function() {
                    OEUI.message.msg({text: '该会员已隐藏联系方式，请与网站客服联系'});
                }
            });
        },
        tipsPayView: function (id, fee) {
            var _this = this;
            var money_name = $('#moneyname').val() || '金币';

            OEUI.modal.info({
                title: '温馨提示',
                text: '需要支付 <font color="red">'+ fee +'</font>'+ money_name +'才可以查看',
                confirmText: '立即支付',
                confirm: function () {
                    $.ajax({
                        type: "POST",
                        url: _ROOT_PATH + "index.php?c=view",
                        data: {
                            a:"paycontact", id: id
                        },
                        success: function(json) {
                            var res = JSON.parse(json);
                            if (res.response == "1") {
                                _this.viewContact(id);
                            } else if (res.response == "2") {
                                //在线支付...
                                window.location.href = _ROOT_PATH+"index.php?c=pay&paynum="+res.result;
                            } else {
                                if (res.result.length > 0) {
                                    OEUI.message.msg({text: res.result});
                                } else {
                                    OEUI.message.msg({text: '支付失败，请检查'});
                                }
                            }
                        },
                        error: function() {
                            OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                        }
                    });
                }
            });
        },
        viewContact: function (id) {
            OEUI.modal.dialog({
                type: 'iframe',
                title: '查看联系方式',
                width: 500,
                height: 500,
                content: _ROOT_PATH+'index.php?c=view&a=contact&id='+id+'&needup=1'
            });
        },
        secretTips: function () {
            $('[f="but_secret_tips"]').on('click', function () {
                OEUI.modal.info({
                    title: '溫馨提示',
                    text: '该会员联系方式已设置保密,你可以通过私信跟TA取得联系。',
                });
            });
        },
        mydataTips: function () {
            $('[f="but_mydata_tips"]').on("click", function(){
              var tips_type = $(this).attr("data-type") || '1';
              var tips = '';
              if (tips_type == "2") {
                  tips = "您的资料审核未通过，无法进行操作。<br />点击“确定”去修改资料。";
              } else if (tips_type == '4') {
                  tips = "您已经关闭了征婚状态，请在个人中心开启，才能进行互动";
              } else if (tips_type == '5') {
                  tips = "您已经关闭了征婚状态，请在个人中心开启，才能进行互动";
              } else {
                  tips = "您的资料审核中，无法进行操作。<br />点击“确定”去修改资料。";
              }
              
              OEUI.modal.info({
                  title: '温馨提示',
                  text: tips,
                  confirm: function () {
                      if (tips_type == '4' || tips_type == '5') {
                          window.location.href = _ROOT_PATH+"index.php?m=user&c=set&nofollow=1";
                      }
                      else {
                          window.location.href = _ROOT_PATH+"index.php?m=user&c=profile&nofollow=1";
                      }
                  }
              });
          });
        },
        addFriend: function () {
            var is_send = false;
            $('[f="but_add_friend"]').on('click', function () {
                if (is_send) return;
                var id = $(this).attr("data-id");
                var target = $(this);

                var loading, timer;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?c=home",
                    data: {a:"apply", id:id, datatype:"json"},
                    success: function (json) {
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            target.addClass("bg_de bo_eb").removeClass('bo_main bg_main').find('span').html('已发申请');
                            OEUI.message.msg({text: '已发送申请，请等待对方回应'});
                            is_send = true;
                        } else {
                            //加群
                            if (res.result == "20") {
                                //跳到着陆页
                                window.location.href = _ROOT_PATH+"index.php?c=qzform&a=land&uid="+ id;
                                return false;
                            } else {
                                if (res.result.length > 0) {
                                    OEUI.message.msg({text: res.result});
                                } else {
                                    OEUI.message.msg({text: '操作失败'});
                                }
                            }
                            
                        }
                    },
                    error: function () {
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                    }
                });
            });
        },
        chat: function () {
            var is_http = false;
            $('[f="chat"]').on('click', function () {
                if (is_http) return;
                is_http = true;
                var id = $(this).attr('data-touid');
                var loading, timer;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?m=user",
                    data: {
                        c:"msgchat", a:"setsid", touid: id
                    },
                    success: function(json) {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        var res = JSON.parse(json);
                        if (res.response == "1") {
                            OEUI.modal.dialog({
                                type: 'iframe',
                                title: '发私信...',
                                width: 700,
                                height: 560,
                                content: _ROOT_PATH+"index.php?m=user&c=msgchat&sid="+ res.result
                            });
                        } else if (res.response == "2") {
                            OEUI.modal.info({
                                title: '温馨提示',
                                text: '你的资料审核中或审核不通过',
                                confirmText: '去修改',
                                cancalText: '知道了',
                                confirm: function () {
                                    window.parent.top.location.href = _ROOT_PATH+"index.php?m=user&c=profile";
                                }
                            });
                        } else if (res.response == "3") {
                            OEUI.modal.info({
                                title: '温馨提示',
                                text: '你的头像未上传或审核不通过',
                                confirmText: '去设置',
                                cancalText: '知道了',
                                confirm: function () {
                                    window.parent.top.location.href = _ROOT_PATH+"index.php?m=user";
                                }
                            });
                        } else if (res.response == "4") {
                            OEUI.modal.info({
                                title: '温馨提示',
                                text: '你的手机还未认证，请先认证',
                                confirmText: '去认证',
                                cancalText: '知道了',
                                confirm: function () {
                                    window.parent.top.location.href = _ROOT_PATH+"index.php?m=user&c=rz";
                                }
                            });
                            return false;
                        } else {
                            //加群
                            if (res.result == "20") {
                                //跳到着陆页
                                window.location.href = _ROOT_PATH+"index.php?c=qzform&a=land&uid="+ id;
                                return false;
                            } else {
                                //其他提示
                                if (res.result.length > 0) {
                                    OEUI.message.msg({text: res.result});
                                }  else {
                                    OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                                }
                            }
                        }
                        
                    },
                    error: function() {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                    }
                });
            });
        },
        goToLogin: function () {
            $('[f="to_login"]').on('click', function () {
                location.href = _ROOT_PATH + 'index.php?c=passport&a=login';
            });
        }
    }
    new Home();
});
