/**
 * [OElove] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/05 by BO $
*/
$(function() {
    function OEscroll (options) {
        var default_option = {
            time: 5000
        }
        this.option = $.extend({}, default_option, options);
        this.el = typeof this.option.el == 'Object'? this.option.el: $(this.option.el);
        if(this.el.length == 0) {
            return;
        }
        this.wrapper = this.el.find('.scroll');
        this.width = this.option.width;
        this.item = this.wrapper.children();
        this.index = 1;
        this.indicator_ele = this.el.find('.indicator span');
        this.timer = null;

        this.indicator_ele.eq(0).addClass('current');
        if(this.item.length < 2) {
            return;
        }
        
        this.init();
        this.autoPlay();
        this.stop();
        this.showCurrent();
        this.bindNext();
        this.bindPrev();
    }
    OEscroll.prototype = {
        init: function () {
            var last = this.item[this.item.length - 1].cloneNode(true);
            var first = this.item[0].cloneNode(true);
            var width = (this.item.length + 2) * this.width;
            this.wrapper.css({
                'width': width +'px',
                'left': -this.width + 'px',
                'font-size': '0',
                'position': 'relative'
            }).prepend(last).append(first);
            this.item = this.el.find('li');
            this.item.css({
                'display': 'inline-block',
                'width': this.width + 'px'
            });
        },
        next: function () {
            var _this =  this;
            this.index ++;
            this.wrapper.animate({'left': -this.index*this.width+ 'px'}, 800, 'swing', function () {
                if(_this.index > _this.item.length - 2) {
                    _this.index = 1;
                    _this.wrapper.css('left', -_this.width + 'px');
                }
            });
            this.indicator();
        },
        autoPlay: function () {
            var _this = this;
            this.timer = setInterval(function () {
              _this.next();
            }, this.option.time);
        },
        indicator: function () {
            var index = this.index - 1;
            if(this.index > this.item.length - 2) {
                index = 0;
            }
            this.indicator_ele.eq(index).addClass('bg_main').siblings().removeClass('bg_main');
        },
        stop: function () {
            var _this = this;
            this.el.on('mouseenter', function () {
                clearInterval(_this.timer);
                _this.timer = null;
            }).on('mouseleave', function () {
                _this.autoPlay();
            });
        },
        showCurrent: function () {
            var _this = this;
            this.indicator_ele.on('mouseenter', function () {
                if(_this.wrapper.is(':animated')) {
                    return;
                }
                var index = $(this).index();
                _this.index = index;
                _this.next();
            });
        },
        bindNext: function () {
            var _this = this;
            this.el.find('.next').on('click', function () {
                if(_this.wrapper.is(':animated')) {
                    return;
                }
                _this.next();
            });
        },
        prev: function () {
            var _this =  this;
            if(this.index <= 1) {
                this.index = _this.item.length - 1;
                _this.wrapper.css('left', -_this.width * this.index + 'px');
            }
            this.index --;
            this.wrapper.animate({'left': -this.index*this.width+ 'px'}, 800, 'swing');
            this.indicator();
        },
        bindPrev: function () {
            var _this = this;
            _this.el.find('.prev').on('click', function () {
                if(_this.wrapper.is(':animated')) {
                    return;
                }
                _this.prev();
            });
        }
    };
    new OEscroll({
        el: $('#banner'),
        width: window.innerWidth,
        time: 5000
    });

    function Index() {
        this.initDist();
        this.submitSearch();
        this.initBirthday();
        this.submitReg();
        this.switchUser();
    }
    Index.prototype = {
        initDist: function () {
            new Dist({
                el: $('#reg_dist'),
                dataType: '2'
            }); 
            new Dist({
                el: $('#dist'),
                dataType: '2'
            }); 
        },
        initBirthday: function () {
            new Birthday({
                el: $('#birthday'),
                range: ['18', '60']
            });
        },
        //提交搜索
        submitSearch: function () {
            $("#search_btn").on("click", function () {
                var s_gender = $("#s_gender").val();
                var s_age1 = $("#s_age1").val();
                var s_age2 = $("#s_age2").val();
                var s_dist1 = $("#s_dist1").val();
                var s_dist2 = $("#s_dist2").val();
                var s_dist3 = $("#s_dist3").val();
                var s_avatar = $("#s_avatar:checked").val() || 0;
                var url = _ROOT_PATH + "index.php?c=user&s_age1="+s_age1+"&s_age2="+s_age2+"&s_dist1="+s_dist1+
                    "&s_dist2="+s_dist2+"&s_dist3="+s_dist3+"&s_avatar="+s_avatar+'&s_gender='+ s_gender;
                location.href = url;
            })
        },
        submitReg: function () {
            $('[f="fast_reg_btn"]').on('click', function () {
                var gender = $('[name="gender"]:checked').val() || '';
                var year = $('#year').val() || '';
                var month = $('#month').val() || '';
                var date = $('#date').val() || '';
                var dist1 = $('#dist1').val() || '';
                var dist2 = $('#dist2').val() || '';
                var dist3 = $('#dist3').val() || '';
                var marry = $('#marry').val() || '';

                var url = _ROOT_PATH + 'index.php?c=passport&a=reg&gender=' + gender + '&ageyear=' + year + '&agemonth=' + month + '&ageday=' +date + '&dist1=' + dist1 + '&dist2=' + dist2 + '&dist3=' + dist3 + '&marry=' + marry;
                location.href = url;
            });
        },
        //切换会员
        switchUser: function () {
            $(document).on("click", "[f='filter_user']", function () {
                var type = $(this).attr("data-type");
                if (_LOGIN_STATUS == 0 && (type=="same_city" || type=="match_me")) {
                    location.href = _ROOT_PATH + "index.php?c=passport&a=login"
                }
                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?c=user",
                    data: {
                        a: "filter",
                        type: type
                    },
                    dataType: "json",
                    success: function (data) {
                        if (data.response == 1) {
                            $("[f='filter_user'][data-type="+type+"]").addClass("current").siblings("[f='filter_user']").removeClass("current");
                            $("#user_list").html(data.result);
                        }
                    },
                    error: function () {
                        
                    }
                })
            })
        }
    };
    new Index();

    function Notice () {
        this.getData();
    }
    Notice.prototype = {
        getData: function () {
            var _this = this;
            $.ajax({
                type: "GET",
                url: _ROOT_PATH + "index.php?c=index&a=indextip&nums=10",
                success: function (json) {
                    var data = JSON.parse(json);
                    if (data.response==1) {
                        $("#index_sitemsg").html(data.result);
                        _this.init();
                    }
                }
            });
        },
        init: function () {
            var uList = $("#index_sitemsg");
            var timer = null;
            uList.hover(function() {
                clearInterval(timer);
            },
            function() { //离开启动定时器
                timer = setInterval(function() {
                    scrollList(uList);
                },
                2000);
            }).trigger("mouseleave"); //自动触发触摸事件
            function scrollList(obj) {
                var scrollHeight = $("#index_sitemsg a:first").height();
                uList.stop().animate({
                    marginTop: -scrollHeight
                },
                600,
                function() {
                    uList.css({
                        marginTop: 0
                    }).find("a:first").appendTo(uList);
                });
            }
        }
    }
    new Notice();
});