/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 *  LastTime 2020-11-11 Update by OE 
*/
$(function () {
    function Reg() {
        this.initDist();
        this.initHome();
        this.initBirthday();
        this.initSchool();
        this.Username();
        this.Weixin();
        this.Mobile();
        this.Email();
        this.PassWord();
        this.Mobilecode();
        this.doReg();
        this.readRegProtocol();
    }
    Reg.prototype = {
        initDist: function () {
            new Dist({
                el: $('#reg_dist'),
                dataType: '2'
            });
        },
        initHome: function () {
            new Dist({
                el: $('#reg_home'),
                dataType: '2',
                type: 'home'
            });
        },
        initBirthday: function () {
            new Birthday({
                el: $('#birthday'),
                range: ['18', '60']
            });
        },
        initSchool: function () {
            new School({
                el: $('#school'),
                dataType: '2'
            });
        },
        //用户名已被注册
        _getUserName: function (name) {
            $.ajax({
                type: "POST",
                url: _ROOT_PATH+"index.php?&c=passport",
                cache: false,
                data: {
                    a:"rndname", name:name, r:get_rndnum(8)
                },
                dataType: "json",
                success: function(data) {
                    var json = eval(data);
                    var response = json.response;
                    var result = json.result;
                    if (response == "1") { //可用
                        $('#name_tip').html($(result)).closest('.oe_name_tip').show();
                    }
                },
                error: function() {
                }
            });
        },
        //检测用户名
        Username: function () {
            var _this = this;
            //关闭随机用户名
            $('[f="close_name_tip"]').on('click', function() {
                $(this).closest('.oe_name_tip').hide();
            });
            //选择随机用户名
            $(document).on('click', '[f="select_name"]', function() {
                var name = $(this).attr('data-name');
                $(this).closest('.oe_name_tip').hide();
                $('#username').val(name).blur();
            });
            //聚焦用户名
            $(document).on("focus", "#username", function(){
                $(this).siblings('.pass').hide();
                $('.oe_name_tip').hide();
            });
            //失焦校验用户名
            $(document).on("blur", "#username", function(){
                var input = $(this);
                var val = $(this).val();
                if (val.length > 0) {
                    $.ajax({
                        type: "POST",
                        url: _ROOT_PATH+"index.php?c=picker",
                        cache: false,
                        data: {
                            a:"check", check_type:"username", name:val, r:get_rndnum(8)
                        },
                        dataType: "json",
                        success: function(data) {
                            var json = eval(data);
                            var response = json.response;
                            var result = json.result;
                            if (response == "1") { //可用
                                if ($("#randname_box").css("display") == "block") {
                                    $("#randname_box").hide();
                                }
                                //2019.04.26
                                input.siblings('.pass').show();
                            }
                            else {
                                //2019.04.26
                                input.siblings('.pass').hide();

                                if (result.length > 0) {
                                    OEUI.message.msg({text: result})
                                }
                                else {
                                    OEUI.message.msg({text: "该用户名已被注册！"})
                                }
                                _this._getUserName(val);
                            }
                        },
                        error: function() {
                            //2019.04.26
                            input.siblings('.pass').hide();
                        }
                    });
                }
            });
        },
        //微信登录
        Weixin: function () {
            //弹出微信登录框...iframe
            $(document).on("click", "[f='but_open_wxlogin']", function(){
                var width = $(this).attr("data-width");
                if (typeof(width) == "undefined") {
                    width = 350;
                }
                var height = $(this).attr("data-height");
                if (typeof(height) == "undefined") {
                    height = 300;
                }
                OEUI.modal.dialog({
                    type: "iframe",
                    title: "微信扫码登录",
                    width: width,
                    height: height,
                    content: _ROOT_PATH+"index.php?c=passport&a=wxcode&r="+get_rndnum(8),
                });
            });
        },
        //手机号
        Mobile: function () {
            //校验手机号
            $(document).on("blur", "#mobile", function(){
                var input = $(this);

                var val = $(this).val();
                if (val.length > 0) {
                    $.ajax({
                        type: "POST",
                        url: _ROOT_PATH+"index.php?c=picker",
                        cache: false,
                        data: {
                            a:"check", check_type:"mobile", name:val, r:get_rndnum(8)
                        },
                        dataType: "json",
                        success: function(data) {
                            var json = eval(data);
                            var response = json.response;
                            var result = json.result;
                            if (response == "1") { //可用
                                input.siblings('.pass').show();
                            }
                            else {
                                input.siblings('.pass').hide();
                                if (result.length > 0) {
                                    OEUI.message.msg({text: result})
                                }
                                else {
                                    OEUI.message.msg({text: "该手机号已被注册，请填写另外一个"})
                                }
                            }
                        },
                        error: function() {
                            //2019.04.26
                            input.siblings('.pass').hide();
                        }
                    });
                }
            });
            //聚焦手机号
            $(document).on('focus', '#mobile', function() {
                $(this).siblings('.pass').hide();
            });
        },
        //邮箱
        Email: function () {
            //校验邮箱
            $(document).on("blur", "#email", function(){
                var input = $(this);
                var val = $(this).val();
                if (val.length > 0) {
                    $.ajax({
                        type: "POST",
                        url: _ROOT_PATH+"index.php?c=picker",
                        cache: false,
                        data: {
                            a:"check", check_type:"email", name:val, r:get_rndnum(8)
                        },
                        dataType: "json",
                        success: function(data) {
                            var json = eval(data);
                            var response = json.response;
                            var result = json.result;
                            if (response == "1") { //可用
                                //2019.04.26
                                input.siblings('.pass').show();
                            }
                            else {
                                if (result.length > 0) {
                                    OEUI.message.msg({text: result})
                                }
                                else {
                                    OEUI.message.msg({text: "该邮箱已被注册，请填写另外一个"})
                                }
                                input.siblings('.pass').hide();
                            }
                        },
                        error: function() {
                            input.siblings('.pass').hide();
                        }
                    });
                }
            });
            //聚焦邮箱
            $(document).on("focus", "#email", function(){
                $(this).siblings('.pass').hide();
            });
        },
        //密码
        PassWord: function () {
            var _this = this;
            //校验密码
            $(document).on("blur", "#password", function(){
                var val = $(this).val();
                if (val.length > 0) {
                    if (val.length < 6 || val.length > 16) {
                        OEUI.message.msg({text: "请填写6-16个字符的密码"})
                        return false;
                    }
                    if (PASSWORD_NUMBER == 1) { //含数字
                        if (!_this._hasNumber(val)) {
                            OEUI.message.msg({text: "密码必须含有数字"})
                            return false;
                        }
                    }
                    if (PASSWORD_SMALLCHAR == 1) { //含小写字母
                        if (!_this._hasSmallChar(val)) {
                            OEUI.message.msg({text: "密码必须含有小写字母"})
                            return false;
                        }
                    }
                    if (PASSWORD_BIGCHAR == 1) { //含大写字母
                        if (!_this._hasBigChar(val)) {
                            OEUI.message.msg({text: "密码必须含有大写字母"})
                            return false;
                        }
                    }
                }
                else {
                    /*
                    OEUI.message.msg({text: "请填写6-16个字符的密码"})
                    return false;
                    */
                }
                if(val != '') {
                    $(this).siblings('.pass').show();
                }
            });
            $(document).on("focus", "#password", function(){
                $(this).siblings('.pass').hide();
            });
        },
        //验证码
        Mobilecode: function () {
            //2019.04.26
            $(document).on('input', '#mobile_code', function() {
                $(this).val($(this).val().replace(/[^0-9]/g,''));
            });
        },
        //执行注册
        doReg: function () {
            var _this = this;
            $(document).on('click', '#reg_btn', function() {
                var au_mod = $("#au_mod").val();
                if (typeof(au_mod) == "undefined") {
                    au_mod = "";
                }
                var openid = $("#openid").val();
                if (typeof(openid) == "undefined") {
                    openid = "";
                }
                var au_unionid = $("#au_unionid").val();
                if (typeof(au_unionid) == "undefined") {
                    au_unionid = "";
                }
                var au_headimgurl = $("#au_headimgurl").val();
                if (typeof(au_headimgurl) == "undefined") {
                    au_headimgurl = "";
                }

                var username = $("#username").val();
                var password = $("#password").val();

                //2019.01.02 勾选隐藏手机号
                var hidemobile = $("input[name='hidemobile']:checked").val();
                if (typeof(hidemobile) == "undefined") {
                    hidemobile = 0;
                }

                var gender = $("input[name='gender']:checked").val();
                if (typeof(gender) == "undefined") {
                    gender = "";
                }
                var ageyear = $("#ageyear").val();
                var agemonth = $("#agemonth").val();
                var ageday = $("#ageday").val();
                var dist1 = $("#dist1").val();

                var dist2 = $("#dist2").val();
                if (typeof(dist2) == "undefined") {
                    dist2 = 0;
                }
                var dist3 = $("#dist3").val();
                if (typeof(dist3) == "undefined") {
                    dist3 = 0;
                }


                //9.06.11
                if (gender.length == 0 || gender == "0") {
                    OEUI.message.msg({text: "请选择您的性别"})
                    return false;
                }

                //9.06.11
                if (ageyear.length == 0 || ageyear == "0") {
                    OEUI.message.msg({text: "请设置您的生日"})
                    return false;
                }
                if (agemonth.length == 0 || agemonth == "0") {
                    OEUI.message.msg({text: "请设置您的生日"})
                    return false;
                }
                if (ageday.length == 0 || ageday == "0") {
                    OEUI.message.msg({text: "请设置您的生日"})
                    return false;
                }
                //9.06.11
                if (dist1.length == 0 || dist1 == "0") {
                    OEUI.message.msg({text: "请选择您所在城市"})
                    return false;
                }
                if (dist2.length == 0 || dist2 == "0") {
                    OEUI.message.msg({text: "请选择您所在城市"})
                    return false;
                }

                //户籍
                var home1 = "";
                var home2 = "";
                var home3 = "";
                home1 = $("#home1").val();
                if (typeof(home1) == "undefined") {
                    home1 = "";
                }
                else {
                    //9.06.11
                    if (home1.length == 0 || home1 == "0") {
                        OEUI.message.msg({text: "请选择户籍地区"})
                        return false;
                    }

                    home2 = $("#home2").val();
                    if (typeof(home2) == "undefined") {
                        home2 = "";
                    }
                    //9.07.01
                    home3 = $("#home3").val();
                    if (typeof(home3) == "undefined") {
                        home3 = "";
                    }
                }

                var marry = $("#marry").val();
                if (typeof(marry) == "undefined") {
                    marry = "";
                }
                else {
                    //9.06.11
                    if (marry.length == 0 || marry == "0") {
                        OEUI.message.msg({text: "请选择婚姻状况"})
                        return false;
                    }
                }
                var height = $("#height").val();
                if (typeof(height) == "undefined") {
                    height = 0;
                }
                else {
                    //9.06.11
                    if (height.length == 0 || height == "0") {
                        OEUI.message.msg({text: "请选择身高"})
                        return false;
                    }
                }
                var weight = $("#weight").val();
                if (typeof(weight) == "undefined") {
                    weight = 0;
                }
                else {
                    //9.06.11
                    if (weight.length == 0 || weight == "0") {
                        OEUI.message.msg({text: "请选择体重"})
                        return false;
                    }
                }
                var education = $("#education").val();
                if (typeof(education) == "undefined") {
                    education = 0;
                }
                else {
                    //9.06.11
                    if (education.length == 0 || education == "0") {
                        OEUI.message.msg({text: "请选择学历"})
                        return false;
                    }
                }
                var job = $("#job").val();
                if (typeof(job) == "undefined") {
                    job = 0;
                }
                else {
                    //9.06.11
                    if (job.length == 0 || job == "0") {
                        OEUI.message.msg({text: "请选择职业"})
                        return false;
                    }
                }
                
                var salary = $("#salary").val();
                if (typeof(salary) == "undefined") {
                    salary = 0;
                }
                else {
                    //9.06.11
                    if (salary.length == 0 || salary == "0") {
                        OEUI.message.msg({text: "请选择年收入"})
                        return false;
                    }
                }
                
                var sort = $("#sort").val();
                if (typeof(sort) == "undefined") {
                    sort = "";
                }
                else {
                    //9.06.11
                    if (sort.length == 0 || sort == "0") {
                        OEUI.message.msg({text: "请选择交友类型"})
                        return false;
                    }
                }
                var house = $("#house").val();
                if (typeof(house) == "undefined") {
                    house = 0;
                }
                else {
                    //9.06.11
                    if (house.length == 0 || house == "0") {
                        OEUI.message.msg({text: "请选择购房情况"})
                        return false;
                    }
                }
                var car = $("#car").val();
                if (typeof(car) == "undefined") {
                    car = 0;
                }
                else {
                    //9.06.11
                    if (car.length == 0 || car == "0") {
                        OEUI.message.msg({text: "请选择购车情况"})
                        return false;
                    }
                }
                var scharea1 = $("#scharea1").val();
                if (typeof(scharea1) == "undefined") {
                    scharea1 = 0;
                }
                var schid = $("#schid").val();
                if (typeof(schid) == "undefined") {
                    schid = 0;
                }
                else {
                    if (schid < 1) {
                        OEUI.message.msg({text: "请选择毕业院校"})
                        return false;
                    }
                }
                //2019.01.02
                var truename = $("#truename").val();
                if (typeof(truename) == "undefined") {
                    truename = "";
                }
                else {
                    if (truename.length == 0) {
                        OEUI.message.msg({text: "请填写真实姓名"})
                        return false;
                    }
                }
                var weixin = $("#weixin").val();
                if (typeof(weixin) == "undefined") {
                    weixin = "";
                }
                else {
                    if (weixin.length == 0) {
                        OEUI.message.msg({text: "请填写微信号"})
                        return false;
                    }
                }

                //2019.01.02
                var qq = $("#qq").val();
                if (typeof(qq) == "undefined") {
                    qq = "";
                }
                else {
                    if (qq.length == 0) {
                        OEUI.message.msg({text: "请填写QQ号"})
                        return false;
                    }
                }

                //8.07.31
                var email = $("#email").val();
                if (typeof(email) == "undefined") {
                    email = "";
                }
                else {
                    if (email.length == 0) {
                        OEUI.message.msg({text: "请填写邮箱地址"})
                        return false;
                    }
                }

                if (username.length == 0) {
                    OEUI.message.msg({text: "请填写用户名"})
                    return false;
                }

                var mobile = $("#mobile").val();
                if (typeof(mobile) == "undefined") {
                    mobile = "";
                    var mobile_code = "";
                }
                else {
                    if (mobile.length == 0) {
                        OEUI.message.msg({text: "请填写手机号码"});
                        return false;
                    }
                    var mobile_code = $("#mobile_code").val();
                    if (typeof(mobile_code) == "undefined") {
                        mobile_code = "";
                    }
                    else {
                        if (mobile_code.length == 0) {
                            OEUI.message.msg({text: "请填写手机验证码"});
                            return false;
                        }
                    }
                }

                if (password.length < 6 || password.length > 16) {
                    OEUI.message.msg({text: "请填写6-16个字符的密码"})
                    return false;
                }
                if (PASSWORD_NUMBER == 1) { //含数字 8.01.31
                    if (!_this._hasNumber(password)) {
                        OEUI.message.msg({text: "密码必须含有数字"})
                        return false;
                    }
                }
                if (PASSWORD_SMALLCHAR == 1) { //含小写字母 8.01.31
                    if (!_this._hasSmallChar(password)) {
                        OEUI.message.msg({text: "密码必须含有小写字母"})
                        return false;
                    }
                }
                if (PASSWORD_BIGCHAR == 1) { //含大写字母 8.01.31
                    if (!_this._hasBigChar(password)) {
                        OEUI.message.msg({text: "密码必须含有大写字母"})
                        return false;
                    }
                }
                var agree = $("input[name='agree']:checked").val();
                if (typeof(agree) == "undefined") {
                    agree = "";
                }
                if (agree != "1") {
                    OEUI.message.msg({text: "请勾选同意会员注册协议"})
                    return false;
                }

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH + "index.php?c=passport",
                    cache: false,
                    data: {
                        a:"regpost", mobile:mobile, mobilecode:mobile_code, username:username, password:password,
                        hidemobile:hidemobile, //2019.01.02
                        email:email, gender:gender, ageyear:ageyear, agemonth:agemonth, ageday:ageday,
                        dist1:dist1, dist2:dist2, dist3:dist3, home1:home1, home2:home2, home3:home3, sort:sort, marry:marry,
                        height:height, weight:weight, education:education, job:job, salary:salary, car:car, house:house,
                        scharea1:scharea1, schid:schid, truename:truename, weixin:weixin, qq:qq, //2019.01.02
                        au_mod:au_mod, openid:openid, au_unionid:au_unionid, au_headimgurl:au_headimgurl,
                        r:get_rndnum(8)
                    },
                    dataType: "json",
                    success: function(data) {
                        var json = eval(data);
                        var response = json.response;
                        var result = json.result;
                        if (response == "1") { //成功，返回页面
                            var forward = $("#forward").val();
                            if (typeof(forward) == "undefined") {
                                forward = "";
                            }
                            window.location.href = _ROOT_PATH+"index.php?c=passport&a=headimg&forward="+encodeURIComponent(forward);
                        }
                        else if (response == "2") { //整合OEmarry
                            window.top.location.href = result;
                        }
                        else {
                            if (result.length > 0) {
                                OEUI.message.msg({text: result})
                            }
                            else {
                                OEUI.message.msg({text: "注册失败，请检查会员资料！"});
                            }
                        }
                    },
                    error: function() {
                        OEUI.message.msg({text: "系统繁忙，请稍后再试！"});
                    }
                });
            });
        },
        //验证是否含有数字
        _hasNumber: function (value) {
            var bool = false;
            var Letters = "1234567890";
            for(var i=0;i<value.length;i++) {
                var c = value.charAt(i);
                if (Letters.indexOf(c) != -1) {
                    bool = true;
                    break;
                }
            }
            return bool;
        },
        //验证是否含有小写字母
        _hasSmallChar: function (value) {
            var bool = false;
            var Letters = "abcdefghijklnmopqrstuvwxyz";
            for(var i=0;i<value.length;i++) {
                var c = value.charAt(i);
                if (Letters.indexOf(c) != -1) {
                    bool = true;
                    break;
                }
            }
            return bool;
        },
        //验证码是否含有大写字母
        _hasBigChar: function (value) {
            var bool = false;
            var Letters = "ABCDEFGHIJKLNMOPQRSTUVWXYZ";
            for(var i=0;i<value.length;i++) {
                var c = value.charAt(i);
                if (Letters.indexOf(c) != -1) {
                    bool = true;
                    break;
                }
            }
            return bool;
        },
        //查看注册协议
        readRegProtocol: function () {
            $('[f="read_reg_protocol"]').on('click', function () {
                OEUI.modal.dialog({
                    title: '注册协议',
                    type: 'iframe',
                    width: 800,
                    height: 500,
                    content: _ROOT_PATH + 'index.php?c=passport&a=clause'
                });
            });
        }
    };
    new Reg();
});