<?php
/**
 * Copyright (C) OElove All rights reserved.
 * <E-Mail：service@phpcoo.com>
 * Url http://www.phpcoo.com
 *     http://www.oephp.com
 *     http://www.oemarry.com
 * Update 2018.09.04
 */
header("Content-type: text/html; charset=utf-8");
@set_time_limit(0);
@error_reporting(E_ALL & ~ E_NOTICE);
define("BASE_ROOT", substr(dirname(__FILE__), 0, -19));
require_once(BASE_ROOT."source/core/oephp/Application.php");
APP::run("index");
$m_login = M('passport', 'im');
list($login_status, $login_uid) = $m_login->validLoginUser();
if (false === $login_status){
    echo 'login fail';
    die();
}
unset($m_login);
require_once("JSON.php");
$php_path = dirname(__FILE__) . '/';
$php_url = dirname($_SERVER['PHP_SELF']) . '/';
$save_path = BASE_ROOT."data/attachment/upload/"; //文件保存路径
$save_url = PATH_URL."data/attachment/upload/"; //文件保存路径
//定义允许上传的文件扩展名
$ext_arr = array(
	'image' => array('gif', 'jpg', 'jpeg', 'png', 'bmp'),
	'flash' => array('swf', 'flv'),
	'media' => array('swf', 'flv', 'mp3', 'wav', 'wma', 'wmv', 'mid', 'avi', 'mpg', 'rm', 'rmvb'),
	'file' => array('doc', 'docx', 'xls', 'xlsx', 'txt', 'zip', 'rar', 'gz'),
);
//最大上传
$php_upload_maxsize = @ini_get("upload_max_filesize");
$cfg_upload_maxsize = intval(OE::$cfg['uploadmaxsize']);
if ($cfg_upload_maxsize > $php_upload_maxsize) {
    $cfg_upload_maxsize = $php_upload_maxsize;
}
$max_size = ($cfg_upload_maxsize*1024000);
$save_path = realpath($save_path) . '/';
//PHP上传失败
if (!empty($_FILES['imgFile']['error'])) {
	switch($_FILES['imgFile']['error']){
		case '1':
			$error = '超过php.ini允许的大小。';
			break;
		case '2':
			$error = '超过表单允许的大小。';
			break;
		case '3':
			$error = '图片只有部分被上传。';
			break;
		case '4':
			$error = '请选择图片。';
			break;
		case '6':
			$error = '找不到临时目录。';
			break;
		case '7':
			$error = '写文件到硬盘出错。';
			break;
		case '8':
			$error = 'File upload stopped by extension。';
			break;
		case '999':
		default:
			$error = '未知错误。';
	}
    editor_alert($error);
}
//有上传文件时
if (empty($_FILES) === false) {
	$file_name = $_FILES['imgFile']['name']; //原文件名
	$tmp_name = $_FILES['imgFile']['tmp_name']; //服务器上临时文件名
	$file_size = $_FILES['imgFile']['size']; //文件大小
    $tmp_name = str_replace('\\\\', '\\', $tmp_name);
	//检查文件名
	if (!$file_name) {
		editor_alert("请选择文件。");
	}
	//检查目录
	if (@is_dir($save_path) === false) {
        editor_alert("上传目录不存在。");
	}
	//检查目录写权限
	if (@is_writable($save_path) === false) {
        editor_alert("上传目录没有写权限。");
	}
	if (@is_uploaded_file($tmp_name) === false) {
        editor_alert("上传失败。");
	}
	//检查文件大小
	if ($file_size > $max_size) {
        editor_alert("上传文件大小超过限制。");
	}
	//检查目录名
	$dir_name = empty($_GET['dir']) ? 'image' : trim($_GET['dir']);
	if (empty($ext_arr[$dir_name])) {
        editor_alert("目录名不正确。");
	}
	//获得文件扩展名
	$temp_arr = explode(".", $file_name);
	$file_ext = array_pop($temp_arr);
	$file_ext = trim($file_ext);
	$file_ext = strtolower($file_ext);
	//检查扩展名
	if (in_array($file_ext, $ext_arr[$dir_name]) === false) {
        editor_alert("上传文件扩展名是不允许的扩展名。\n只允许" . implode(",", $ext_arr[$dir_name]) . "格式。");
	}
	$ymd = date("Ymd");
	$save_path .= $ymd . "/";
	$save_url .= $ymd . "/";
	if (!file_exists($save_path)) {
        @mkdir($save_path);
        @chmod($save_path, 0777);
	}
	//新文件名
	$new_file_name = date("YmdHis") . '_' . rand(10000, 99999) . '.' . $file_ext;
	//移动文件
	$file_path = $save_path . $new_file_name;
	if (move_uploaded_file($tmp_name, $file_path) === false) {
        editor_alert("上传文件失败。");
	}
	@chmod($file_path, 0644);
    //检查内容合法化 8.09.04
    _checkUploadLegal($file_path);

	$file_url = $save_url . $new_file_name;
	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 0, 'url' => $file_url));
	exit;
}
//信息提示
function editor_alert($msg) {
	header('Content-type: text/html; charset=UTF-8');
	$json = new Services_JSON();
	echo $json->encode(array('error' => 1, 'message' => $msg));
	exit;
}

//读取上传源码... 8.09.04
function _readUploadOver($fileName, $method = 'rb') {
    $data = '';
    if ($handle = @fopen($fileName, $method)) {
        @flock($handle, LOCK_SH);
        $data = @fread($handle, filesize($fileName));
        @fclose($handle);
    }
    return $data;
}

//检测上传源...合法性 8.09.04
function _checkUploadLegal($file) {
    $file_content = _readUploadOver($file);
    if (!empty($file_content)) {
        $forbid_chars = array(
            '0'=>"?php",
            '1'=>"cmd.exe",
            '2'=>"mysql_connect",
            '3'=>"phpinfo()",
            '4'=>"get_current_user",
            '5'=>"zend",
            '6'=>"_GET",
            '7'=>"_POST",
            '8'=>"_REQUEST",
            '9'=>"base64_decode",
            '10'=>"echo",
            '11'=>"?PHP",
            '12'=>"<%eval",
            '13'=>"<%EVAL",
            '14'=>"request",
            '15'=>"Request",
            '16'=>"<%=",
        );
        foreach ($forbid_chars as $key=>$value) {
            if (stripos($file_content, $value)) {
                @unlink($file);
                editor_alert("上传内容不合法！");
                break;
            }
        }
    }
}
?>