/**
 * [OElove] (C)2010-2099 OElove.com
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/11/10 by BO $
*/
$(function () {
    function Diary () {
        this.publish();
        this.switchVerify();
        this.initUpload();
    }
    Diary.prototype = {
        publish: function () {
            var is_http = false; 
            $('[f="publish"]').on('click', function () {
                var thumbimg = $("#img_thumb").val();
                var drawimg = $("#img_url").val();
                var title = $("#title").val();
                var content = myeditor.html();
                var checkcode = $("#checkcode").val();

                if (title == '') {
                    OEUI.message.msg({text: '请填写日记标题'});
                    return false;
                }
                if (content == '') {
                    OEUI.message.msg({text: '请填写日记内容'});
                    return false;
                }
                if (checkcode == '') {
                    OEUI.message.msg({text: '请填写验证码'});
                    return false;
                }

                if (is_http) return;
                is_http = true;

                var loading, timer, el = this;
                timer = setTimeout(function () {
                    loading = OEUI.loading({
                        el: el,
                        color: '#666'
                    });
                    loading.show();
                }, 200); 

                $.ajax({
                    type: "POST",
                    url: _ROOT_PATH+"index.php?m=user&c=diary",
                    data: {
                        a:"saveadd", title: title, content: content, 
                        thumbimg: thumbimg, drawimg: drawimg, checkcode: checkcode
                    },
                    success: function(json) {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();

                        var res = JSON.parse(json);
                        
                        if (res.response == "1") {
                            OEUI.message.msg({text: '发表成功'});
                            setTimeout(function(){
                                window.parent.location.reload();
                            }, 500);
                        } else {
                            if (res.result.length > 0) {
                                OEUI.message.msg({text: res.result});
                            } else {
                                OEUI.message.msg({text: '发布失败'});
                            }
                        }
                    },
                    error: function() {
                        is_http = false;
                        clearTimeout(timer);
                        timer = null;
                        loading &&　loading.remove();
                        OEUI.message.msg({text: '系统繁忙，请稍后再试'});
                    }
                }); 
            });
        },
        switchVerify: function () {
            $('#img_code').on('click', function () {
                var target = $(this);
                var url = target.attr('src');

                target.attr('src', url + '&r='+ parseInt(Math.random() * 1000));
            });
        },
        initUpload: function () {
            if (typeof Uploader == 'undefined') return;
            var loading;
            var upload = new Uploader({
                el: document.getElementById('uploader'),
                url: _OE_FILE+"&c=index&a=upload&module=diary&thumbfiles=1&forbidwater=1",
                data: {
                  uploadpart: 'file'
                }
            });
            upload.on('beforeUpload', function (e) {
                var file = e.target.files[0];
                var regexp = /.(gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG)$/;
                if (!regexp.test(file.name)) {
                    OEUI.message.msg({ text: '请上传gif|GIF|jpg|JPG|jpeg|JPEG|png|PNG格式的图片' });
                    return false;
                }
                loading = OEUI.loading({
                  el: document.getElementById('uploader'),
                  color: '#999',
                  width: 30,
                  height: 30
                });
                loading.show();
                return true;
            });
            upload.on('success', function (res) {
                $('#cover').attr('src', res.uploadimg).show();
                $('#img_thumb').val(res.thumbimg);
                $('#img_url').val(res.uploadimg);
                loading.remove();
            });
            upload.on('error', function () {
                loading.remove();
            });
        },
    }
    new Diary();
});