/**
 * [OElove webapp] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.04.14 Update by bo $
*/
var _inst_oeslide = null; //
var _inst_oeemoji = null; //表情 通用
$(function(){
    //表情切换
    var OESlide = {
        slide: null,
        currentPageIndex: 0,
        playTimer: 0,
        mounted: function mounted() {
          this.init();
        },
        beforeDestroy: function beforeDestroy() {
          clearTimeout(this.playTimer);
          this.slide.destroy();
        },
        init: function init() {
          var _this2 = this;

          clearTimeout(this.playTimer);
          var nodeList = document.querySelectorAll('#emoji .item');
          var length = nodeList.length;

          if (length < 2) {
            return;
          }

          var clientW = document.body.clientWidth;
          document.querySelector('#emoji .wrapper').style.width = (length + 2) * clientW + 'px';
          $('#emoji .item').css('width', clientW + 'px');
          this.slide = new BScroll(document.getElementById('emoji'), {
            scrollX: true,
            scrollY: false,
            snap: {
              loop: true,
              // 开启循环播放
              stepX: clientW,
              // 每页宽度为 200px
              threshold: 0.2,
              // 滚动距离超过宽度/高度的 30% 时切换图片
              speed: 400 // 切换动画时长 400ms

            },
            click: true,
            useTransition: true,
            momentum: false,
            bounce: false,
            stopPropagation: true
          });
          this.slide.on('scrollEnd', function () {
            var pageIndex = _this2.slide.getCurrentPage().pageX;

            _this2.currentPageIndex = pageIndex;
            $('#emoji .indicator span').eq(pageIndex).addClass('current').siblings().removeClass('current');

            _this2.autoGoNext();
          }); // user touches the slide area

          this.slide.on('beforeScrollStart', function () {
            clearTimeout(_this2.playTimer);
          }); // user touched the slide done

          this.slide.on('scrollEnd', function () {
            _this2.autoGoNext();
          });
          window.bs = this.slide;
          this.autoGoNext();
        },
        nextPage: function nextPage() {
          this.slide.next();
        },
        prePage: function prePage() {
          this.slide.prev();
        },
        _onScrollEnd: function _onScrollEnd() {
          var pageIndex = slide.slide.getCurrentPage().pageX;
          slide.currentPageIndex = pageIndex;
          $('#emoji .indicator span').eq(pageIndex).addClass('current').siblings().removeClass('current');
          slide.autoGoNext();
        },
        autoGoNext: function autoGoNext() {
         
        }
    };
    _inst_oeslide = OESlide;
    
    
    //表情输入
    function OEEmoji() {
        this.isInitSlide = false;
        this.emojiBox = $('#emoji');
        this.textarea = $('#content');

        this.setEditable();
        //this.showEmojiSelector();
        this.selectEmoji();
        this.focus();
    }
    OEEmoji.prototype = {
        //设置元素可编辑
        setEditable: function () {
            this.textarea[0].designMode = 'On';  //打开设计模式
            this.textarea[0].contentEditable = 'plaintext-only';// 设置元素为可编辑
        },
        //显示表情
        showEmojiSelector: function () {
            var _this = this;
            
            if(_this.emojiBox.is(':hidden')) {
                _this.emojiBox.show();
            } else {
                _this.emojiBox.hide();
            }
            if(!_this.isInitSlide) {
                _inst_oeslide.mounted();   
                _this.isInitSlide = true;             
            } 
        },
        
        //选择表情
        selectEmoji: function () {
            var _this = this;
            $(document).on('click', '[f="but_select_face"]', function (e) {
                var id = e.currentTarget.dataset.id;
                var emoji = '<img src="../../tpl/static/images/face/'+ id +'.gif" data-id="'+ id +'">';
                _this.textarea[0].contentEditable = true;// 设置元素为可编辑
                _this.insertEmoji(emoji);
                setTimeout(function () {
                    _this.textarea[0].contentEditable = 'plaintext-only';// 设置元素为可编辑
                }, 100);
            });
        },

        //输入框插入表情
        insertEmoji: function (emoji) {
            const el = this.textarea[0];
            const sel = window.getSelection();
            const select_content = sel.toString(); //获取选中内容
            if(select_content != '') {
                document.execCommand('delete');  //删除选中部分
                const range = document.createRange();
                range.selectNodeContents(el);
                range.collapse(false);
                sel.removeAllRanges();
                sel.addRange(range);
                document.execCommand('insertHTML', false, emoji);
            }else {
                if(sel.anchorNode) {
                    const range = sel.getRangeAt(0);
                    range.deleteContents();
                    range.collapse(true);
                    sel.removeAllRanges();
                    sel.addRange(range);
                } else {  //输入框没有获取光标，获取光标并将光标位置移动到末尾
                    const range = document.createRange();
                    range.selectNodeContents(el);
                    range.collapse(false);
                    sel.removeAllRanges();
                    sel.addRange(range);
                }
                document.execCommand('insertHTML', false, emoji);
            } 
        },
        //点击表情图标获取焦点
        focus: function () {
            this.textarea.on('click', 'img', function() {
                var em_sel, em_range;
                if (window.getSelection) {
                    em_sel = window.getSelection();
                    if (em_sel.getRangeAt && em_sel.rangeCount) {
                        em_range = em_sel.getRangeAt(0);
                        em_range.deleteContents();
                        em_range.setStartBefore(this);
                        em_range.collapse(true);
                        em_sel.removeAllRanges();
                        em_sel.addRange(em_range);
                    }
                }
            });
        }
    }
    _inst_oeemoji = new OEEmoji();
});