/**
 * [OElove Webapp] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/13 by bo $
*/
$(function () {
    
    function OEFriendApply () {
        this.api_url = WAP_APPFILE+'&c=friendapply';
        
        this.id = '';
        this.wake();
    }
    
    OEFriendApply.prototype = {
        
        //触发
        wake:function() {
            var _this = this;

            //删除
            $(document).on("click", "[f='but_del_apply']", function(){
                _this.id = $(this).attr("data-id");
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定要删除吗？',
                    confirm: function () {
                        _this.submitDo('delete');
                    }
                });
            });
            
            //同意
            $(document).on("click", "[f='but_agree']", function(){
                _this.id = $(this).attr("data-id");
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定同意通过吗？',
                    confirm: function () {
                        _this.submitDo('agree');
                    }
                });
            });
            
            //拒绝
            $(document).on("click", "[f='but_refuse']", function(){
                _this.id = $(this).attr("data-id");
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定拒绝吗？',
                    confirm: function () {
                        _this.submitDo('refuse');
                    }
                });
            });
        },
        
        //执行操作
        submitDo:function($type) {
            var _this = this;
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data:{
                    a:$type, id:_this.id
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == "1") { 
                        if ($type == 'delete') {
                            OEUI.toast({
                                type: 'bottom',
                                text: '删除成功'
                            });
                            $("#list_"+_this.id).remove();
                        }
                        else {
                            OEUI.toast({
                                type: 'bottom',
                                text: '操作成功'
                            });
                            
                            setTimeout(function(){
                                window.location.reload();
                            }, 800);
                        }
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '操作失败，请检查';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });
                
        }
    }
    new OEFriendApply();
});