/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/26 by CL $
*/
var _inst_photo = null;
$(function () {
    function OEPhoto () {
        this._this_dialog = '';
        this.slide_time = 300;
        
        this.api_url = WAP_APPFILE+"&c=photo";
        this.ids = ''; //已选相册
        this.obj_id = '';
        
        this.wake();
    }
    
    OEPhoto.prototype = {
        
        wake: function () {
            var _this = this;
            
            //管理/取消
            $(document).on("click", "[f='but_sel_manage']", function(){
                if ($(this).hasClass('managed')) {
                    $(this).removeClass('managed');
                    $(this).html('管理');
                    $("[f='but_sel_item']").attr("data-type", "");
                    $(".select_item").hide();
                    $(".select_item").find('.icon-tubiao-xuanze').hide();
                    $(".select_item").find('.icon-xuanze1').hide();
                    $("#sel_nums").html('0');
                }
                else {
                    $(this).addClass('managed');
                    $(this).html('取消');
                    $("[f='but_sel_item']").attr("data-type", "manage");
                    $(".select_item").show();
                    $(".select_item").find('.icon-tubiao-xuanze').show();
                    $(".select_item").find('.icon-xuanze1').hide();
                    $("#sel_nums").html('0');
                }
            });
            
            //选中
            $(document).on("click", "[f='but_sel_item']", function(){
                if ($(this).attr("data-type") == 'manage') {
                    
                    if ($(this).find(".select_item .icon-xuanze1").css('display') == 'none') {
                        $(this).find(".select_item .icon-xuanze1").show(); //当选
                        $(this).find(".select_item .icon-tubiao-xuanze").hide(); 
                    }
                    else {
                        $(this).find(".select_item .icon-xuanze1").hide(); //未选
                        $(this).find(".select_item .icon-tubiao-xuanze").show(); 
                    }
                    _this.checkSel();
                } 
            });
            
            //删除
            $(document).on("click", "[f='but_del']", function(){
                _this.obj_id = $(this).attr("id");
                if (_this.ids == '') {
                   OEUI.toast({
                        type: 'bottom',
                        text: '请选择要删除的照片'
                    });
                    return;
                }
                var $send_data = {
                    'a':'del', 'ids':_this.ids
                };
                OEUI.confirm({
                    title: '温馨提示',
                    text: '确定要删除选中的照片吗？',
                    confirm: function () {
                        _this.sendDel($send_data);
                    }
                });
                
            });
            
            //关闭vip
            $(document).on("click", "[f='close_vip_dialog']", function(){
                _this.closeVipDialog();
            });
        },
        
        //统计已选相册
        checkSel:function() {
            var _this = this;
            var $id = '';
            var $nums = 0;
            _this.ids = ''; //重置
            $("#pull_data dl").each(function(iv, elm){
                //当选
                if ($(this).find(".select_item .icon-xuanze1").css('display') != 'none') {
                    $id = $(this).attr("data-id");
                    if (_this.ids == '') {
                        _this.ids = $id;
                    }
                    else {
                        _this.ids += ','+$id;
                    }
                    $nums++;
                }
            });
            $("#sel_nums").html($nums);
        },
        
        //发送删除
        sendDel:function($send_data) {
            var _this = this;
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);

                $.ajax({
                    type: 'POST',
                    url: _this.api_url,
                    data: $send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') {
                            OEUI.toast({
                                type: 'bottom',
                                text: '删除成功'
                            }); 
                            setTimeout(function(){
                                window.location.reload();
                            }, 1000);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '操作失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            }
        }, 
        
        //弹出vip提示
        openVipDialog:function() {
            var _this = this;
            _this._this_dialog = OEUI.Dialog({
                el: '#vip_dialog',
                animated: 'zoomIn',
                time:_this.slide_time
            }); 
        },
        //关闭vip提示
        closeVipDialog:function() {
            var _this = this;
            if (_this._this_dialog) {
                _this._this_dialog.hide();
            }
        }
    }
    _inst_photo = new OEPhoto();
});