/**
 * [OElove] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.17 Update by BO&CL $
*/
var _inst_oephoto_multi = null;
$(function(){
    var $file_i = 1;
    var $up_attids = ''; //记录已上传的id
    //照片批量上传类
    function OEUpload () {
        this.obj_id = ''; //点击按钮
        
        this.up_apiurl = _ROOT_PATH+'index.php?m=wap&c=cp&a=ajaxupload';
        this._callback = null; //回调
        this.fileNode = ''; //file节点
        this.can_upload_nums = 0; //可上传数量
        this.max_select_nums = 0; //最多可选数量 
        
        this.triggerUpload();
    }
    
    OEUpload.prototype = {
        
        //点击触发f='but_upload'
        triggerUpload:function() {
            var _this = this;
            
            
            $(document).on("click", "[f='but_upload']", function(){
                
                //校验数量
                _this.can_upload_nums = parseInt($("#remain_photos").val());
                if (_this.can_upload_nums == 0){
                    if (_inst_photo) {
                        _inst_photo.openVipDialog();
                    }
                    else {
                        OEUI.toast({
                            type: 'bottom',
                            text: '相册已满，请升级VIP'
                        }); 
                    }
                    return;
                }
                if (_this.can_upload_nums > 9) {
                    _this.max_select_nums = 9;
                }
                else {
                    _this.max_select_nums = _this.can_upload_nums;
                }
                
                
                var $node = $(this).attr("data-file");
                _this.fileNode = $node;
                _this.listenUpload(); //change事件只绑定一次
                $("#"+$node).click(); //file事件
            });
        },
        
        //执行上传
        listenUpload:function() {
            var _this = this;
            $(document).off("change."+_this.fileNode);
            $(document).on("change."+_this.fileNode, "#"+_this.fileNode, function(e){
                
                var $name = e.target.dataset.name; //input的名字
                if (typeof($name) == 'undefined') {
                    $name = '';
                }
                
                //校验数量
                var $file_nums = e.target.files.length;
                if ($file_nums > _this.max_select_nums) {
                    OEUI.toast({
                        type: 'bottom',
                        text: "每次最多同时上传"+_this.max_select_nums+"张照片"
                    }); 
                    return;
                }
                var api_url = _this.up_apiurl+"&module=photo"+
                                "&thumbfiles=1&forbidcom=0"+
                                "&forbidwater=0&thumb=1";
                
                $file_i = 1;
                //循环
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $up_attids = ''; //记录已上传的id
                $.each(e.target.files, function(iv, elm){
                    //弹窗进度条
                    $("#up_progress").show();
                    $("#order_i").html($file_i);
                    $("#order_nums").html($file_nums);

                    if(!elm.type) {
                        var a = new FileReader();
                        a.onload = function (e) {
                            var base64 = e.target.result;
                            var file = elm;
                            var fd = new FormData();
                            fd.append('uploadpart', 'file');
                            fd.append('a', 'base64upload');
                            var src = base64.replace(/data:;base64,/, 'data:image/jpg;base64,');
                            fd.append('base64img', src);
                            
                            var img = new Image();
                            img.src = src;
                            img.onload = function () {
                              $('#pull_data').append(img);
                            }
                            
                            _this.execAjax(api_url, fd, loading, timer, $file_nums, $up_attids);
                        }
                        a.onerror = function(){
                            console.log("读取图片错误");
                            $file_i = ($file_i+1); //继续循环
                        }
                        a.readAsDataURL(elm);  
                    } else {
                        var file = elm;
                        var fd = new FormData();
                        fd.append('uploadpart', 'file');
                        fd.append('file', file);
                        
                        _this.execAjax(api_url, fd, loading, timer, $file_nums);
                    }
                    
                });
                
            });
        },
        //执行ajax
        execAjax: function (api_url, fd, loading, timer, $file_nums) {
            var _this = this;
            $.ajax({
                type: 'POST',
                url: api_url,
                data: fd,
                processData: false,
                contentType: false,
                success: function (retdata) {
                    console.log(retdata);
                    clearTimeout(timer);
                    time = null;
                    loading && loading.hideLoading();
                    
                    var $json = JSON.parse(retdata);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    if ($json.response == '1') {
                        //图片
                        var $thumbimg = $json.thumbimg;
                        var $drawimg = $json.drawimg;
                        var $attid = $json.attid;
                        if (typeof($attid) == "undefined") {
                            $attid = "";
                        }
                        _oeloveFileSynYun($attid); //同步云存储
                        
                        
                        if ($attid != '') {
                            if ($up_attids == '') {
                                $up_attids = $attid;
                            }
                            else {
                                $up_attids += ','+$attid;
                            }
                        }
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '上传失败，请检查';
                        }
                        OEUI.toast({
                            text: $result
                        });
                    }
                    if ($file_i == $file_nums) {
                        $("#"+_this.fileNode).val(''); //重置为空
                        //全部上传完毕，回调
                        _this.sendAdd($up_attids);
                        return; //介绍循环
                    }
                    $file_i = ($file_i+1); //继续循环
                    $("#order_i").html($file_i);
                },
                error: function () {
                    clearTimeout(timer);
                    time = null;
                    loading && loading.hideLoading();
                    $file_i = ($file_i+1); //继续循环
                    OEUI.toast({
                        text: '网络繁忙，请稍后再试'
                    });
                }
            });
        },
        
        //发送保存
        sendAdd:function($attids) {
            var _this = this;
            
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: 'POST',
                url: WAP_APPFILE+'&c=photo',
                data: {
                    a:'saveadd', 'ids':$attids
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    
                    if ($response == '1') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '上传完成'
                        });
                        setTimeout(function(){
                            window.location.reload();
                        }, 800);
                    }
                    else if ($response == '2') {
                        OEUI.toast({
                            type: 'bottom',
                            text: '上传完成，请等待审核'
                        });
                        setTimeout(function(){
                            window.location.reload();
                        }, 800);
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '上传失败，请检查';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function () {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });
        }
        
    }
    
    _inst_oephoto_multi = new OEUpload(); //保存实例化...
});