/**
 * [OElove] (C)2010-2099 oelove.com Webapp
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/12 by bo $
*/
$(function () {

    function OEIntro() {
        this.api_url = WAP_APPFILE+'&c=profile';
        this._this_dialog = null;
        this.slide_time = 300;
        
        this.obj_id = '';
        this.wake();
        this.intro(); //自我介绍
        
    }
    OEIntro.prototype = {
        //触发
        wake:function() {
            var _this = this;
            
            //弹出
            $(document).on("click", "[f='open_intro_dialog']", function() {
                _this._this_dialog = OEUI.Dialog({
                    el: "#intro_dialog",
                    animated: 'slideRightIn',
                    time:_this.slide_time
                });
                _this.countSize("monolog_content", "tips_num"); //统计字数
            });
            //关闭 
            $(document).on("click", "[f='close_intro_dialog']", function() {
                _check_profile_mygr();
                if (_this._this_dialog) {
                    _this._this_dialog.hide();
                }
            });  
        },
        
        //自我介绍
        intro:function() {
            var _this = this;
            //帮我写
            $(document).on("click", "[f='create_intro']", function(){
                _this.helpMe();
            });
            
            //保存
            $(document).on("click", "[f='but_submit_intro']", function(){
                _this.obj_id = $(this).attr("id");
                var $content = $("#monolog_content").val();
                if ($content == '') {
                    OEUI.toast({
                        type: 'bottom',
                        text: '请填写自我介绍'
                    });
                    return;
                }
                var $size = strQuantity($content);
                if ($size > 200) {
                    OEUI.toast({
                        type: 'bottom',
                        text: '自我介绍不能超过200个字'
                    });
                    return;
                }
                
                var $send_data = {
                    'a':'saveintro', content:$content
                };
                
                _this.sendSave($send_data);
            });
            
        },
        //帮我写
        helpMe:function() {
            var _this = this;
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:"helpmewrite", datatype:"json"
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    if ($response == "1") {
                        $("#monolog_content").val($result);
                        _this.countSize("monolog_content", "tips_num"); //统计字数
                    }
                    else {
                        if ($result.length == 0 || $result == '') {
                            $result = '获取失败，请检查！';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: $result
                        }); 
                    }
                },
                error: function() {
                    OEUI.toast({
                        type: 'bottom',
                        text: '网络繁忙，请稍后再试！'
                    });
                }
            });
        },
        
        //统计字数
        countSize:function(elm, tips_elm) {
            var $size = 0;
            var $content = $("#"+elm).val();
            if ($content != '') {
                $size = strQuantity($content);
            }
            $("#"+tips_elm).html($size);
        }, 
        
        //保存编辑
        sendSave:function($send_data) {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data:$send_data,
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == "1") {
                            _check_profile_mygr();
                            OEUI.toast({
                                type: 'bottom',
                                text: '保存成功'
                            }); 
                            setTimeout(function(){
                                if (_this._this_dialog) {
                                    _this._this_dialog.hide();
                                }
                            }, 800);
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '保存失败，请检查';
                            }
                            OEUI.toast({
                                type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
            }

        }
    }
    new OEIntro();

});