/**
 * [OElove] (C)2010-2099 oelove.com biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/04/02 by CL $
*/
var _inst_oegiftshop = null;
$(function(){
    
    //礼物商城
    function OEGiftShop() {
        this.api_url = WAP_APPFILE+'&c=gift';
        this.data_id = "gift_shop_data";
        this.page = 1;
        this._rand_dialog =  null; //随机礼物框
        this._shop_dialog = null; //全屏礼物框
        this._gift_dialog = null; //赠送框
        this.slide_time = 200;
        this.page = 1; //默认第一页
        
        
        this.obj_id = ''; //按钮id
        this.gift_touid = ''; //礼物接收人
        this.gift_id = ''; //礼物ID
        this.gift_name = ''; //礼物名称
        this.gift_fee = ''; //礼物费用
        this.gift_img = ''; //礼物图片
        this.gift_paytype = ''; //付款方式 free/viptimes/balance/onlinepay
        
        this.clickShop();
        this.clickGift();
        this.clickSend();
    }
    
    
    OEGiftShop.prototype = {
        
        //点击
        clickShop:function() {
            var _this = this;
            
            //弹窗商城
            $(document).on("click", "[f='but_send_gift']", function(){
                _this.gift_touid = $(this).attr("data-uid");
                
                if (typeof(_this.gift_touid) == 'undefined') {
                    _this.gift_touid = '';
                }
                if (_this.gift_touid == '') {
                    OEUI.toast({
                        text: '请选择赠送对象'
                    }); 
                    return;
                }
                
                if (_LOGIN_STATUS == '0') {
                    _this.login();
                    return;
                }
                $("#gift_touid").val(_this.gift_touid);
                _this.getToUser();
                
                var $type = $(this).attr("data-type");
                if ($type == 'rand') {
                    //随机一组
                    _this.randGift();
                }
                else {
                    _this.getList(1); //礼物商城
                }
            });
            
            
            //加载更多礼物
            $(document).on("click", "[f='but_more_gift']", function(){
                $("#more_gift_wrap").find("img").show();
                _this.getList();
            });
            
            //选择分类
            $(document).on("click", "[f='but_sel_giftcat']", function(){
                var $val = $(this).attr("data-val");
                var $input = $(this).attr("data-input");
                $("#"+$input).val($val);
                $(this).addClass('current').siblings().removeClass('current');
                
                _this.getList(1, 'forbid');
            });
            
            //关闭商城
            $(document).on("click", "[f='close_shop_dialog']", function(){
                if (_this._shop_dialog) {
                    _this._shop_dialog.hide();
                }
            });
            
        },
        
        login:function() {
            var _this = this;
            var $back_url = WAP_APPFILE+"&c=home&a=detail&id="+_this.gift_touid;
            window.location.href = WAP_APPFILE+"&c=passport&a=login&forward="+encodeURIComponent($back_url);
            return;
        },
        
        //礼物商城获取礼物列表
        getList:function($page, $open) {
            var _this = this;
            
            if (typeof($page) == 'undefined') {
                $page = '';
            }
            if ($page == '') {
                $page = $("#gift_page").val();
            }
            if (typeof($open) == 'undefined') {
                $open = '';
            }
            
            
            var $reqs_url = $("#gift_reqs_url").val();
            
            var $touid = $("#gift_touid").val();
            if (typeof($touid) == 'undefined') {
                $touid = '';
            }
            var $catid = $("#gift_catid").val();
            if (typeof($catid) == 'undefined') {
                $catid = '';
            }
            
            $reqs_url += "&touid="+$touid+"&s_catid="+$catid;
            
            $.ajax({
                type: "POST",
                url: $reqs_url,
                cache: false,
                data: {
                    page:$page
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $nextpage = $json.nextpage; //下一页
                    var $result = $json.result;
                    var $total = $json.total;
                    $("#gift_page").val($nextpage); //重新赋值
                    if ($result.length > 0) {
                        $("#gift_nums").html("("+$total+")");
                        //载入数据
                        if ($page == 1) {
                            $("#"+_this.data_id).html($result);
                        }
                        else {
                            $("#"+_this.data_id).append($result);
                        }

                        if ($nextpage > 0) { //还有下一页
                            $("#more_gift_wrap").show();
                            $("#more_gift_wrap").find("img").hide();
                        }
                        else { //没有下一页
                            $("#more_gift_wrap").hide();
                            $("#more_gift_wrap").find("img").hide();
                        }
                        
                        //弹出页面
                        if ($page == 1 && $open == '') {
                            if (_this._rand_dialog) {
                                _this._rand_dialog.hide(function(){
                                    setTimeout(function(){
                                        _this._shop_dialog = OEUI.Dialog({
                                            el: '#gift_shop_dialog',
                                            animated: 'slideRightIn',
                                            time:_this.slide_time
                                        }); 
                                    }, 100);
                                    
                                });
                            }
                            else {
                                _this._shop_dialog = OEUI.Dialog({
                                    el: '#gift_shop_dialog',
                                    animated: 'slideRightIn',
                                    time:_this.slide_time
                                });
                            }
                        }
                        
                    }
                    else {
                        $("#"+_this.data_id).html($result);
                        $("#gift_nums").html("0");
                    }
                },
                error: function() {
                
                }
            });
        },
        
        //获取一组随机/推荐礼物
        randGift:function() {
            var _this = this;
            var loading = null;
            var timer = setTimeout(function () {
                loading = OEUI.showLoading({
                    type:2
                });
            }, 200);
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    //0.04.24
                    a:'rand', touid:_this.gift_touid
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                        
                    if ($response == '1') {
                        $("#rand_gift_data").html($result);
                        _this._rand_dialog = OEUI.Dialog({
                            el: '#rand_gift_dialog',
                            animated: 'slideBottomIn',
                            time:_this.slide_time
                        });
                    }
                },
                error: function() {
                    clearTimeout(timer);
                    loading && loading.hideLoading();
                    timer = null;
                }
            });
        },
        
        //获取接收人信息
        getToUser:function() {
            _this = this;
            
            var $touid = $("#gift_touid").val();
            if (typeof($touid) == 'undefined') {
                $touid = '';
            }
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:'touser', touid:$touid
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    if ($response == '1') {
                        $("#gift_touser_data").html($result);
                    }
                },
                error: function() {
                
                }
            });
        },
        
        //选中
        clickGift:function() {
            var _this = this;
            
            //选中礼物
            $(document).on("click", "[f='but_select_gift']", function(){
                
                _this.gift_id = $(this).attr("data-id");
                _this.gift_name = $(this).attr("data-name");
                _this.gift_img = $(this).attr("data-img");
                _this.gift_fee = $(this).attr("data-fee");
                var $moneyname = $(this).attr("data-moneyname");
                if (typeof($moneyname) == 'undefined') {
                    $moneyname = '金豆';
                }
                
                $("#gift_name_tips").html(_this.gift_name);
                $("#gift_img").attr("src", _this.gift_img);
                if (_this.gift_fee > 0) {
                    $("#gift_fee_tips").html(_this.gift_fee+$moneyname);
                }
                else {
                    $("#gift_fee_tips").html('免费');
                }
                
                //赋值
                $("#gift_id").val(_this.gift_id);
                $("#gift_name").val(_this.gift_name);
                $("#gift_fee").val(_this.gift_fee);
                _this.getPay();
                
                _this._gift_dialog = OEUI.Dialog({
                    el: '#gift_send_dialog',
                    animated: 'slideBottomIn', //从底部出来
                    time:_this.slide_time
                });
                
                
            });
            
            //关闭礼物
            $(document).on("click", "[f='close_gift_dialog']", function(){
                _this.closeGiftDialog();
            });
            
            //选择付款方式
            $(document).on("click", "[f='select_gift_paytype']", function(){
                var $type = $(this).attr("data-type");
                $("[f='select_gift_paytype']").find('.paytype i').removeClass('color_f40 icon-xuanze1').addClass('color_9 icon-tubiao-xuanze');
                $(this).find('.paytype i').addClass('color_f40 icon-xuanze1');
                $("[f='but_confirm_send_gift']").attr("data-type", $type);
                
                if ($type == 'viptimes') {
                    $("#but_confirm_send_gift").show();
                    $("#but_confirm_send_gift2").hide();
                }
                else {
                    $("#but_confirm_send_gift").hide();
                    $("#but_confirm_send_gift2").show();
                }
            });
            
        },
        closeGiftDialog:function() {
            var _this = this;
            if (_this._gift_dialog) {
                _this._gift_dialog.hide();
            }
        },
        //获取接收人信息
        getPay:function() {
            _this = this;
            
            var $fee = $("#gift_fee").val();
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:'getpay', fee:$fee
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    if ($response == '1') {
                        $("#gift_pay_data").html($result);
                    }
                },
                error: function() {
                
                }
            });
        },
        
        clickSend:function() {
            var _this = this;
            //确定赠送
            $(document).on("click", "[f='but_confirm_send_gift']", function(){
                _this.obj_id = $(this).attr("id");
                _this.gift_paytype = $(this).attr("data-type"); //付款方式
                if (typeof(_this.gift_paytype) == 'undefined') {
                    $_this.gift_paytype = 'onlinepay';
                }
                _this.gift_id = $("#gift_id").val();
                _this.gift_touid = $("#gift_touid").val();
                
                var $send_data = {
                    'a':'sendgift', 'giftid':_this.gift_id, 'touid':_this.gift_touid, 
                    'paytype':_this.gift_paytype
                };
                _this.sendGift($send_data);
            });
        }, 
        
        //发送礼物
        sendGift:function($send_data) {
            var _this = this;
            
            if (!$("#"+_this.obj_id).hasClass("forbid_submit")) {
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                $("#"+_this.obj_id).addClass("forbid_submit");
                
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data:$send_data, 
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        
                        if ($response == '1') { 
                            OEUI.toast({
                                //type: 'bottom',
                                text: '赠送成功'
                            });
                            setTimeout(function(){
                                _this._gift_dialog.hide(function(){
                                    //回调其他
                                });
                            }, 800);
                        }
                        else if ($response == '2') {
                            if (_this._rand_dialog) {
                                _this._rand_dialog.hide();
                            }
                            if (_this._shop_dialog) {
                                _this._shop_dialog.hide();
                            }
                            //收银台
                            _this._gift_dialog.hide(function(){
                                window.location.href = WAP_APPFILE +"&c=pay&paynum="+$result;
                            });
                        }
                        else if ($response == '22') {
                            //唤醒微信支付
                            var $back_url = WAP_APPFILE+'&c=home&a=detail&id='+_this.gift_touid+'&nofollow=1';
                            var $pay_data = {
                                'paynum': $result,
                                'forward': $back_url
                            };
                            _inst_oewx_pay.initPay($pay_data, function(){
                               OEUI.toast({
                                    //type: 'bottom',
                                    text: '赠送成功'
                                });
                                setTimeout(function(){
                                    _this._gift_dialog.hide(function(){
                                        //回调其他
                                    });
                                }, 800);
                            });
                        }
                        
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '赠送失败，请检查';
                            }
                            OEUI.toast({
                                //type: 'bottom',
                                text: $result
                            }); 
                        }
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                    },
                    error: function() {
                        $("#"+_this.obj_id).removeClass("forbid_submit");
                        clearTimeout(timer);
                        loading && loading.hideLoading();
                        timer = null;
                        OEUI.toast({
                            //type: 'bottom',
                            text: '网络繁忙，请稍后再试！'
                        });
                    }
                });
                
            } 
        }
    }
    
    _inst_oegiftshop = new OEGiftShop();
    
});

