/**
 * [OElove] (C)2010-2099 oelove.com Inc.biz
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2020.03.17 Update by BO&CL $
*/
var _inst_oeupload = null;
$(function(){
    //上传类
    function OEUpload () {
        this.up_apiurl = _ROOT_PATH+'index.php?m=wap&c=cp&a=ajaxupload';
        this._callback = null; //回调
        this.fileNode = '';
        this.triggerUpload();
    }
    
    OEUpload.prototype = {
        
        //点击触发f='but_upload'
        triggerUpload:function() {
            var _this = this;
            $(document).on("click", "[f='but_upload']", function(){
                var $node = $(this).attr("data-file");
                //0.02.26
                _this.fileNode = $node;
                _this.listenUpload(); //change事件只绑定一次 0.02.26
                $("#"+$node).click(); //file事件
            });
        },
        
        //执行上传
        listenUpload:function() {
            var _this = this;
            //0.02.26
            $(document).off("change."+_this.fileNode);
            $(document).on("change."+_this.fileNode, "#"+_this.fileNode, function(e){
                
                var type = e.target.dataset.type; //上传类 image  图片
                if (typeof(type) == "undefined") {
                    type = "image";
                }
                var thumb = e.target.dataset.thumb;
                if (typeof(thumb) == "undefined") {
                    thumb = "0"; //是否生成缩略图
                }
                var forbidcom = e.target.dataset.forbidcom;
                if (typeof(forbidcom) == "undefined") {
                    forbidcom = "0"; //是否禁止压缩
                }
                var forbidwater = e.target.dataset.forbidwater;
                if (typeof(forbidwater) == "undefined") {
                    forbidwater = "0"; //是否禁止水印
                }
                var module = e.target.dataset.module;
                if (typeof(module) == "undefined") {
                    module = "upload";
                }
                //是否显示成功提示
                var forbid_tip = e.target.dataset.forbidtip;
                if (typeof(forbid_tip) == "undefined") {
                    forbid_tip = "0";
                }
                
                //回调
                _this._callback = e.target.dataset.callback;;
                if (typeof(_this._callback) == 'undefined') {
                    _this._callback = '';
                }
                
                var api_url = _this.up_apiurl+"&module="+module+
                                "&thumbfiles="+thumb+"&forbidcom="+forbidcom+
                                "&forbidwater="+forbidwater+"&thumb="+thumb;
                
                var file = e.target.files[0]; //获取的文件路径
                var name = e.target.dataset.name; //input的名字
                var fd = new FormData();
                fd.append('uploadpart', 'file');
                fd.append('file', file);
                
                var loading = null;
                var timer = setTimeout(function () {
                    loading = OEUI.showLoading({
                        type:2
                    });
                }, 200);
                
                $.ajax({
                    type: 'POST',
                    url: api_url,
                    data: fd,
                    processData: false,
                    contentType: false,
                    success: function (retdata) {
                        clearTimeout(timer);
                        time = null;
                        loading && loading.hideLoading();
                        
                        var $json = JSON.parse(retdata);
                        var $response = $json.response;
                        var $result = $json.result;
                        
                        if ($json.response == '1') {
                            if (forbid_tip != '1') {
                                OEUI.toast({
                                    text: '上传成功'
                                });
                            }
                            
                            //图片
                            var $thumbimg = $json.thumbimg;
                            var $drawimg = $json.drawimg;
                            var $base64img = $json.base64img;
                            if (typeof($base64img) == 'undefined') {
                                $base64img = '';
                            }
                            var $attid = $json.attid;
                            if (typeof($attid) == "undefined") {
                                $attid = "";
                            }
                            var $imgwidth = $json.imgwidth;
                            if (typeof($imgwidth) == 'undefined') {
                                $imgwidth = '0';
                            }
                            var $imgheight = $json.imgheight;
                            if (typeof($imgheight) == 'undefined') {
                                $imgheight = '0';
                            }
                            
                            if ($("#"+name+"_thumb").length > 0) {
                                $("#"+name+"_thumb").val($thumbimg);
                            }
                            if ($("#"+name+"_url").length > 0) {
                                $("#"+name+"_url").val($drawimg);
                            }
                            if ($("#"+name+"_preview").length > 0) {
                                $img = _ROOT_PATH+$drawimg+"?r="+new Date().getTime();
                                $("#"+name+"_preview").attr("src", $img);
                                $("#"+name+"_preview").show();
                            }
                            $("#"+_this.fileNode).val(''); //重置为空
                            
                            _oeloveFileSynYun($attid); //同步云存储
                            //回调
                            if (_this._callback && _this._callback != '') {
                                //var $callback = eval(_this._callback);
                                if (typeof(window[_this._callback]) == 'function') {
                                    window[_this._callback]($json);
                                }
                            }
                        }
                        else {
                            if ($result.length == 0 || $result == '') {
                                $result = '上传失败，请检查';
                            }
                            OEUI.toast({
                                text: $result
                            }); 
                        }
                    },
                    error: function () {
                        clearTimeout(timer);
                        time = null;
                        loading && loading.hideLoading();
                        
                        OEUI.toast({
                            text: '网络繁忙，请稍后再试'
                        });
                    }
                });
            });
        }
        
    }
    
    _inst_oeupload = new OEUpload(); //保存实例化...
});