/**
 * [OElove] (C)2010-2099 OELOVE.COM Inc.biz
 * Email: service@phpcoo.com ,phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2020/03/16 by CL $
*/
var _inst_oewx_pay = null;
$(function(){
    
    //微信支付(公众号)
    function OEWxPay() {
        this.api_url = _ROOT_PATH+"index.php?m=wap&c=pay"; //兼容其他频道调用
        this.paynum = ''; //订单号
        this.forward = ''; //来源url
        this.callback = null; //支付成功后回调
        
        this.wx_api_params = ''; //jsapi params 
    }
    
    OEWxPay.prototype = {
        
        //请求支付 @var $option为数组对象
        initPay:function($option, callback) {
            var _this = this;
            _this.callback = callback || null;
            
            var $paynum = $option.paynum;
            if (typeof($paynum) == 'undefined') {
                $paynum = $("#paynum").val();
                if (typeof($paynum) == 'undefined') {
                    $paynum = '';
                }
            }
            var $forward = $option.forward;
            if (typeof($forward) == 'undefined') {
                $forward = $("#forward").val();
                if (typeof($forward) == 'undefined') {
                    $forward = '';
                }
            }
            
            _this.paynum = $paynum;
            _this.forward = $forward;
            
            _this.getWxPayJsParams(); //获取jsapi params
            
        },
        
        
        
        //获取jsapi params
        getWxPayJsParams:function() {
            var _this = this;
            
            //兼容其他频道调用
            if (_this.paynum == '') {
                var $paynum = $("#paynum").val();
                _this.paynum = $paynum; //订单号
            }
            if (_this.forward == '') {
                var $forward = $("#forward").val();
                if (typeof($forward) == "undefined") {
                    $forward = "";
                }
                _this.forward = $forward; //来源url
            }
            
            $.ajax({
                type: "POST",
                url: _this.api_url,
                cache: false,
                data: {
                    a:'callwxpay', paynum:_this.paynum
                },
                dataType: "json",
                success: function($data) {
                    var $json = eval($data);
                    var $response = $json.response;
                    var $result = $json.result;
                    if ($response == "1") {
                        //$json_result = JSON.stringify($result);
                        _this.wx_api_params = $result;
                        //获取成功，则弹出
                        _this.wakePwd();
                    }
                    
                    else if ($response == "2") {
                        //没有openid 需要跳转获取
                        var $pay_url = _this.api_url+"&a=submit&paynum="+_this.paynum+"&sdkid=998"+
                                        "&sdk=weixinpay&forward="+encodeURIComponent(_this.forward);	
                        window.location.href = $pay_url;
                    }
                    else {
                        if ($result == '' || $result == null) {
                            $result = '微信支付故障，请联系管理员';
                        }
                        OEUI.toast({
                            type: 'bottom',
                            text: '微信支付故障，请联系管理员'
                        });
                    }
                },
                error: function() {
                    //微信参数配置故障，跳转查看具体错误...
                    var $pay_url = _this.api_url+"&a=submit&paynum="+_this.paynum+"&sdkid=998"+
                                    "&sdk=weixinpay&forward="+encodeURIComponent(_this.forward);
                    window.location.href = $pay_url;
                }
            }); 
        },
        
        //唤醒输入密码
        wakePwd:function() {
            var _this = this;
            if (typeof WeixinJSBridge == "undefined"){
                if (document.addEventListener) {
                    document.addEventListener('WeixinJSBridgeReady', _this.submitWxPay(), false);
                }
                else if (document.attachEvent){
                    document.attachEvent('WeixinJSBridgeReady', _this.submitWxPay()); 
                    document.attachEvent('onWeixinJSBridgeReady', _this.submitWxPay());
                }
            }
            else{
                _this.submitWxPay();
            }
        },
        
        //执行支付
        submitWxPay:function() {
            var _this = this;
            var $wx_api = _this.wx_api_params;
            $wx_api = JSON.parse($wx_api);
            
            //提前查询，防止部分支付成功不可靠
            setTimeout(function(){
                _this.getPayResult();
            }, 2000);
            
            
            WeixinJSBridge.invoke(
                "getBrandWCPayRequest",$wx_api,
                function(res){
                    WeixinJSBridge.log(res.err_msg);
                    //alert(res.err_code+res.err_desc+res.err_msg);
                    if (res.err_msg == "get_brand_wcpay_request:ok") {
                        //支付成功 将在用户支付成功后返回ok，但并不保证它绝对可靠。
                    }
                    else if (res.err_msg == "get_brand_wcpay_request:cancel") {
                        //用户取消支付
                    }
                    else if (res.err_msg == "get_brand_wcpay_request:fail") {
                        //支付失败
                    }
                }
            );
        },
        
        //查询结果
        getPayResult:function() {
            var _this = this;
            if (_this.paynum != '') {
                $.ajax({
                    type: "POST",
                    url: _this.api_url,
                    cache: false,
                    data: {
                        a:'checkpay', paynum:_this.paynum
                    },
                    dataType: "json",
                    success: function($data) {
                        var $json = eval($data);
                        var $response = $json.response;
                        var $result = $json.result;
                        if ($response == "1") {
                            if ($result == "10") {
                                //成功
                                //回调
                                if (typeof(_this.callback) == 'function') {
                                    _this.callback();
                                    return;
                                }
                                else {
                                    //跳转
                                    window.location.href = _this.api_url+"&a=show&paynum="+_this.paynum+
                                                        "&forward="+encodeURIComponent(_this.forward);
                                }
                            }
                            else if ($result == "11") {
                                //失败
                                window.location.href = _this.api_url+"&a=show&paynum="+_this.paynum+
                                                        "&forward="+encodeURIComponent(_this.forward);
                            }
                            else {
                                //时时查询
                                setTimeout(function(){
                                  _this.getPayResult();
                                }, 1000);
                            }
                        }
                    },
                    error: function() {

                    }
                });
            }
        }
    }
    _inst_oewx_pay = new OEWxPay(); //对象，外面使用
    
});