/**
 * [OElove Webapp] (C)2010-2099 oelove.com Inc.
 * Email: service@phpcoo.com，phpcoo@qq.com
 * This is not a freeware, use is subject to license terms
 * $ LastTime 2019.12.24 Update by BO $
*/
    
Vue.component('oe-insert-picker', {
  template: `
    <div class="oe_picker_inset" v-show="isShow">
      <div class="picker_panel" v-show="isShow">
        <div class="picker_content">
          <div class="mask_top"></div>
          <div class="mask_bottom"></div>
          <div class="wheel_wrapper" ref="wheelWrapper">
            <template v-if="!linkPage">
              <div class="wheel" v-for="arr in data">
                <ul class="wheel_scroll">
                  <li class="wheel_item" v-for="item in arr">{{item.text}}</li>
                </ul>
              </div>
            </template>
            <template v-else>
              <div class="wheel" v-for="data in linkPageData">
                <ul class="wheel_scroll">
                  <li class="wheel_item" v-for="item in data">{{item.text}}</li>
                </ul>
              </div>
            </template>
          </div>
        </div>
      </div>
    </div>
  `,
  props: {
    data: {
      type: Array,
      default: function(){
        return []
      }
    },
    selectedIndex: {
      type: Array,
      default: function() {
        return []
      }
    },
    isShow: {
      type: Boolean,
      required: true
    },
    title: {
      type: String,
      default: 'picker'
    },
    linkPage: {
      type:Boolean,
      default: false
    }
  },
  data() {
    return {
      name: 'picker',
      isScrollEnd: true,
      linkPageData: [],
      formatData: [],
      selectData: [],
      wheels: '',
      set_default_val: false
    }
  },
  watch: {
    data (newV, oldV) {
      if(this.linkPage) {
        this.formatHash(newV)
      }
    },
    linkPageData (newV, oldV) {
        if(!this.set_default_val && newV.length > 0) {
            this.set_default_val = true;
            this.selectData[0] = newV[0][0];
            this.selectData[1] = newV[1][0];
            this.selectData[2] = newV[2][0];
        }
    }
  },
  methods: {
    _createWheel() {
      if (!this.wheels) {
        if(this.linkPage) {
          if(this.$refs.wheelWrapper.children.length == 0) {
            return;
          }
          this.wheels = this.linkPageData.map((v, i) => {
            let index = v.findIndex(item => {return item.value == this.selectedIndex[i]})
            if(index == -1) {
              index = 0
            }
            const wheel = new BScroll(this.$refs.wheelWrapper.children[i], {
              wheel: {
                selectedIndex: index,
                wheelWrapperClass: 'wheel_scroll',
                wheelItemClass: 'wheel_item',
                wheelDisabledItemClass: 'wheel_disabled_item',
              },  
              swipeTime: 1000,
              probeType: 3
            })
            wheel.on('scrollEnd', () => {
              this.isScrollEnd = true
              const index = wheel.getSelectedIndex()
              this.selectData[i] = this.linkPageData[i][index] || {}
              for(let j = i; j+1 < this.linkPageData.length; j++) {
                if(j == i) {
                  this.linkPageData[j+1] =　typeof(this.linkPageData[j][index]) == 'object'? this.formatData[this.linkPageData[j][index].value]: []
                  this.selectData[i] = this.linkPageData[i][index]
                }else{
                  this.linkPageData[j+1] =　typeof(this.linkPageData[j][0]) == 'object'? this.formatData[this.linkPageData[j][0].value]: []
                }
                this.selectData[j+1] = this.linkPageData[j+1][0] || {}
                this.$forceUpdate()
                if(this.linkPageData[j+1].length) {
                  this.$nextTick(() => {
                    this.wheels[j+1].enable()
                    this.wheels[j+1].scrollTo(0, 0, 'ease')
                    this.wheels[j+1].refresh()
                  })
                }else{
                  this.wheels[j+1].disable()
                }
              }
              this.$emit('change', this.selectData)
            })
            wheel.on('scroll', () => {
              this.isScrollEnd = false
            }) 
            return wheel
          })
        }else {
          this.wheels = this.data.map((v, i) => {
            let index = v.findIndex(item => {return item.value == this.selectedIndex[i]})
            if(index == -1) {
              index = 0
            }
            const wheel = new BScroll(this.$refs.wheelWrapper.children[i], {
              wheel: {
                selectedIndex: index,
                wheelWrapperClass: 'wheel_scroll',
                wheelItemClass: 'wheel_item',
                wheelDisabledItemClass: 'wheel_disabled_item',
              },   
              swipeTime: 1000,             
              probeType: 3
            })
            wheel.on('scrollEnd', () => {
              const index = wheel.getSelectedIndex()
              this.selectData[i] = this.data[i][index] || {}
              this.$emit('change', this.selectData)
            })
            return wheel
          })
        }
      } else {
        this.wheels.forEach(picker => picker.refresh())
      }
      return this.wheels
    },
    comfirm() {
      const isMoving =  this.wheels.some(v => {
        return v.isInTransition == true
      })
      if(isMoving) {
        return
      }
      this.$emit('change', this.selectData)
    },
    cancel() {
      this.$emit('change')
    },
    formatHash(arr) {
      if(!arr.length){
        return
      }
      [].forEach.call(arr, (v, i) => {
        this.formatData[v.value] = v.children;
        if(v.children && v.children.length) {
          this.formatHash(v.children);
        }
      });
    }
  }
});

new Vue({
  el: '#app',
  data: {
      transition_name: '',
      step: 'gender',
      reg_step: reg_step,
      check_item: check_item,
      step_num: 0,
      gender: '',
      marry: '',
      date_arr: [],
      date_show:　false,
      date: [],
      height_data: [],
      height: '165',
      education: '',
      house: '',
      car: '',
      sort: '',
      salary: '',
      hidemobile: '0',
      job: '',
      username: AU_NICKNAME || '',
      user_name_tip: '',
      password: '',
      password_tip: '',
      email: '',
      email_tip: '',
      truename: '',
      truename_tip: '',
      wx: '',
      wx_tip: '',
      qq: '',
      qq_tip: '',
      forward: FORWARD,
      au_mod: AU_MOD,
      openid: OPENID,
      au_unionid: AU_UNIONID,
      au_headimgurl: AU_HEADIMGURL,
      mobile: MOBILE,
      weight_data: [],
      weight_show: true,
      weight: '50',
      area: [{},{},{}],
      area_arr: [],
      area_show: true,
      is_reg: false,
      sh: sh,
      random_username: '',
      show_random_username: false,
      hometown: [{},{},{}],
      hometown_arr: [],
      hometown_show: true,
  },
  mounted () {
      this.display_birthday();
      this.create_height_data();
      this.slider_select_height();
      this.get_weight_data();
      this.get_area_data();
      if(this.$refs.hometown) {
          this.get_hometown_data();
      }
  },
  methods: {
      go_back () {
          history.go(-1);
      },
      select_gender (gender) {
          this.gender = gender;
          const has_marry = this.check_item.some(v => {
              return v == 'marry';
          });

          if(has_marry && this.marry == '') {
              return;
          }
          this.next();
      },
      select_marry (marry) {
          this.marry = marry;
          if(this.gender == '') {
              return;
          }
          this.next();
      },
      next () {
          this.transition_name = 'slide-left';
          switch(this.step) {
              case 'gender':
                  if(this.gender == '') { 
                      this.$oeToast('请选择性别');
                      return;
                  }
                  const is_check_marry = this.check_item.some(v => {return v == 'marry'});
                  if(is_check_marry && this.marry == '') {
                      this.$oeToast('请选择婚况');
                      return;
                  }
                  setTimeout(() => {
                      const wheel = this.$refs.date._createWheel();
                      if(wheel) {
                          wheel.forEach(picker => {
                              picker.enable();
                              picker.refresh();
                          })
                      }
                  }, 50);
                  break;
              case 'birth':
                  let is_date_moving =  this.$refs.date.wheels.some(v => {
                      return v.isInTransition == true;
                  });
                  if(is_date_moving) {
                      return;
                  }
                  setTimeout(() => {
                      const wheel = this.$refs.area._createWheel();
                      if(wheel) {
                          wheel.forEach(picker => {
                              picker.enable();
                          })
                      }
                  }, 500);
                  break;
              case 'area':
                  if(this.$refs.area && this.$refs.area.wheels) {
                      let is_area_moving =  this.$refs.area.wheels.some(v => {
                          if(v.maxScrollY != 0) {
                              return v.isInTransition == true;
                          }
                      });
                      if(is_area_moving) {
                          return;
                      }
                  }
                  setTimeout(() => {
                      if(this.$refs.hometown) {
                          const wheel = this.$refs.hometown._createWheel();
                          if(wheel) {
                              wheel.forEach(picker => {
                                  picker.enable();
                              })
                          }
                      }
                  }, 500);
                  break;
              case 'hometown':
                  if(this.$refs.hometown && this.$refs.hometown.wheels) {
                      let is_hometown_moving =  this.$refs.hometown.wheels.some(v => {
                          if(v.maxScrollY != 0) {
                              return v.isInTransition == true;
                          }
                      });
                      if(is_hometown_moving) {
                          return;
                      }
                  }
                  break;
              case 'car_or_house':
                  let is_check_car = false;
                  this.check_item.some(v => {
                      if(v == 'car') {
                          is_check_car = true;
                      }
                  });
                  if(is_check_car && this.car == '') {
                      this.$oeToast('请选择购车情况');
                      return;
                  }
                  let is_check_house = false;
                  this.check_item.some(v => {
                      if(v == 'house') {
                          is_check_house = true;
                      }
                  });
                  if(is_check_house && this.house == '') {
                      this.$oeToast('请选择购房情况');
                      return;
                  }
                  break;
              case 'sort_or_maytype':
                  let is_check_sort = false;
                  this.check_item.some(v => {
                      if(v == 'sort') {
                          is_check_sort = true;
                      }
                  });
                  if(is_check_sort && this.sort == '') {
                      this.$oeToast('请选择交友类型');
                      return;
                  }
                  let is_check_maytype = false;
                  this.check_item.some(v => {
                      if(v == 'maytype') {
                          is_check_maytype = true;
                      }
                  });
                  break;
              /*case 'weight': 
                  let is_weight_moving =  this.$refs.weight.wheels.some(v => {
                      return v.isInTransition == true;
                  });
                  if(is_weight_moving) {
                      return;
                  }
                  break; */
              default:
          } 
          this.step_num++;
          if(this.step_num >= this.reg_step.length) {
              this.step_num = this.reg_step.length -1;
          }
          this.step = this.reg_step[this.step_num];

          if(this.step == 'weight') {
              setTimeout(() => {
                  const wheel = this.$refs.weight._createWheel();
                  if(wheel) {
                      wheel.forEach(picker => {
                          picker.enable();
                          picker.refresh();
                      })
                  }
              }, 50);
          }
      },
      back () {
          this.step_num--;
          this.step = this.reg_step[this.step_num];
          if(this.step == 'weight') {
            setTimeout(() => {
              this.$refs.weight.wheels[0].enable();
              this.$refs.weight.wheels[0].refresh();
            }, 300);
          }
          this.transition_name = 'slide-right';
      },
      display_birthday () {
          var year = new Date().getFullYear() - parseInt(STARTAGE);
          var Arr = [];
          var year_arr = [];
          for(var y = year; y >= (new Date().getFullYear() - parseInt(ENDAGE)); y--) {
              var month_arr = [];
              for(var m = 1; m <= 12; m++) {
                  let daycount = new Date(y, m, 0).getDate(); //设置0返回当月的最后一天
                  var date_arr = [];
                  for(var d = 1; d <= daycount; d++) {
                      date_arr.push({'text': d<10?'0'+d:d, 'value': d<10?'0'+d+'日':d+'日','children': []});
                  }
                  month_arr.push({'text': m<10?'0'+m:m, 'value': m<10?'0'+m+'月':m+'月', 'children': date_arr});
              }
              year_arr.push({'text': y<10?'0'+y:y, 'value': y<10?'0'+y+'年':y+'年', 'children': month_arr});
          }
          this.date_arr = year_arr;
          this.set_date_data(year_arr);
          this.date_show = true;
      },
      set_date_data(data) {
          this.$refs.date.linkPageData.push(data);
          const data2 = data[0].children;
          this.$refs.date.linkPageData.push(data2);
          const data3 = data2[0].children;
          this.$refs.date.linkPageData.push(data3);
          this.date = [data[0].text, data2[0].text, data3[0].text]
      },
      select_date (arr) {
          arr[0].text && (this.date[0] = arr[0].text);
          arr[1].text && (this.date[1] = arr[1].text);
          arr[2].text && (this.date[2] = arr[2].text);
          this.$forceUpdate();
      },
      create_height_data () {
        for(var i = 280; i > 120; i--){
            this.height_data.push(i);
        }
      },
      slider_select_height () {
        var t = this;
        var startY = 0;
        var moveY = 0;
        var distance = -1030;
        if(this.$refs.ruler == undefined) {
            return;
        }
        this.$refs.ruler.addEventListener('touchstart', function(e) {
            startY = e.touches[0].clientY;
        }, false);
        this.$refs.ruler.addEventListener('touchmove', function(e) {
            e.stopPropagation();
            e.preventDefault();
            moveY = e.touches[0].clientY - startY + distance;
            t.$refs.ruler.style.transform = 'translate3d(0, '+ moveY +'px, 0)';
            t.$refs.ruler.style.transitionDuration =  '0s';
        }, false);
        this.$refs.ruler.addEventListener('touchend', function(e) {
            distance = moveY;
            var h = 165; //默认身高165
            if(distance >= 0) {
                if((distance % 10) >= 5) {
                    distance = distance + (10-(distance % 10));
                }else if((distance % 10) < 5) {
                    distance = distance - (distance % 10);
                }

                h = 280 - (120 - distance)/10;
            }else{
                if((distance % 10)*-1 >= 5) {
                    distance = -10 - (distance % 10) + distance;
                }else if((distance % 10)*-1 < 5) {
                    distance = distance - (distance % 10);
                }
                
                h = 280 + (distance - 120)/10;
            }
            t.$refs.ruler.style.transform = 'translate3d(0, '+ distance +'px, 0)'; 
            t.$refs.ruler.style.transitionDuration = '.3s';
            if(distance > 120) {
                distance = 120;
                t.$refs.ruler.style.transform = 'translate3d(0, '+ distance +'px, 0)'; 
                t.$refs.ruler.style.transitionDuration = '.3s';
                h = 280 + (distance - 120)/10;
            }
            if(distance < -1470) {
                distance = -1470;
                t.$refs.ruler.style.transform = 'translate3d(0, '+ distance +'px, 0)'; 
                t.$refs.ruler.style.transitionDuration = '.3s';
                h = 280 + (distance - 120)/10;
            }
            t.height = h || 165;
        }, false);
      },
      select_edu (education) {
          this.education = education;
          this.next();
      },
      select_house (house) {
          this.house = house;
          const has_car = this.check_item.some(v => {
              return v == 'car'
          });
          if(has_car && this.car == '') {
              return;
          }
          this.next();
      },
      select_car (car) {
          this.car = car;
          const has_house = this.check_item.some(v => {
              return v == 'house'
          });
          if(has_house && this.house == '') {
              return;
          }
          this.next();
      },
      select_sort (sort) {
          this.sort = sort;
          const has_maytype = this.check_item.some(v => {
              return v == 'maytype'
          });
          if(has_maytype && this.maytype == '') {
              return;
          }
          this.next();
      },
      select_maytype (maytype) {
          this.maytype = maytype;
          const has_sort = this.check_item.some(v => {
              return v == 'sort'
          });
          if(has_sort && this.sort == '') {
              return;
          }
          this.next();
      },
      select_salary (salary) {
          this.salary = salary;
          this.next();
      },
      check_username () {
          var t = this;
          if(this.username == '') {
              this.user_name_tip = '请输入用户名';
              return;
          }
          const fd = new FormData();
          fd.append('a', 'check');
          fd.append('check_type', 'username');
          fd.append('name', this.username);
          axios({
              method: 'post',
              url: WAP_APPFILE+ '&c=picker',
              data: fd
          }).then((res) => {
              const data = res.data;
              if(data.response != '1') {
                  if(data.result) {
                      this.user_name_tip = data.result;
                  } else {
                      this.user_name_tip = '用户名已存在或不可用';
                      this.request_username();
                  }
              }
          }).catch(() => {
              this.user_name_tip = '系统繁忙，请稍后再试';
          });
      },
      request_username () {
          const fd = new FormData();
          fd.append('name', this.username);
          fd.append('r', this.$oeRandom(6));
          axios({
              method: 'post',
              url: WAP_APPFILE+ '&c=passport&a=rndname',
              data: fd
          }).then(res => {
              const data = res.data;
              if(data.response == '1') {
                  this.random_username = data.result;
                  this.show_random_username = true;
              }
          }); 
      },
      hide_random_username () {
          this.show_random_username = false;
      },
      select_random_username (e) {
          const el = e.target;
          const name = el.dataset.name;
          if(name) {
              this.username = name;
              this.hide_random_username();
              this.user_name_tip = '';
          }
      },
      check_password () {
          if(this.password.length < 6 || this.password.length > 16) {
              this.password_tip = '请输入6到16个字符的密码';
          }
      },
      check_email () {
          var reg = /^([a-zA-Z]|[0-9])(\w|\-)+@[a-zA-Z0-9]+\.([a-zA-Z]{2,4})$/;
          if(!reg.test(this.email)) {
              this.email_tip = '邮箱格式不正确';
              return;
          }/*
          const fd = new FormData();
          fd.append('a', 'check');
          fd.append('check_type', 'emial');
          fd.append('name', this.email);
          axios({
              method: 'post',
              url: WAP_APPFILE+ '&c=picker',
              data: fd
          }).then((res) => {
              const data = res.data;
              if(data.response != '1') {
                  if(data.result) {
                      this.email_tip = data.result;
                  } else {
                      this.email_tip = '该邮箱已存在或被注册';
                  }
              }
          }).catch(() => {
              this.email_tip = '系统繁忙，请稍后再试';
          });*/
      },
      focus (name) {
          this[name] = '';
      },
      check_truename () {
          if(this.truename == '') {
              this.truename_tip = '请输入真实姓名';
          }
      },
      check_wx () {
        if(this.wx == '') {
              this.wx_tip = '请输入微信';
          }
      },
      check_qq () {
        if(this.qq == '') {
              this.qq_tip = '请输入QQ';
          }
      },
      check_insert_item () {
          let can_reg = true;
          if(this.username == '') {
              can_reg = false;
              if(this.user_name_tip == '') {
                  this.user_name_tip = '请输入用户名';
              }
          }
          if(this.password == '') {
              can_reg = false;
              if(this.password_tip == '') {
                  this.password_tip = '请输入6-16个字符的密码';
              }
          }
          const is_check_email = this.check_item.some(v => {return v == 'email'});
          if(is_check_email && this.email == '') {
              can_reg = false;
              if(this.email_tip == '') {
                  this.email_tip = '请输入邮箱';
              }
          }
          const is_truename_email = this.check_item.some(v => {return v == 'truename'});
          if(is_truename_email && this.truename == '') {
              can_reg = false;
              if(this.truename_tip == '') {
                  this.truename_tip = '请输入真实姓名';
              }
          }
          const is_weixin_email = this.check_item.some(v => {return v == 'weixin'});
          if(is_weixin_email && this.wx == '') {
              can_reg = false;
              if(this.wx_tip == '') {
                  this.wx_tip = '请输入微信';
              }
          }
          const is_qq_email = this.check_item.some(v => {return v == 'qq'});
          if(is_qq_email && this.qq == '') {
              can_reg = false;
              if(this.qq_tip == '') {
                  this.qq_tip = '请输入QQ';
              }
          }
          return can_reg;
      },
      hide_mobile () {
          if(this.hidemobile == '1') {
              this.hidemobile = '0';
          } else {
              this.hidemobile = '1';
          }
      },
      select_job (job) {
          this.job = job;
          this.next();
      },
      reg () {
          if(!this.check_insert_item()) {
              return;
          }
          /*const fd = new FormData();
          fd.append('gender', this.gender);
          fd.append('marry', this.marry);
          fd.append('ageyear', this.date[0]);
          fd.append('agemonth', this.date[1]);
          fd.append('ageday', this.date[2]);
          fd.append('height', this.height);
          fd.append('education', this.education);
          fd.append('house', this.house);
          fd.append('car', this.car);
          fd.append('username', this.username);
          fd.append('password', this.password);
          fd.append('email', this.email);
          fd.append('truename', this.truename);
          fd.append('weixin', this.wx);
          fd.append('qq', this.qq);
          fd.append('mobile', this.mobile);
          fd.append('au_mod', this.au_mod);
          fd.append('openid', this.openid);
          fd.append('au_unionid', this.au_unionid);
          fd.append('au_headimgurl', this.au_headimgurl);
          fd.append('hidemobile', this.hidemobile);
          fd.append('salary', this.salary);
          fd.append('sort', this.sort);
          fd.append('maytype', this.maytype);
          fd.append('job', this.job);
          fd.append('weight', this.weight);
          fd.append('dist1', this.area[0].value);
          fd.append('dist2', this.area[0].value);
          fd.append('dist3', this.area[0].value);*/
          const fd = {
              'marry': this.marry,
              'gender': this.gender,
              'ageyear': this.date[0],
              'agemonth': this.date[1],
              'ageday': this.date[2],
              'height': this.height,
              'education': this.education,
              'house': this.house,
              'car': this.car,
              'username': this.username,
              'password': this.password,
              'email': this.email,
              'truename': this.truename,
              'weixin': this.wx,
              'qq': this.qq,
              'mobile': this.mobile,
              'au_mod': this.au_mod,
              'openid': this.openid,
              'au_unionid': this.au_unionid,
              'au_headimgurl': this.au_headimgurl,
              'hidemobile': this.hidemobile,
              'salary': this.salary,
              'sort': this.sort,
              'maytype': this.maytype,
              'job': this.job,
              'weight': this.weight,
              'dist1': this.area[0]? this.area[0].value: '',
              'dist2': this.area[1]? this.area[1].value: '',
              'dist3': this.area[2]? this.area[2].value: '',
              'home1': this.hometown[0]? this.hometown[0].value: '',
              'home2': this.hometown[1]? this.hometown[1].value: '',
              'home3': this.hometown[2]? this.hometown[2].value: ''
          }

          const timer = setTimeout(() => this.$oeLoadingShow(), 200);
          if(this.is_reg) {
              return;
          }
          this.is_reg = true;
          /*axios({
              method: 'post',
              url: WAP_APPFILE+ '&c=passport&a=regpost',
              data: fd,
              responseType: 'json'
          }).then(res => {
              const data = res.data;
              if (data.response == "1") { //成功，返回页面
                  if(this.forward) {
                      window.location.href = this.forward;
                  } else {
                      window.location.href = WAP_APPFILE+"&c=cp"; //跳到个人中心
                  }
              } else if (data.response == "2") { //整合OEmarry
                  window.top.location.href = data.result;
              } else {
                  if (data.result.length > 0) {
                      this.$oeToast(data.result);
                  } else {
                      this.$oeToast("注册失败，请检查会员资料！");
                  }
              }
              this.$oeLoadingHide();
              clearTimeout(timer);
          }).catch(() => {
              this.$oeToast("系统繁忙，请稍后再试");
              this.$oeLoadingHide();
              clearTimeout(timer);
          });*/
          const t = this;
          $.ajax({
              type: 'POST',
              url: WAP_APPFILE+ '&c=passport&a=regpost',
              data: fd,
              success (res) {
                  const data = JSON.parse(res);
                  if (data.response == "1") { //成功，返回页面
                        window.location.href = WAP_APPFILE+"&c=passport&a=success";
                        /*
                        if(t.forward) {
                          window.location.href = t.forward;
                        } else {
                          window.location.href = WAP_APPFILE+"&c=cp"; //跳到个人中心
                        }
                        */
                  } 
                  
                  else if (data.response == "2") { //整合OEmarry
                      window.top.location.href = data.result;
                  } else {
                      if (data.result.length > 0) {
                          t.$oeToast(data.result);
                      } else {
                          t.$oeToast("注册失败，请检查会员资料！");
                      }
                  }
                  t.is_reg = false;
                  t.$oeLoadingHide();
                  clearTimeout(timer);
              },
              error (res) {
                  t.is_reg = false;
                  t.$oeLoadingHide();
                  clearTimeout(timer);
              }
          });
      },
      get_weight_data () {
          const fd = new FormData();
          fd.append('item', 'weight');
          fd.append('r', this.$oeRandom(8));
          axios({
              method: 'post',
              url: WAP_APPFILE+"&c=picker",
              data: fd
          }).then(res => {
              const data = res.data;
              if(data.response == '1') {
                  this.weight = data.result[0].value;
                  if(this.$refs.weight) {
                      this.$refs.weight.data.push(data.result);
                  }
              } else {
                  if(data.result) {
                      this.$oeToast(data.result);
                  } else {
                      this.$oeToast('体重数据加载失败');
                  }
              }
          }).catch(() => {
              this.$oeToast('体重数据加载失败');
          });
      },
      select_weight (arr) {
          arr[0].value && (this.weight = arr[0].value);
      },
      get_area_data () {
          const fd = new FormData();
          fd.append('a', 'area');
          fd.append('r', this.$oeRandom(8));
          axios({
              method: 'post',
              url: WAP_APPFILE+"&c=picker",
              data: fd
          }).then(res => {
              const data = res.data;
              if(data.response == '1') {
                  this.area_arr = data.result;
                  this.set_area_data(data.result);
              } else {
                  if(data.result) {
                      this.$oeToast(data.result);
                  } else {
                      this.$oeToast('地区数据加载失败');
                  }
              }
          }).catch(() => {
              this.$oeToast('地区数据加载失败');
          });
      },
      set_area_data(data) {
          this.$refs.area.linkPageData.push(data);
          const data2 = data[0].children;
          this.$refs.area.linkPageData.push(data2);
          const data3 = data2[0].children;
          this.$refs.area.linkPageData.push(data3);
          this.area = [data[0], data2[0], data3[0]];
      },
      select_area (arr) {
          if(arr[0]) {
              this.area[0] = arr[0];
          } else {
              this.area[0] = {};
          }
          if(arr[1]) {
              this.area[1] = arr[1];
          } else {
              this.area[1] = {};
          }
          if(arr[2]) {
              this.area[2] = arr[2];
          } else {
              this.area[2] = {};
          }
          this.$forceUpdate();
      },
      limit_length (name, max) {
          if(this[name].length > parseInt(max)) {
            this[name] = this[name].slice(0, max);
            this.$oeToast('用户名长度不能超过'+ max +'个字');
          }
      },
      get_hometown_data () {
          const fd = new FormData();
          fd.append('a', 'hometown');
          fd.append('r', this.$oeRandom(8));
          axios({
              method: 'post',
              url: WAP_APPFILE+"&c=picker",
              data: fd
          }).then(res => {
              const data = res.data;
              if(data.response == '1') {
                  this.hometown_arr = data.result;
                  this.set_hometown_data(data.result);
              } else {
                  if(data.result) {
                      this.$oeToast(data.result);
                  } else {
                      this.$oeToast('户籍数据加载失败');
                  }
              }
          }).catch(() => {
              this.$oeToast('户籍数据加载失败');
          });
      },
      set_hometown_data(data) {
          this.$refs.hometown.linkPageData.push(data);
          const data2 = data[0].children;
          this.$refs.hometown.linkPageData.push(data2);
          const data3 = data2[0].children;
          this.$refs.hometown.linkPageData.push(data3);
          this.hometown = [data[0], data2[0], data3[0]];
      },
      select_hometown (arr) {
          if(arr[0]) {
              this.hometown[0] = arr[0];
          } else {
              this.hometown[0] = {};
          }
          if(arr[1]) {
              this.hometown[1] = arr[1];
          } else {
              this.hometown[1] = {};
          }
          if(arr[2]) {
              this.hometown[2] = arr[2];
          } else {
              this.hometown[2] = {};
          }
          this.$forceUpdate();
      },
  }
});