/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.event;

import gr8pefish.openglider.common.capabilities.OpenGliderCapabilities;
import gr8pefish.openglider.common.capabilities.PlayerGlidingCapability;
import gr8pefish.openglider.common.helper.OpenGliderPlayerHelper;
import gr8pefish.openglider.common.network.PacketClientGliding;
import gr8pefish.openglider.common.network.PacketHandler;
import gr8pefish.openglider.common.network.PacketUpdateClientTarget;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerEventHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !((Entity)event.getObject()).hasCapability(OpenGliderCapabilities.GLIDING_CAPABILITY, null)) {
            event.addCapability(new ResourceLocation("openglider.gliding"), (ICapabilityProvider)new PlayerGlidingCapability());
        }
    }

    @SubscribeEvent
    public void onPlayerCloning(PlayerEvent.Clone event) {
        if (!event.isWasDeath() && event.getOriginal().hasCapability(OpenGliderCapabilities.GLIDING_CAPABILITY, null)) {
            PlayerGlidingCapability oldCap = (PlayerGlidingCapability)event.getOriginal().getCapability(OpenGliderCapabilities.GLIDING_CAPABILITY, null);
            PlayerGlidingCapability newCap = (PlayerGlidingCapability)event.getEntityPlayer().getCapability(OpenGliderCapabilities.GLIDING_CAPABILITY, null);
            newCap.setIsGliderDeployed(oldCap.getIsGliderDeployed());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (OpenGliderCapabilities.getIsGliderDeployed(event.player)) {
            OpenGliderPlayerHelper.updatePosition(event.player);
        }
    }

    @SubscribeEvent
    public void onTrack(PlayerEvent.StartTracking event) {
        EntityPlayer targetPlayer;
        EntityPlayer tracker = event.getEntityPlayer();
        Entity targetEntity = event.getTarget();
        if (targetEntity instanceof EntityPlayerMP && (targetPlayer = (EntityPlayer)targetEntity).hasCapability(OpenGliderCapabilities.GLIDING_CAPABILITY, null)) {
            if (OpenGliderCapabilities.getIsGliderDeployed(targetPlayer)) {
                PacketHandler.HANDLER.sendTo((IMessage)new PacketUpdateClientTarget(targetPlayer, true), (EntityPlayerMP)tracker);
            } else {
                PacketHandler.HANDLER.sendTo((IMessage)new PacketUpdateClientTarget(targetPlayer, false), (EntityPlayerMP)tracker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.syncGlidingCapability(event.player);
    }

    @SubscribeEvent
    public void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.syncGlidingCapability(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.syncGlidingCapability(event.player);
    }

    private void syncGlidingCapability(EntityPlayer player) {
        boolean deployed = OpenGliderCapabilities.getIsGliderDeployed(player);
        PacketHandler.HANDLER.sendTo((IMessage)new PacketClientGliding(deployed), (EntityPlayerMP)player);
    }
}

