/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.helper;

import gr8pefish.openglider.common.capabilities.OpenGliderCapabilities;
import gr8pefish.openglider.common.config.ConfigHandler;
import gr8pefish.openglider.common.item.ItemHangGlider;
import gr8pefish.openglider.common.network.PacketHandler;
import gr8pefish.openglider.common.network.PacketUpdateGliderDamage;
import gr8pefish.openglider.common.wind.WindHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OpenGliderPlayerHelper {
    public static void updatePosition(EntityPlayer player) {
        if (OpenGliderPlayerHelper.shouldBeGliding(player)) {
            ItemStack glider = OpenGliderPlayerHelper.getGlider(player);
            if (OpenGliderPlayerHelper.isValidGlider(glider)) {
                if (player.field_70181_x < 0.0) {
                    double verticalSpeed;
                    double horizontalSpeed;
                    if (player.func_70093_af()) {
                        horizontalSpeed = ConfigHandler.forwardMovementShift;
                        verticalSpeed = ConfigHandler.verticalMovementShift;
                    } else {
                        horizontalSpeed = ConfigHandler.forwardMovement;
                        verticalSpeed = ConfigHandler.verticalMovement;
                    }
                    WindHelper.applyWind(player, glider);
                    player.field_70181_x *= verticalSpeed;
                    double x = Math.cos(Math.toRadians(player.field_70177_z + 90.0f)) * horizontalSpeed;
                    double z = Math.sin(Math.toRadians(player.field_70177_z + 90.0f)) * horizontalSpeed;
                    player.field_70159_w += x;
                    player.field_70179_y += z;
                    player.field_70143_R = 0.0f;
                }
                if (player.field_70170_p.field_72995_K) {
                    player.field_184619_aG = 0.0f;
                    player.field_70721_aZ = 0.0f;
                }
                if (ConfigHandler.durabilityEnabled && !player.field_70170_p.field_72995_K && player.field_70170_p.field_73012_v.nextInt(ConfigHandler.durabilityTimeframe) == 0) {
                    PacketHandler.HANDLER.sendTo((IMessage)new PacketUpdateGliderDamage(), (EntityPlayerMP)player);
                    glider.func_77972_a(ConfigHandler.durabilityPerUse, (EntityLivingBase)player);
                    if (ItemHangGlider.isBroken(glider)) {
                        OpenGliderCapabilities.setIsGliderDeployed(player, false);
                    }
                }
            } else {
                OpenGliderCapabilities.setIsGliderDeployed(player, false);
            }
        }
    }

    public static boolean shouldBeGliding(EntityPlayer player) {
        if (player == null || player.field_70128_L) {
            return false;
        }
        return !player.field_70122_E && !player.func_70090_H();
    }

    private static boolean isValidGlider(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemHangGlider && !ItemHangGlider.isBroken(stack);
    }

    public static ItemStack getGlider(EntityPlayer player) {
        if (ConfigHandler.holdingGliderEnforced) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ItemHangGlider) {
            return player.func_184592_cb();
        }
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemHangGlider)) continue;
            return stack;
        }
        return null;
    }
}

