/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.openglider.common.item;

import gr8pefish.openglider.common.OpenGlider;
import gr8pefish.openglider.common.capabilities.OpenGliderCapabilities;
import gr8pefish.openglider.common.config.ConfigHandler;
import gr8pefish.openglider.common.helper.OpenGliderPlayerHelper;
import gr8pefish.openglider.common.network.PacketHandler;
import gr8pefish.openglider.common.network.PacketUpdateClientTarget;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemHangGlider
extends Item {
    public ItemHangGlider() {
        this.func_77637_a(OpenGlider.creativeTab);
        this.func_77655_b("openglider:hang_glider");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("status"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return this.isGlidingGlider(entityIn, stack) ? 1.0f : (ItemHangGlider.isBroken(stack) ? 2.0f : 0.0f);
            }

            private boolean isGlidingGlider(EntityLivingBase entityIn, ItemStack stack) {
                return entityIn != null && entityIn instanceof EntityPlayer && OpenGliderCapabilities.getIsGliderDeployed((EntityPlayer)entityIn) && OpenGliderPlayerHelper.getGlider((EntityPlayer)entityIn) == stack;
            }
        });
        this.func_77656_e(ConfigHandler.durabilityTotal);
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.func_77951_h() && stack.func_77952_i() >= stack.func_77958_k() - 1;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.func_77973_b().equals(newStack.func_77973_b());
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        List leathers = OreDictionary.getOres((String)"leather");
        for (ItemStack stack : leathers) {
            if (stack.func_77973_b() != repair.func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack chestItem = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chestItem == null || !(chestItem.func_77973_b() instanceof ItemElytra)) {
            if (ItemHangGlider.isBroken(itemStack)) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
            }
            boolean isDeployed = OpenGliderCapabilities.getIsGliderDeployed(player);
            OpenGliderCapabilities.setIsGliderDeployed(player, !isDeployed);
            if (!world.field_72995_K) {
                EntityTracker tracker = world.func_73046_m().func_71218_a(player.field_71093_bK).func_73039_n();
                tracker.func_151247_a((Entity)player, PacketHandler.HANDLER.getPacketFrom((IMessage)new PacketUpdateClientTarget(player, OpenGliderCapabilities.getIsGliderDeployed(player))));
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("openglider.elytra.error", new Object[0]));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
    }
}

