/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.nov;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMPropertyGroup;
import com.openkm.api.OKMSearch;
import com.openkm.bean.Document;
import com.openkm.bean.QueryResult;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Select;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.NoSuchPropertyException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.ConfigDAO;
import com.openkm.dao.DatabaseMetadataDAO;
import com.openkm.dao.bean.DatabaseMetadataValue;
import com.openkm.dao.bean.QueryParams;
import com.openkm.extension.core.ExtensionException;
import com.openkm.frontend.client.util.Util;
import com.openkm.module.db.stuff.DbSessionManager;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.util.DatabaseMetadataUtils;
import com.openkm.util.ISO8601;
import com.openkm.util.MailUtils;
import com.openkm.util.TemplateUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.mail.MessagingException;

public class InitialNotification {
    public static void main(String[] args) {
        System.out.println(InitialNotification.cronTask());
    }

    public static String cronTask() {
        try {
            String applicationUrl = ConfigDAO.getString((String)"application.url", (String)"http://localhost:8080/OpenKM");
            String datePattern = ConfigDAO.getString((String)"expiration.date.pattern", (String)"dd-MM-yyyy HH:mm:ss");
            String subject = ConfigDAO.getString((String)"expiration.notification.subject", (String)"New uploaded document with expiration");
            String template = ConfigDAO.getString((String)"expiration.notification.template", (String)"New document uploaded<br/>${docUrl}<br/>Expiration date:${date}<br/>");
            String systemToken = DbSessionManager.getInstance().getSystemToken();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("okp:expiration.state", "notify");
            QueryParams params = new QueryParams();
            params.setPath("/okm:root");
            params.setProperties(properties);
            List results = OKMSearch.getInstance().find(systemToken, params);
            for (QueryResult result : results) {
                if (result.getDocument() == null) continue;
                HashMap<String, String> templateMap = new HashMap<String, String>();
                ArrayList<String> mails = new ArrayList<String>();
                Document doc = result.getDocument();
                String docUrl = "<a href=\"" + applicationUrl + "?docPath=" + URLEncoder.encode(doc.getPath(), "UTF-8") + "\">";
                docUrl = String.valueOf(docUrl) + Util.getName((String)doc.getPath()) + "</a>\n";
                templateMap.put("docUrl", docUrl);
                List docProperties = OKMPropertyGroup.getInstance().getProperties(systemToken, doc.getPath(), "okg:expiration");
                for (FormElement formElement : docProperties) {
                    Select select;
                    if (formElement.getName().equals("okp:expiration.date")) {
                        Input expirationDate = (Input)formElement;
                        Calendar date = ISO8601.parseBasic((String)expirationDate.getValue());
                        Calendar actualDay = Calendar.getInstance();
                        if (actualDay.compareTo(date) > 0) {
                            date = actualDay;
                        }
                        date.set(10, 0);
                        date.set(12, 0);
                        date.set(13, 0);
                        date.set(14, 0);
                        expirationDate.setValue(ISO8601.formatBasic((Calendar)date));
                        SimpleDateFormat sf = new SimpleDateFormat(datePattern);
                        templateMap.put("date", sf.format(date.getTime()));
                        continue;
                    }
                    if (formElement.getName().equals("okp:expiration.state")) {
                        select = (Select)formElement;
                        for (Option option : select.getOptions()) {
                            if (option.getValue().equals("valid")) {
                                option.setSelected(true);
                                continue;
                            }
                            option.setSelected(false);
                        }
                        continue;
                    }
                    if (!formElement.getName().equals("okp:expiration.group.notify")) continue;
                    select = (Select)formElement;
                    for (Option option : select.getOptions()) {
                        if (!option.isSelected()) continue;
                        String table = "group";
                        String filter = "$gru_name='" + option.getValue() + "'";
                        String order = "";
                        for (DatabaseMetadataValue dmv : DatabaseMetadataDAO.executeValueQuery((String)DatabaseMetadataUtils.buildQuery((String)table, (String)filter, (String)order))) {
                            String user = (String)DatabaseMetadataUtils.getDatabaseMetadataValueMap((DatabaseMetadataValue)dmv).get("gru_user");
                            String mail = OKMAuth.getInstance().getMail(systemToken, user);
                            if (user == null || mail == null || mail.equals("")) continue;
                            mails.add(mail);
                        }
                    }
                }
                OKMPropertyGroup.getInstance().setProperties(systemToken, doc.getPath(), "okg:expiration", docProperties);
                if (mails.size() <= 0) continue;
                MailUtils.sendMessage(mails, (String)subject, (String)TemplateUtils.replace((String)"UPLOADED_NOTIFICATION", (String)template, templateMap));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        catch (NoSuchGroupException e) {
            e.printStackTrace();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (NoSuchPropertyException e) {
            e.printStackTrace();
        }
        catch (LockException e) {
            e.printStackTrace();
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (ExtensionException e) {
            e.printStackTrace();
        }
        catch (PrincipalAdapterException e) {
            e.printStackTrace();
        }
        return "";
    }
}

