/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.extension.nov;

import com.openkm.api.OKMAuth;
import com.openkm.api.OKMPropertyGroup;
import com.openkm.api.OKMSearch;
import com.openkm.bean.Document;
import com.openkm.bean.QueryResult;
import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Input;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Select;
import com.openkm.core.DatabaseException;
import com.openkm.core.NoSuchGroupException;
import com.openkm.core.ParseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.ConfigDAO;
import com.openkm.dao.DatabaseMetadataDAO;
import com.openkm.dao.bean.DatabaseMetadataValue;
import com.openkm.dao.bean.QueryParams;
import com.openkm.frontend.client.util.Util;
import com.openkm.module.db.stuff.DbSessionManager;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.util.DatabaseMetadataUtils;
import com.openkm.util.ISO8601;
import com.openkm.util.MailUtils;
import com.openkm.util.TemplateUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.mail.MessagingException;

public class AlertExpirationNotification {
    public static void main(String[] args) {
        System.out.println(AlertExpirationNotification.cronTask());
    }

    public static String cronTask() {
        try {
            String systemToken = DbSessionManager.getInstance().getSystemToken();
            HashMap usersToAlert = new HashMap();
            String applicationUrl = ConfigDAO.getString((String)"application.url", (String)"http://localhost:8080/OpenKM");
            String datePattern = ConfigDAO.getString((String)"expiration.date.pattern", (String)"dd-MM-yyyy HH:mm:ss");
            int expirationDays = Integer.parseInt(ConfigDAO.getString((String)"expiration.expiration.alert.days", (String)"15"));
            String subject = ConfigDAO.getString((String)"expiration.alert.subject", (String)"Alert documents will expire");
            String template = ConfigDAO.getString((String)"expiration.alert.template", (String)"Document ${docUrl} will expire at ${date}<br/>");
            Calendar to = Calendar.getInstance();
            to.set(10, 0);
            to.set(12, 0);
            to.set(13, 0);
            Calendar from = (Calendar)to.clone();
            to.add(5, expirationDays);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("okp:expiration.date", String.valueOf(ISO8601.formatBasic((Calendar)from)) + "," + ISO8601.formatBasic((Calendar)to));
            properties.put("okp:expiration.state", "valid");
            QueryParams params = new QueryParams();
            params.setPath("/okm:root");
            params.setProperties(properties);
            List results = OKMSearch.getInstance().find(systemToken, params);
            for (QueryResult result : results) {
                if (result.getDocument() == null) continue;
                Document doc = result.getDocument();
                List docProperties = OKMPropertyGroup.getInstance().getProperties(systemToken, doc.getPath(), "okg:expiration");
                for (FormElement formElement : docProperties) {
                    if (!formElement.getName().equals("okp:expiration.group.alert")) continue;
                    Select select = (Select)formElement;
                    for (Option option : select.getOptions()) {
                        if (!option.isSelected()) continue;
                        String table = "group";
                        String filter = "$gru_name='" + option.getValue() + "'";
                        String order = "";
                        String query = DatabaseMetadataUtils.buildQuery((String)table, (String)filter, (String)order);
                        for (DatabaseMetadataValue dmv : DatabaseMetadataDAO.executeValueQuery((String)query)) {
                            List<Document> alertDocs;
                            String user = (String)DatabaseMetadataUtils.getDatabaseMetadataValueMap((DatabaseMetadataValue)dmv).get("gru_user");
                            String mail = OKMAuth.getInstance().getMail(systemToken, user);
                            if (user == null || mail == null || mail.equals("")) continue;
                            if (usersToAlert.containsKey(mail)) {
                                alertDocs = (List)usersToAlert.get(mail);
                                alertDocs.add(doc);
                                continue;
                            }
                            alertDocs = new ArrayList();
                            alertDocs.add(doc);
                            usersToAlert.put(mail, alertDocs);
                        }
                    }
                }
            }
            for (String userMail : usersToAlert.keySet()) {
                String msg = "";
                for (Document doc : (List)usersToAlert.get(userMail)) {
                    HashMap<String, String> templateMap = new HashMap<String, String>();
                    String docUrl = "<a href=\"" + applicationUrl + "?docPath=" + URLEncoder.encode(doc.getPath(), "UTF-8") + "\">";
                    docUrl = String.valueOf(docUrl) + Util.getName((String)doc.getPath()) + "</a>\n";
                    templateMap.put("docUrl", docUrl);
                    List docProperties = OKMPropertyGroup.getInstance().getProperties(systemToken, doc.getPath(), "okg:expiration");
                    for (FormElement formElement : docProperties) {
                        if (!formElement.getName().equals("okp:expiration.date")) continue;
                        Input expirationDate = (Input)formElement;
                        Calendar date = ISO8601.parseBasic((String)expirationDate.getValue());
                        date.set(10, 0);
                        date.set(12, 0);
                        date.set(13, 0);
                        date.set(14, 0);
                        SimpleDateFormat sf = new SimpleDateFormat(datePattern);
                        templateMap.put("date", sf.format(date.getTime()));
                    }
                    msg = String.valueOf(msg) + TemplateUtils.replace((String)"ALERT_NOTIFICATION", (String)template, templateMap);
                }
                MailUtils.sendMessage((String)userMail, (String)subject, (String)msg);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        catch (NoSuchGroupException e) {
            e.printStackTrace();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (PrincipalAdapterException e) {
            e.printStackTrace();
        }
        return "";
    }
}

