# Open Source Document Management System
OpenKM Community Edition is an [Open Source Document Management System](https://www.openkm.com/en/open-source-document-management-system.html). If you are looking for a free cost then "Community" is your best option. OpenKM [document management system (DMS)](https://www.openkm.com/en/document-management.html) allows businesses to control the production, storage, management and distribution of electronic documents, yielding greater effectiveness and the ability to reuse information and to control the flow of the documents.

OpenKM integrates all essential documents management, collaboration and an advanced search functionality into one easy to use solution. The system also includes administration tools to define the roles of various users, access control, user quota, level of document security, detailed logs of activity and automations setup.

OpenKM builds a highly valuable repository of corporate information assets to facilitate [knowledge](https://www.openkm.com/en/knowledge-management-system.html) creation and improve business decision making, boosting workgroups and enterprise productivity through shared practices, greater, better customer relations, faster sales cycles, improved product time-to-market, and better-informed decision making.

With OpenKM Open Source Community Edition you can:
 * Collect information from any digital source.
 * Collaborate with colleagues on documents and projects.
 * Empower organizations to capitalize on accumulated knowledge by locating documents, experts, and information sources.
 * Embedded workflow engine to take control of your business case.
 * Automate tasks.

## Installing binaries
You can install OpenKM binaries from [SourceForge](https://sourceforge.net/projects/openkm/):
 * **OKMInstaller.jar**: The OpenKM installer assistant. Usage information at [using the installer](https://docs.openkm.com/kcenter/view/okm-6.3-com/using-the-installer.html).
 * **OpenKM-${Version}.zip**: Which just contains the OpenKM.war application without Tomcat and configuration
 files needed to get it running.

## Installation wizard videos
### Linux
This video shows step by step the installation process of OpenKM Community version in Linux.

[![Community version installation in Linux](https://img.youtube.com/vi/WJrkD2BdAJo/0.jpg)](https://www.youtube.com/watch?v=WJrkD2BdAJo "Community version installation in Linux")

[Spanish version](https://www.youtube.com/watch?v=2_CMEpHkwqA)

### Windows
This video shows step by step the installation process of OpenKM Community version in Windows.

[![Community installation process in Windows](https://img.youtube.com/vi/7C40UMajJ0k/0.jpg)](https://www.youtube.com/watch?v=7C40UMajJ0k "Community installation process in Windows")

[Spanish version](https://www.youtube.com/watch?v=6F7Hany7BMc)

## Docker
[OpenKM official release of docker](https://hub.docker.com/r/openkm/openkm-ce)

## Building from Source
```sh
$ git clone [git-repo-url] openkm-community
$ cd openkm-community
$ mvn clean package
```

## Documentation
 * [OpenKM Knowledge Center](https://docs.openkm.com/kcenter/view/okm-6.3-com/)
 * [Hardware and software requirements](https://docs.openkm.com/kcenter/view/okm-6.3-com/hardware-and-software-requirements.html)
 * [Installation](https://docs.openkm.com/kcenter/view/okm-6.3-com/installation.html)
 * [Using the installer](https://docs.openkm.com/kcenter/view/okm-6.3-com/using-the-installer.html)
 * [Troubleshooting](https://docs.openkm.com/kcenter/view/okm-6.3-com/troubleshooting.html)
 * [Administration guide](https://docs.openkm.com/kcenter/view/okm-6.3-com/administration-guide.html)
 * [User guide](https://docs.openkm.com/kcenter/view/okm-6.3-com/user-guide.html)
 * [Migration guide](https://docs.openkm.com/kcenter/view/okm-6.3-com/migration-guide.html)
 * [Development guide](https://docs.openkm.com/kcenter/view/okm-6.3-com/development.html)

## Reporting issues
OpenKM Open Source Community Edition is supported by developers and technical enthusiasts via [the forum](http://forum.openkm.com) of the user community. If you want to raise an issue, please follow the below recommendations:
 * Before you post a question, please search the question to see if someone has already reported it / asked for it.
 * If the question does not already exist, create a new post.
 * Please provide as much detailed information as possible with the issue report. We need to know the version of OpenKM, Operating System, browser and whatever you think might help us to understand the problem or question.

## License
[OpenKM Document Management System Community Edition](https://www.openkm.com/en/open-source-document-management-system.html) is available to Open Source community under the [GNU General Public Licence version 2](https://www.gnu.org/licenses/gpl-2.0.html).
The OpenKM source code is available for the entire community, which is free to use, modify and redistribute under the premises of such license.
