/**
 * OpenKM, Open Document Management System (http://www.openkm.com)
 * Copyright (c) 2006-2017  Paco Avila & Josep Llort
 * <p>
 * No bytes were intentionally harmed during the development of this application.
 * <p>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * <p>
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package com.openkm.extension.frontend.client.service;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.bean.extension.GWTWikiPage;

import java.util.List;

/**
 * OKMWikiService
 *
 * @author jllort
 *
 */
@RemoteServiceRelativePath("../extension/Wiki")
public interface OKMWikiService extends RemoteService {
	public GWTWikiPage findLatestByNode(String uuid) throws OKMException;

	public GWTWikiPage createNewWikiPage(GWTWikiPage wikiPage) throws OKMException;

	public void lock(GWTWikiPage wikiPage) throws OKMException;

	public GWTWikiPage updateWikiPage(GWTWikiPage wikiPage) throws OKMException;

	public void deleteWikiPage(GWTWikiPage wikiPage) throws OKMException;

	public void unlock(GWTWikiPage wikiPage) throws OKMException;

	public GWTWikiPage findLatestByTitle(String title) throws OKMException;

	public List<GWTWikiPage> findAllByTitle(String title) throws OKMException;

	public GWTWikiPage restoreWikiPage(GWTWikiPage wikiPage) throws OKMException;

	public List<String> findAllLatestByTitleFiltered(String filter) throws OKMException;

	public List<GWTWikiPage> findAllHistoricByTitle(String title) throws OKMException;
}