unit CommunityLinks;

interface

procedure LoadCommunityLinks;

implementation

uses FormMain,SysUtils,Dialogs,Menus;

// *****************************************************
// ********* Community Menu Loading Procedures *********
// *****************************************************

procedure LoadCommunityLinks;
var
   CatCounter,Counter,position : word; // String element and its char position
   line,pos : word; // File line and position
   token : char; // current char
   F : Text; // file
   OnText,OnUrl,OnName,OnCategory : Boolean;
   CatName : String;
   Item : TMenuItem;
begin
   // Check for file
   if not fileexists(extractfiledir(ParamStr(0))+'/commlist.ini') then
   begin
      ShowMessage('Error! Commlist.ini doesn''t exist. Initialization aborted!');
      FrmMain.Close;
      Exit;
   end;

   // Open File
   AssignFile(F,extractfiledir(ParamStr(0))+'/commlist.ini');
   Reset(F);

   // Reset engine
   CatCounter := 2;
   counter := 0;
   position := 0;
   line := 1;
   pos := 1;
   OnText := false;
   OnUrl := false;
   OnName := false;
   OnCategory := false;

   // Start reading
   while not EOF(F) do
   begin
      // Read next char
      Read(F,token);

      // If it's receiving text, then...
      if OnText then
      begin
         case (token) of
         ']':
         begin
            inc(pos);
            inc(line);
            OnCategory := false;
            OnText := false;
            Item := TMenuItem.Create(FrmMain);
            Item.Caption := CatName;
            Item.Tag := CatCounter;
            Item.Visible := true;
            FrmMain.Comm1.Add(Item);
            inc(CatCounter);
            ReadLn(F);
         end;
         '$':
         begin
            inc(pos);
            inc(line);
            OnUrl := false;
            OnText := false;
            Readln(F);
         end;
         '>':
         begin
            inc(pos);
            inc(line);
            OnName := false;
            OnText := false;
            Item := TMenuItem.Create(FrmMain);
            Item.Caption := FrmMain.SiteList[counter].SiteName;
            Item.Tag := Counter;
            Item.OnClick := FrmMain.LoadSite;
            Item.Visible := true;
            FrmMain.Comm1.Items[CatCounter].Add(Item);
            inc(counter);
            Readln(F);
         end;
         else
         begin
            if OnCategory then
            begin
               SetLength(CatName,position);
               CatName[position] := token;
            end
            else if OnUrl then
            begin
               SetLength(FrmMain.SiteList[counter].SiteUrl,position);
               FrmMain.SiteList[counter].SiteUrl[position] := token;
            end
            else if OnName then
            begin
               SetLength(FrmMain.SiteList[counter].SiteName,position);
               FrmMain.SiteList[counter].SiteName[position] := token;
            end;
            inc(position);
         end;
         end;
      end
      else // searching instructions
      begin
         case (token) of
         ' ':
         begin
            inc(pos);
         end;
         '[':
         begin
            inc(pos);
            position := 1;
            OnCategory := true;
            OnText := true;
            CatName := '';
         end;
         '$':
         begin
            inc(pos);
            position := 1;
            OnUrl := true;
            OnText := true;
            SetLength(FrmMain.SiteList,Counter+1);
         end;
         '<':
         begin
            inc(pos);
            position := 1;
            OnName := true;
            OnText := true;
         end;
         '#':
         begin
            Readln(F);
            inc(line);
            pos := 1;
         end;
         else
            ShowMessage('Community Links Error: Parse error at Line ' + IntToStr(line) + ', Position ' + IntToStr(pos));
         end;
      end;
   end;
   CloseFile(F);
end;



end.
