unit OS_SHP_Tools;

interface
uses Windows, Graphics, SHP_Image, SHP_File, math, Palette, Colour_list, SHP_Colour_Bank,
     SHP_Engine_CCMs;


// Functions

// Line
function getgradient(last,first : TPoint2D) : single;
procedure drawstraightline_temp(var tempview : TObjectData; var TempView_no : integer; var last,first : TPoint2D);

// Flood And Fill
procedure FloodFillTool(var SHP: TSHP; Frame,Xpos,Ypos: Integer; Colour : byte);

// Rectangle
procedure Rectangle(var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos,Xpos2,Ypos2:Integer; Fill: Boolean);
procedure Rectangle_dotted(const SHP: TSHP; var TempView: TObjectData; var TempView_no:integer; const SHPPalette:TPalette; Frame: Word; Xpos,Ypos,Xpos2,Ypos2:Integer);

// Elipse
procedure Elipse(var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos,Xpos2,Ypos2:Integer; Fill: Boolean);

// Brush
procedure BrushTool(var SHP: TSHP; var TempView: TObjectData; var TempView_no: integer; Xc,Yc,BrushMode,Colour: Integer);

// DarkenLighten
procedure BrushToolDarkenLighten(var SHP:TSHP; Frame: Word; Xc,Yc: Integer; BrushMode: Integer); overload;
procedure BrushToolDarkenLighten(var SHP:TSHP; var TempView: TObjectData; var TempView_no: integer; Frame: Word; Xc,Yc: Integer; BrushMode: Integer); overload;
function darkenlightenv(Darken:boolean; Current_Value,Value : byte) : byte;

// Damager
procedure AddColourToTempview(const SHP:TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
procedure AddColourToSHP(var SHP:TSHP; var Palette: TPalette; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
procedure Crash(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure Crash(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure CrashLight(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure CrashLight(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure CrashBig(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure CrashBig(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure CrashBigLight(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure CrashBigLight(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure Dirty(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure Dirty(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;

// Snowy
procedure AddSnowColourToTempview(const SHP:TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
procedure AddSnowColourToSHP(var SHP:TSHP; const Palette: TPalette; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
procedure Snow(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
procedure Snow(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;

// Etc...
function InImageBounds(x,y : integer; const SHP:TSHP) : boolean;
function OpositeColour(color : TColor) : tcolor;


implementation

uses FormMain;

function getgradient(last,first : TPoint2D) : single;
begin
if (first.X = last.X) or (first.Y = last.Y) then
   result := 0
else
   result := (first.Y-last.Y) / (first.X-last.X);
end;


procedure drawstraightline_temp(var tempview : TObjectData; var TempView_no : integer; var last,first : TPoint2D);
var
x,y : integer;
gradient,c : single;
begin
// Straight Line Equation : Y=MX+C

//memo1.lines.add('First Click:');
//memo1.lines.add('X:' +inttostr(first.X)+' Y:' +inttostr(first.Y)+' Z:' +inttostr(first.Z));
//memo1.lines.add('Last Click:');
//memo1.lines.add('X:' +inttostr(last.X)+' Y:' +inttostr(last.Y)+' Z:' +inttostr(last.Z));

gradient := getgradient(last,first);

c := last.Y-(last.X * gradient);

//memo1.lines.add(#13'Starting X:'+inttostr(first.X) + ' Starting Y:'+inttostr(first.Y));
//memo1.lines.add('Ending X:'+inttostr(last.X) + ' Ending Y:'+inttostr(last.Y));

//memo1.lines.add(#13'Gradient:'+floattostr(gradient));
//memo1.lines.add('C:'+floattostr(c));

//memo1.lines.add(#13'Using X constantly changing by 1 to get Y:');

//showmessage(inttostr(gradient));

TempView_no := 0;
setlength(tempview,0);

if (gradient=0) and (first.X = last.X) then
for y := min(first.Y,last.y) to max(first.Y,last.y) do
begin
TempView_no := TempView_no +1;
setlength(tempview,TempView_no+1);

tempview[TempView_no].X := first.X;
tempview[TempView_no].Y := y;

end
else
if (gradient=0) and (first.Y = last.Y) then
for x := min(first.x,last.x) to max(first.x,last.x) do
begin
TempView_no := TempView_no +1;
setlength(tempview,TempView_no+1);

tempview[TempView_no].X := x;
tempview[TempView_no].Y := first.Y;

end
else
begin

for x := min(first.X,last.X) to max(first.X,last.X) do
begin
//memo1.lines.add('Y:' +inttostr(round((gradient*x)+c)) + ' X:' + inttostr(x));
TempView_no := TempView_no +1;
setlength(tempview,TempView_no+1);

tempview[TempView_no].X := x;
tempview[TempView_no].Y := round((gradient*x)+c);


end;

//memo1.lines.add(#13'Using Y constantly changing by 1 to get X:');

for y := min(first.Y,last.Y) to max(first.Y,last.Y) do
begin
//memo1.lines.add('Y:' +inttostr(y) + ' X:' + inttostr(round((y-c)/ gradient)));

TempView_no := TempView_no +1;
setlength(tempview,TempView_no+1);

tempview[TempView_no].X := round((y-c)/ gradient);
tempview[TempView_no].Y := y;
end;

end;

end;

// File: Voxel.pas
// Original Procedure Name: procedure TVoxelSection.FloodFillTool(Xpos,Ypos,Zpos: Integer; v: TVoxelUnpacked; EditView: EVoxelViewOrient);
// Flood Fill Code Taken From Voxel Section Editor and adapted to this program

procedure FloodFillTool(var SHP: TSHP; Frame,Xpos,Ypos: Integer; Colour : byte);
type
  FloodSet = (Left,Right,Up,Down);
  Flood2DPoint = record
    X,Y: Integer;
  end;
  StackType = record
    Dir: set of FloodSet;
    p: Flood2DPoint;
  end;
  function PointOK(var SHP:TSHP; l: Flood2DPoint): Boolean;
  begin
    PointOK:=False;
    if (l.X<0) or (l.Y<0) then Exit;
    if (l.X>=SHP.Header.Width) or (l.Y>=SHP.Header.Height) then Exit;
    PointOK:=True;
  end;
var
  z1,z2: byte;
  i,j,k: Integer;         //this isn't 100% FloodFill, but function is very handy for user;
  Stack: Array of StackType; //this is the floodfill stack for my code
  SC,Sp: Integer; //stack counter and stack pointer
  po: Flood2DPoint;
  Full: set of FloodSet;
  Done: Array of Array of Boolean;
begin
  SetLength(Done,SHP.Header.Width,SHP.Header.Height);
  SetLength(Stack,SHP.Header.Width*SHP.Header.Height);
  //this array avoids creation of extra stack objects when it isn't needed.
  for i:=0 to SHP.Header.Width - 1 do
    for j:=0 to SHP.Header.Height - 1 do
        Done[i,j]:=False;

  z1 := SHP.Data[Frame].FrameImage[Xpos,Ypos];
  SHP.Data[Frame].FrameImage[Xpos,Ypos] := Colour;


    Full:=[Left,Right,Up,Down];
    Sp:=0;
    Stack[Sp].Dir:=Full;
    Stack[Sp].p.X:=Xpos; Stack[Sp].p.Y:=Ypos;
    SC:=1;
    while (SC>0) do begin
      if Left in Stack[Sp].Dir then begin //it's in there - check left
        //not in there anymore! we're going to do that one now.
        Stack[Sp].Dir:=Stack[Sp].Dir - [Left];
        po:=Stack[Sp].p;
        Dec(po.X);

        //now check this point - only if it's within range, check it.
        if PointOK(SHP,po) then begin
        z2 := SHP.Data[Frame].FrameImage[po.X,po.Y];
          if z2=z1 then begin
            SHP.Data[Frame].FrameImage[po.X,po.Y] := Colour;
            if not Done[po.X,po.Y] then begin
              Stack[SC].Dir:=Full-[Right]; //Don't go back
              Stack[SC].p:=po;
              Inc(SC);
              Inc(Sp); //increase stack pointer
            end;
            Done[po.X,po.Y]:=True;
          end;
        end;
      end;
      if Right in Stack[Sp].Dir then begin //it's in there - check left
        //not in there anymore! we're going to do that one now.
        Stack[Sp].Dir:=Stack[Sp].Dir - [Right];
        po:=Stack[Sp].p;
        Inc(po.X);
        //now check this point - only if it's within range, check it.
        if PointOK(SHP,po) then begin
          z2 := SHP.Data[Frame].FrameImage[po.X,po.Y];
          if z2=z1 then begin
            SHP.Data[Frame].FrameImage[po.X,po.Y] := Colour;
            if not Done[po.X,po.Y] then begin
              Stack[SC].Dir:=Full-[Left]; //Don't go back
              Stack[SC].p:=po;
              Inc(SC);
              Inc(Sp); //increase stack pointer
            end;
            Done[po.X,po.Y]:=True;
          end;
        end;
      end;
      if Up in Stack[Sp].Dir then begin //it's in there - check left
        //not in there anymore! we're going to do that one now.
        Stack[Sp].Dir:=Stack[Sp].Dir - [Up];
        po:=Stack[Sp].p;
        Dec(po.Y);

        //now check this point - only if it's within range, check it.
        if PointOK(SHP,po) then begin
          z2 := SHP.Data[Frame].FrameImage[po.X,po.Y];
          if z2=z1 then begin
            SHP.Data[Frame].FrameImage[po.X,po.Y] := Colour;
            if not Done[po.X,po.Y] then begin
              Stack[SC].Dir:=Full-[Down]; //Don't go back
              Stack[SC].p:=po;
              Inc(SC);
              Inc(Sp); //increase stack pointer
            end;
            Done[po.X,po.Y]:=True;
          end;
        end;
      end;
      if Down in Stack[Sp].Dir then begin //it's in there - check left
        //not in there anymore! we're going to do that one now.
        Stack[Sp].Dir:=Stack[Sp].Dir - [Down];
        po:=Stack[Sp].p;
        Inc(po.Y);

        //now check this point - only if it's within range, check it.
        if PointOK(SHP,po) then begin
          z2 := SHP.Data[Frame].FrameImage[po.X,po.Y];
          if z2=z1 then begin
            SHP.Data[Frame].FrameImage[po.X,po.Y] := Colour;
            if not Done[po.X,po.Y] then begin
              Stack[SC].Dir:=Full-[Up]; //Don't go back
              Stack[SC].p:=po;
              Inc(SC);
              Inc(Sp); //increase stack pointer
            end;
            Done[po.X,po.Y]:=True;
          end;
        end;
      end;
      if (Stack[Sp].Dir = []) then begin
        Dec(Sp);
        Dec(SC);
        //decrease stack pointer and stack count
      end;
    end;
SetLength(Stack,0); // Free Up Memory
SetLength(Done,0); // Free Up Memory
end;

// File: FormMain.pas
// Original Procedure Name: procedure TFrmMain.Rectangle(Xpos,Ypos,Zpos,Xpos2,Ypos2,Zpos2:Integer; Fill: Boolean);
// Flood Fill Code Taken From Voxel Section Editor and adapted to this program

procedure Rectangle(var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos,Xpos2,Ypos2:Integer; Fill: Boolean);
var
  i,j: Integer;
  Inside,Exact: Integer;
begin

  tempview_no := 0;
  setlength(tempview,0);

  for i:=Min(Xpos,Xpos2) to Max(Xpos,Xpos2) do begin
    for j:=Min(Ypos,Ypos2) to Max(Ypos,Ypos2) do begin
        Inside:=0; Exact:=0;

              if (i>Min(Xpos,Xpos2)) and (i<Max(Xpos,Xpos2)) then Inc(Inside);
              if (j>Min(Ypos,Ypos2)) and (j<Max(Ypos,Ypos2)) then Inc(Inside);
              if (i=Min(Xpos,Xpos2)) or (i=Max(Xpos,Xpos2)) then Inc(Exact);
              if (j=Min(Ypos,Ypos2)) or (j=Max(Ypos,Ypos2)) then Inc(Exact);

        if Fill then begin
          if Inside+Exact=2 then begin
           tempview_no := tempview_no +1;
           setlength(tempview,tempview_no +1);
           tempview[tempview_no].X := i;
           tempview[tempview_no].Y := j;
          end;
        end else begin
          if (Exact>=1) and (Inside+Exact=2) then begin
          tempview_no := tempview_no +1;
           setlength(tempview,tempview_no +1);
           tempview[tempview_no].X := i;
           tempview[tempview_no].Y := j;
        end;
      end;
    end;
  end;
end;

procedure Elipse(var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos,Xpos2,Ypos2:Integer; Fill: Boolean);
var
  i,j,k,a,b,c,d,last:smallint;
begin

  tempview_no := 0;
  setlength(tempview,0);
  if abs(Xpos - Xpos2) >= abs(Ypos - Ypos2) then
  begin
     a := sqr(abs((Xpos - Xpos2) div 2));
     b := sqr(abs((Ypos - Ypos2) div 2));
     c := (Ypos + Ypos2) div 2;
     d := (Xpos + Xpos2) div 2;
     if (a >= 1) and not Fill then
     begin
        last := round(sqrt((b * (a - ((d - Min(Xpos,Xpos2)) * (d - Min(Xpos,Xpos2))))) div a));
        for i:=(d - Min(Xpos,Xpos2)) downto 0 do
        begin
           j := round(sqrt((b * (a - (i * i))) div a));
           if abs(j - last) > 1 then
           begin
              for k := abs(j - last) downto 0 do
              begin
                 tempview_no := tempview_no +1;
                 setlength(tempview,tempview_no +4);
                 tempview[tempview_no].X := d + i;
                 tempview[tempview_no].Y := c + j - k;
                 tempview_no := tempview_no +1;
                 tempview[tempview_no].X := d + i;
                 tempview[tempview_no].Y := c - j + k;
                 tempview_no := tempview_no +1;
                 tempview[tempview_no].X := d - i;
                 tempview[tempview_no].Y := c + j - k;
                 tempview_no := tempview_no +1;
                 tempview[tempview_no].X := d - i;
                 tempview[tempview_no].Y := c - j + k;
              end;
           end
           else
           begin
              tempview_no := tempview_no +1;
              setlength(tempview,tempview_no +4);
              tempview[tempview_no].X := d + i;
              tempview[tempview_no].Y := c + j;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := d + i;
              tempview[tempview_no].Y := c - j;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := d - i;
              tempview[tempview_no].Y := c + j;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := d - i;
              tempview[tempview_no].Y := c - j;
           end;
           last := j;
        end;
     end
     else if (a >= 1) and Fill then
     begin
//        last := round(sqrt((b * (a - ((d - Min(Xpos,Xpos2)) * (d - Min(Xpos,Xpos2))))) div a));
        for i:= (d - Min(Xpos,Xpos2)) downto 0 do
        begin
           j := round(sqrt((b * (a - (i * i))) div a));
           for k := (c - j) to (c + j) do
           begin
              tempview_no := tempview_no +1;
              setlength(tempview,tempview_no +2);
              tempview[tempview_no].X := d + i;
              tempview[tempview_no].Y := k;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := d - i;
              tempview[tempview_no].Y := k;
           end;
        end;
     end
     else
     begin
        tempview_no := tempview_no +1;
        setlength(tempview,tempview_no +1);
        tempview[tempview_no].X := Xpos;
        tempview[tempview_no].Y := Ypos;
     end;
  end
  else
  begin
     a := sqr(abs((Ypos - Ypos2) div 2));
     b := sqr(abs((Xpos - Xpos2) div 2));
     c := (Xpos + Xpos2) div 2;
     d := (Ypos + Ypos2) div 2;
     if (a >= 1) and not Fill then
     begin
        last := round(sqrt((b * (a - ((d - Min(Ypos,Ypos2)) * (d - Min(Ypos,Ypos2))))) div a));
        for i:= (d - Min(Ypos,Ypos2)) downto 0 do
        begin
           j := round(sqrt((b * (a - (i * i))) div a));
           if abs(j - last) > 1 then
           begin
              for k := abs(j - last) downto 0 do
              begin
                 tempview_no := tempview_no +1;
                 setlength(tempview,tempview_no +4);
                 tempview[tempview_no].X := c + j - k;
                 tempview[tempview_no].Y := d + i;
                 tempview_no := tempview_no +1;
                 tempview[tempview_no].X := c - j + k;
                 tempview[tempview_no].Y := d + i;
                 tempview_no := tempview_no +1;
                 tempview[tempview_no].X := c + j - k;
                 tempview[tempview_no].Y := d - i;
                 tempview_no := tempview_no +1;
                 tempview[tempview_no].X := c - j + k;
                 tempview[tempview_no].Y := d - i;
              end;
           end
           else
           begin
              tempview_no := tempview_no +1;
              setlength(tempview,tempview_no +4);
              tempview[tempview_no].X := c + j;
              tempview[tempview_no].Y := d + i;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := c - j;
              tempview[tempview_no].Y := d + i;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := c + j;
              tempview[tempview_no].Y := d - i;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := c - j;
              tempview[tempview_no].Y := d - i;
           end;
           last := j;
        end;
     end
     else if (a >= 1) and Fill then
     begin
//        last := round(sqrt((b * (a - ((d - Min(Ypos,Ypos2)) * (d - Min(Ypos,Ypos2))))) div a));
        for i:= (d - Min(Ypos,Ypos2)) downto 0 do
        begin
           j := round(sqrt((b * (a - (i * i))) div a));
           for k := (c - j) to (c + j) do
           begin
              tempview_no := tempview_no +1;
              setlength(tempview,tempview_no +2);
              tempview[tempview_no].X := k;
              tempview[tempview_no].Y := d + i;
              tempview_no := tempview_no +1;
              tempview[tempview_no].X := k;
              tempview[tempview_no].Y := d - i;
           end;
        end;
     end
     else
     begin
        tempview_no := tempview_no +1;
        setlength(tempview,tempview_no +1);
        tempview[tempview_no].X := Xpos;
        tempview[tempview_no].Y := Ypos;
     end;
  end;
end;


procedure AddColourToTempview(const SHP:TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
begin
   if (YPos < SHP.Header.Height) and (YPos >= 0) then
      if (XPos < SHP.Header.Width) and (XPos >= 0) then
         if (SHP.Data[Frame].FrameImage[XPos,YPos] <> 0) then
         begin
            inc(tempview_no);
            SetLength(Tempview,Tempview_No + 1);
            Tempview[Tempview_no].X := XPos;
            TempView[Tempview_no].Y := YPos;
            TempView[Tempview_no].colour := Palette[LoadPixel(List,Last,alg,RGB(GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) - (bias * (GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) div division)),GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) - (bias *(GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) div division)),GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) - (bias * (GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) div division))))];
            TempView[tempview_no].colour_used := true;
         end;
end;

procedure AddColourToSHP(var SHP:TSHP; var Palette: TPalette; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
begin
   if (YPos < SHP.Header.Height) and (YPos >= 0) then
      if (XPos < SHP.Header.Width) and (XPos >= 0) then
         if (SHP.Data[Frame].FrameImage[XPos,YPos] <> 0) then
         begin
            SHP.Data[Frame].FrameImage[XPos,YPos] := LoadPixel(List,Last,alg,RGB(GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) - (bias * (GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) div division)),GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) - (bias * (GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) div division)),GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) - (bias * (GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) div division))));
         end;
end;

procedure AddSnowColourToTempview(const SHP:TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
begin
   if (YPos < SHP.Header.Height) and (YPos >= 0) then
      if (XPos < SHP.Header.Width) and (XPos >= 0) then
         if (SHP.Data[Frame].FrameImage[XPos,YPos] <> 0) then
         begin
            inc(tempview_no);
            SetLength(Tempview,Tempview_No + 1);
            Tempview[Tempview_no].X := XPos;
            TempView[Tempview_no].Y := YPos;
            TempView[Tempview_no].colour := Palette[LoadPixel(List,Last,alg,RGB(GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) + (bias * ((255 - GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]])) div division)),GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) + (bias *((255 - GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]])) div division)),GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) + (bias * ((255 - GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]])) div division))))];
            TempView[tempview_no].colour_used := true;
         end;
end;

procedure AddSnowColourToSHP(var SHP:TSHP; const Palette: TPalette; Frame,Xpos,Ypos,alg:Integer; var List,Last:listed_colour; bias,division:byte);
begin
   if (YPos < SHP.Header.Height) and (YPos >= 0) then
      if (XPos < SHP.Header.Width) and (XPos >= 0) then
         if (SHP.Data[Frame].FrameImage[XPos,YPos] <> 0) then
         begin
            SHP.Data[Frame].FrameImage[XPos,YPos] := LoadPixel(List,Last,alg,RGB(GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) + (bias * ((255 - GetRValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]])) div division)),GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) + (bias * ((255 - GetGValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]])) div division)),GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]]) + (bias * ((255 - GetBValue(Palette[SHP.Data[Frame].FrameImage[XPos,YPos]])) div division))));
         end;
end;

procedure Crash(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
  ColourMap : TFrameImage;
begin
  tempview_no := 0;
  setlength(tempview,0); // Clean

  // Set List and Last
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);
  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-1,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+1,alg,List,Last,1,3);

  // middle row (XPos)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-1,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos,alg,List,Last,3,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+1,alg,List,Last,2,3);

  // final row (XPos + 1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-1,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+1,alg,List,Last,1,3);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure Crash(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
//  l : text;  // Debug system (I had several problems to implement this tool)
begin
//  AssignFile(l,'e:\test.txt');
//  Rewrite(l);
  // Set List and Last
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);

  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-1)
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-1,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+1,alg,List,Last,1,3);

  // middle row (XPos)
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-1,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos,alg,List,Last,3,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+1,alg,List,Last,2,3);

  // final row (XPos + 1)
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-1,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+1,alg,List,Last,1,3);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure CrashLight(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  tempview_no := 0;
  setlength(tempview,0); // Clean

  // Set List and Last
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);
  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+1,alg,List,Last,1,6);

  // middle row (XPos)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+1,alg,List,Last,1,4);

  // final row (XPos + 1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+1,alg,List,Last,1,6);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure CrashLight(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);

  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-1)
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-1,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+1,alg,List,Last,1,6);

  // middle row (XPos)
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+1,alg,List,Last,1,4);

  // final row (XPos + 1)
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-1,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+1,alg,List,Last,1,6);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure CrashBig(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  tempview_no := 0;
  setlength(tempview,0); // Clean

  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);
  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-3)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos-2,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos-1,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos+1,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos+2,alg,List,Last,1,10);

  // Now, grab the colours -- Second row (XPos-2)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-3,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-2,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-1,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+1,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+2,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+3,alg,List,Last,1,10);

  // Now, grab the colours -- Third row (XPos-1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-3,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-2,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-1,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+1,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+2,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+3,alg,List,Last,1,5);

  // middle row (XPos)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-3,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-2,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-1,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos,alg,List,Last,3,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+1,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+2,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+3,alg,List,Last,1,3);

  // fifth row (XPos + 1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-3,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-2,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-1,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos,alg,List,Last,2,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+1,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+2,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+3,alg,List,Last,1,5);

  // sixth row (XPos+2)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-3,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-2,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-1,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos,alg,List,Last,1,2);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+1,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+2,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+3,alg,List,Last,1,10);

  // Bout Time -- Final row (XPos+3)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos-2,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos-1,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos+1,alg,List,Last,1,5);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos+2,alg,List,Last,1,10);

  // Remove the trash:
  ClearColourList(List,Last);
  ClearBank(Start);
end;

procedure CrashBig(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);

  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-3)
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos-2,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos-1,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos+1,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos+2,alg,List,Last,1,10);

  // Second row (XPos-2)
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-3,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-2,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-1,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+1,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+2,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+3,alg,List,Last,1,10);

  // Third row (XPos-1)
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-3,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-2,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-1,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+1,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+2,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+3,alg,List,Last,1,5);

  // middle row (XPos)
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-3,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-2,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-1,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos,alg,List,Last,3,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+1,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+2,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+3,alg,List,Last,1,3);

  // Fifth row (XPos + 1)
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-3,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-2,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-1,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos,alg,List,Last,2,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+1,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+2,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+3,alg,List,Last,1,5);

  // Sixth row (XPos + 2)
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-3,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-2,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-1,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos,alg,List,Last,1,2);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+1,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+2,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+3,alg,List,Last,1,10);

  // Final row (XPos + 3)
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos-2,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos-1,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos+1,alg,List,Last,1,5);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos+2,alg,List,Last,1,10);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure CrashBigLight(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  tempview_no := 0;
  setlength(tempview,0); // Clean

  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);
  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-3)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos-2,alg,List,Last,1,20);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos-1,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos+1,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos+2,alg,List,Last,1,20);

  // Now, grab the colours -- Second row (XPos-2)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-3,alg,List,Last,1,20);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-2,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-1,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+1,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+2,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+3,alg,List,Last,1,20);

  // Now, grab the colours -- Third row (XPos-1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-3,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-2,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+2,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+3,alg,List,Last,1,10);

  // middle row (XPos)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-3,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos,alg,List,Last,1,3);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+3,alg,List,Last,1,8);

  // fifth row (XPos + 1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-3,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-2,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+2,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+3,alg,List,Last,1,10);

  // sixth row (XPos+2)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-3,alg,List,Last,1,20);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-2,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-1,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+1,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+2,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+3,alg,List,Last,1,20);

  // Bout Time -- Final row (XPos+3)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos-2,alg,List,Last,1,20);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos-1,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos+1,alg,List,Last,1,10);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos+2,alg,List,Last,1,20);

  // Remove the trash:
  ClearColourList(List,Last);
  ClearBank(Start);
end;

procedure CrashBigLight(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);

  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-3)
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos-2,alg,List,Last,1,20);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos-1,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos+1,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos+2,alg,List,Last,1,20);

  // Second row (XPos-2)
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-3,alg,List,Last,1,20);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-2,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-1,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+1,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+2,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+3,alg,List,Last,1,20);

  // Third row (XPos-1)
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-3,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-2,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-1,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+1,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+2,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+3,alg,List,Last,1,10);

  // middle row (XPos)
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-3,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-2,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos,alg,List,Last,1,3);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+1,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+2,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+3,alg,List,Last,1,8);

  // Fifth row (XPos + 1)
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-3,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-2,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-1,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+1,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+2,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+3,alg,List,Last,1,10);

  // Sixth row (XPos + 2)
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-3,alg,List,Last,1,20);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-2,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-1,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos,alg,List,Last,1,6);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+1,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+2,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+3,alg,List,Last,1,20);

  // Final row (XPos + 3)
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos-2,alg,List,Last,1,20);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos-1,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos,alg,List,Last,1,8);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos+1,alg,List,Last,1,10);
  AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos+2,alg,List,Last,1,20);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure Dirty(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  tempview_no := 0;
  setlength(tempview,0); // Clean

  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);
  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-3)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos-1,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos+1,alg,List,Last,1,8);

  // Now, grab the colours -- Second row (XPos-2)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-2,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+2,alg,List,Last,1,8);

  // Now, grab the colours -- Third row (XPos-1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-3,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+3,alg,List,Last,1,8);

  // middle row (XPos)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-3,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+3,alg,List,Last,1,8);

  // fifth row (XPos + 1)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-3,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+1,alg,List,Last,1,4);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+2,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+3,alg,List,Last,1,8);

  // sixth row (XPos+2)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-2,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+1,alg,List,Last,1,6);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+2,alg,List,Last,1,8);

  // Bout Time -- Final row (XPos+3)
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos-1,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos,alg,List,Last,1,8);
  AddColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos+1,alg,List,Last,1,8);

  // Remove the trash:
  ClearColourList(List,Last);
  ClearBank(Start);
end;

procedure Dirty(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
   List,Last: listed_colour;
   Start : colour_element;
begin
   // Set List and Last
   InitializeColourList(List,Last);
   GenerateColourList(Palette,List,Last,Palette[0],true,true,true);

   // Prepare Bank
   PrepareBank(Start,List,Last);

   // Now, grab the colours -- First row (XPos-3)
   AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos-1,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos+1,alg,List,Last,1,8);

   // Second row (XPos-2)
   AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-2,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-1,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+1,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+2,alg,List,Last,1,8);

   // Third row (XPos-1)
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-3,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-2,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-1,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+1,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+2,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+3,alg,List,Last,1,8);

   // middle row (XPos)
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-3,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-2,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+1,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+2,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos,Ypos+3,alg,List,Last,1,8);

   // Fifth row (XPos + 1)
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-3,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-2,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-1,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+1,alg,List,Last,1,4);
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+2,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+3,alg,List,Last,1,8);

   // Sixth row (XPos + 2)
   AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-2,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-1,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+1,alg,List,Last,1,6);
   AddColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+2,alg,List,Last,1,8);

   // Final row (XPos + 3)
   AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos-1,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos,alg,List,Last,1,8);
   AddColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos+1,alg,List,Last,1,8);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure Snow(const SHP: TSHP; var Palette: TPalette; var Tempview: TObjectData; var TempView_no : integer; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
   tempview_no := 0;
   setlength(tempview,0); // Clean

   // Set List and Last
   InitializeColourList(List,Last);
   GenerateColourList(Palette,List,Last,Palette[0],true,true,true);
   // Prepare Bank
   PrepareBank(Start,List,Last);

   // Now, grab the colours -- First row (XPos-3)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos-1,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-3,Ypos+1,alg,List,Last,1,8);

   // Now, grab the colours -- Second row (XPos-2)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-2,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos-1,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+1,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-2,Ypos+2,alg,List,Last,1,8);

   // Now, grab the colours -- Third row (XPos-1)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-3,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-2,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos-1,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+1,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+2,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos-1,Ypos+3,alg,List,Last,1,8);

   // middle row (XPos)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-3,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-2,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos-1,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+1,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+2,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos,Ypos+3,alg,List,Last,1,8);

   // fifth row (XPos + 1)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-3,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-2,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos-1,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+1,alg,List,Last,1,4);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+2,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+1,Ypos+3,alg,List,Last,1,8);

   // sixth row (XPos+2)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-2,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos-1,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+1,alg,List,Last,1,6);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+2,Ypos+2,alg,List,Last,1,8);

   // Bout Time -- Final row (XPos+3)
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos-1,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos,alg,List,Last,1,8);
   AddSnowColourToTempview(SHP,Palette,Tempview,TempView_no,Frame,Xpos+3,Ypos+1,alg,List,Last,1,8);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

procedure Snow(var SHP: TSHP; var Palette: TPalette; Xpos,Ypos:Integer; const Frame: integer; const Alg : integer); overload;
var
  List,Last: listed_colour;
  Start : colour_element;
begin
  // Set List and Last
  InitializeColourList(List,Last);
  GenerateColourList(Palette,List,Last,Palette[0],true,true,true);

  // Prepare Bank
  PrepareBank(Start,List,Last);

  // Now, grab the colours -- First row (XPos-3)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos-1,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-3,Ypos+1,alg,List,Last,1,8);

  // Second row (XPos-2)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-2,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos-1,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+1,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-2,Ypos+2,alg,List,Last,1,8);

  // Third row (XPos-1)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-3,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-2,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos-1,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+1,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+2,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos-1,Ypos+3,alg,List,Last,1,8);

  // middle row (XPos)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos-3,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos-2,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos-1,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos+1,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos+2,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos,Ypos+3,alg,List,Last,1,8);

  // Fifth row (XPos + 1)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-3,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-2,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos-1,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+1,alg,List,Last,1,3);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+2,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+1,Ypos+3,alg,List,Last,1,8);

  // Sixth row (XPos + 2)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-2,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos-1,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+1,alg,List,Last,1,6);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+2,Ypos+2,alg,List,Last,1,8);

  // Final row (XPos + 3)
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos-1,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos,alg,List,Last,1,8);
  AddSnowColourToSHP(SHP,Palette,Frame,Xpos+3,Ypos+1,alg,List,Last,1,8);

   // Remove the trash:
   ClearColourList(List,Last);
   ClearBank(Start);
end;

function OpositeColour(color : TColor) : tcolor;
var
r,g,b : byte;
begin
  r := 255 - GetRValue(color);
  g := 255 - GetGValue(color);
  b := 255 - GetBValue(color);
  result := RGB(r,g,b);
end;

// File: FormMain.pas
// Original Procedure Name: procedure TFrmMain.BrushToolDarkenLighten(Xc,Yc,Zc: Integer; V: TVoxelUnpacked; BrushMode: Integer; BrushView: EVoxelViewOrient);
// BrushToolDarkenLighten Code Taken From Voxel Section Editor and adapted to this program

// BrushTool modifyed by Stucuk from TVoxelSection.BrushToolDarkenLighten
procedure BrushTool(var SHP: TSHP; var TempView: TObjectData; var TempView_no: integer; Xc,Yc,BrushMode,Colour: Integer);
var
  Shape: Array[-5..5,-5..5] of 0..1;
  i,j,r1,r2: Integer;
begin
Randomize;
//SetLength(TempView,0);
//TempView_no := 0;

  for i:=-5 to 5 do
    for j:=-5 to 5 do
      Shape[i,j]:=0;
  Shape[0,0]:=1;
  if BrushMode>=1 then begin
    Shape[0,1]:=1; Shape[0,-1]:=1; Shape[1,0]:=1; Shape[-1,0]:=1;
  end;
  if BrushMode>=2 then begin
    Shape[1,1]:=1; Shape[1,-1]:=1; Shape[-1,-1]:=1; Shape[-1,1]:=1;
  end;
  if BrushMode>=3 then begin
    Shape[0,2]:=1; Shape[0,-2]:=1; Shape[2,0]:=1; Shape[-2,0]:=1;
  end;

  if BrushMode =4 then begin
  for i:=-5 to 5 do
    for j:=-5 to 5 do
      Shape[i,j]:=0;

  for i:=1 to 4 do
  begin
  r1 := random(7)-3; r2 := random(7)-3;
  Shape[r1,r2]:=1;
  end;
  end;
  //Brush completed, now actually use it!
  //for every pixel of the brush, check if we need to draw it (Shape),
  for i:=-5 to 5 do begin
    for j:=-5 to 5 do begin
      if Shape[i,j]=1 then begin
      inc(TempView_no);
       SetLength(TempView,TempView_no+1);
       TempView[TempView_no].X := Max(Min(Xc+i,SHP.Header.Width-1),0);
       TempView[TempView_no].Y := Max(Min(Yc+j,SHP.Header.Height-1),0);
      // SHP.Data[Current_Frame.Value].FrameImage[,] := Colour;
      end;
    end;
  end;
end;

function InImageBounds(x,y : integer; const SHP:TSHP) : boolean;
begin
result := true; // Assume its in the image

// Check minimum
if (x < 0) or (y < 0) then
result := false;

// Check Max
if (x > SHP.Header.Width-1) or (y > SHP.Header.Height-1) then
result := false;

end;

// File: FormMain.pas
// Original Procedure Name: procedure TFrmMain.Rectangle(Xpos,Ypos,Zpos,Xpos2,Ypos2,Zpos2:Integer; Fill: Boolean);

procedure Rectangle_dotted(const SHP: TSHP; var TempView: TObjectData; var TempView_no:integer; const SHPPalette:TPalette; Frame: Word; Xpos,Ypos,Xpos2,Ypos2:Integer);
var
   x,y,c: Integer;
begin
   // Reset Tempview
   tempview_no := 0;
   setlength(tempview,0);

   // Resets counter
   c := 0;

   // write top line
   for x := Max(Min(Xpos,Xpos2),0) to Min(SHP.Header.Width-1,Max(Xpos,Xpos2)) do
   begin
      inc(c);
      if (c <4) and (InImageBounds(x,Min(Ypos,Ypos2),SHP)) then
      begin
         tempview_no := tempview_no +1;
         setlength(tempview,tempview_no +1);
         tempview[tempview_no].X := x;
         tempview[tempview_no].Y := Min(Ypos,Ypos2);
         tempview[tempview_no].colour_used := true;
         tempview[tempview_no].colour := OpositeColour(SHPPalette[SHP.Data[Frame].FrameImage[x,Min(Ypos,Ypos2)]]);
      end
      else
         c := 0;
   end;

   c := 0;
   // write bottom line
   for x := Max(Min(Xpos,Xpos2),0) to Min(SHP.Header.Width-1,Max(Xpos,Xpos2)) do
   begin
      inc(c);
      if (c <4) and (InImageBounds(x,Max(Ypos,Ypos2),SHP)) then
      begin
         tempview_no := tempview_no +1;
         setlength(tempview,tempview_no +1);
         tempview[tempview_no].X := x;
         tempview[tempview_no].Y := Max(Ypos,Ypos2);
         tempview[tempview_no].colour_used := true;
         tempview[tempview_no].colour := OpositeColour(SHPPalette[SHP.Data[Frame].FrameImage[x,Max(Ypos,Ypos2)]]);
      end
      else
         c := 0;
   end;

   c := 0;
   // write left line
   for y := Max(Min(Ypos,Ypos2),0) to Min(SHP.Header.Height-1,Max(Ypos,Ypos2)) do
   begin
      inc(c);
      if (c <4) and (InImageBounds(Min(Xpos,Xpos2),y,SHP)) then
      begin
         tempview_no := tempview_no +1;
         setlength(tempview,tempview_no +1);
         tempview[tempview_no].X := Min(Xpos,Xpos2);
         tempview[tempview_no].Y := y;
         tempview[tempview_no].colour_used := true;
         tempview[tempview_no].colour := OpositeColour(SHPPalette[SHP.Data[Frame].FrameImage[Min(Xpos,Xpos2),y]]);
      end
      else
         c := 0;
   end;

   c := 0;
   // write right line
   for y := Max(Min(Ypos,Ypos2),0) to Min(SHP.Header.Height-1,Max(Ypos,Ypos2)) do
   begin
      inc(c);
      if (c < 4) and (InImageBounds(Max(Xpos,Xpos2),y,SHP)) then
      begin
         tempview_no := tempview_no +1;
         setlength(tempview,tempview_no +1);
         tempview[tempview_no].X := Max(Xpos,Xpos2);
         tempview[tempview_no].Y := y;
         tempview[tempview_no].colour_used := true;
         tempview[tempview_no].colour := OpositeColour(SHPPalette[SHP.Data[Frame].FrameImage[Max(Xpos,Xpos2),y]]);
      end
      else
         c := 0;
   end;
end;

function darkenlightenv(Darken:boolean; Current_Value,Value : byte) : byte;
var temp : word;
begin

if darken then
temp := Current_Value - Value
else
temp := Current_Value + Value;

if temp < 1 then
temp := temp + 255;

if temp > 255 then
temp := temp - 255;

Result := temp;

end;

// File: FormMain.pas
// Original Procedure Name: procedure TFrmMain.BrushToolDarkenLighten(Xc,Yc,Zc: Integer; V: TVoxelUnpacked; BrushMode: Integer; BrushView: EVoxelViewOrient);
// BrushToolDarkenLighten Code Taken From Voxel Section Editor and adapted to this program

// BrushToolDarkenLighten modified by Stucuk from TVoxelSection.BrushTool
procedure BrushToolDarkenLighten(var SHP:TSHP; var TempView: TObjectData; var TempView_no: integer; Frame: Word; Xc,Yc: Integer; BrushMode: Integer); overload;
var
   Shape: Array[-5..5,-5..5] of 0..1;
   i,j,r1,r2: Integer;
   t : byte;
begin
   Randomize;
   for i:=-5 to 5 do
      for j:=-5 to 5 do
         Shape[i,j]:=0;
   Shape[0,0]:=1;
   if BrushMode>=1 then
   begin
      Shape[0,1]:=1; Shape[0,-1]:=1; Shape[1,0]:=1; Shape[-1,0]:=1;
   end;
   if BrushMode>=2 then
   begin
      Shape[1,1]:=1; Shape[1,-1]:=1; Shape[-1,-1]:=1; Shape[-1,1]:=1;
   end;
   if BrushMode>=3 then
   begin
      Shape[0,2]:=1; Shape[0,-2]:=1; Shape[2,0]:=1; Shape[-2,0]:=1;
   end;

   if BrushMode =4 then
   begin
      for i:=-5 to 5 do
         for j:=-5 to 5 do
            Shape[i,j]:=0;

      for i:=1 to 4 do
      begin
         r1 := random(7)-3; r2 := random(7)-3;
         Shape[r1,r2]:=1;
      end;
   end;
    //Brush completed, now actually use it!
   //for every pixel of the brush, check if we need to draw it (Shape),
   for i:=-5 to 5 do
   begin
      for j:=-5 to 5 do
      begin
         if Shape[i,j]=1 then
         begin
            inc(TempView_no);
            SetLength(TempView,TempView_no+1);
            TempView[TempView_no].X := Max(Min(Xc+i,SHP.Header.Width-1),0);
            TempView[TempView_no].Y := Max(Min(Yc+j,SHP.Header.Height-1),0);
            t := SHP.Data[Frame].FrameImage[Max(Min(Xc+i,SHP.Header.Width-1),0),Max(Min(Yc+j,SHP.Header.Height-1),0)];
            TempView[TempView_no].colour := t;
            TempView[tempview_no].colour_used := true;
            SHP.Data[Frame].FrameImage[Max(Min(Xc+i,SHP.Header.Width-1),0),Max(Min(Yc+j,SHP.Header.Height-1),0)] := darkenlightenv(FrmMain.DarkenLighten_B,t,FrmMain.DarkenLighten_N);
         end;
      end;
   end;
end;

procedure BrushToolDarkenLighten(var SHP:TSHP; Frame: Word; Xc,Yc: Integer; BrushMode: Integer); overload;
var
  Shape: Array[-5..5,-5..5] of 0..1;
  i,j,r1,r2: Integer;
  t : byte;
begin
   Randomize;
   for i:=-5 to 5 do
      for j:=-5 to 5 do
         Shape[i,j]:=0;
   Shape[0,0]:=1;
   if BrushMode>=1 then
   begin
      Shape[0,1]:=1; Shape[0,-1]:=1; Shape[1,0]:=1; Shape[-1,0]:=1;
   end;
   if BrushMode>=2 then
   begin
      Shape[1,1]:=1; Shape[1,-1]:=1; Shape[-1,-1]:=1; Shape[-1,1]:=1;
   end;
   if BrushMode>=3 then
   begin
      Shape[0,2]:=1; Shape[0,-2]:=1; Shape[2,0]:=1; Shape[-2,0]:=1;
   end;

   if BrushMode =4 then
   begin
      for i:=-5 to 5 do
         for j:=-5 to 5 do
            Shape[i,j]:=0;

      for i:=1 to 4 do
      begin
         r1 := random(7)-3; r2 := random(7)-3;
         Shape[r1,r2]:=1;
      end;
   end;
    //Brush completed, now actually use it!
   //for every pixel of the brush, check if we need to draw it (Shape),
   for i:=-5 to 5 do
   begin
      for j:=-5 to 5 do
      begin
         if Shape[i,j]=1 then
         begin
            t := SHP.Data[Frame].FrameImage[Max(Min(Xc+i,SHP.Header.Width-1),0),Max(Min(Yc+j,SHP.Header.Height-1),0)];
            SHP.Data[Frame].FrameImage[Max(Min(Xc+i,SHP.Header.Width-1),0),Max(Min(Yc+j,SHP.Header.Height-1),0)] := darkenlightenv(FrmMain.DarkenLighten_B,t,FrmMain.DarkenLighten_N);
         end;
      end;
   end;
end;

end.
