unit SHP_Canvas;
interface

uses Windows, Classes, Graphics, shp_file;

// Canvas Resizing Procedures (FrameImage)
Procedure CanvasResize(var Frame:TFrameImage; Width,Height,XBegin,YBegin,XEnd,YEnd:Integer; PaletteColour:byte); overload;
Procedure CanvasPullHorizontal(var Frame:TFrameImage; MaxHeight,Position:Integer); overload;
Procedure CanvasPullVertical(var Frame:TFrameImage; MaxWidth,Position:Integer); overload;
Procedure CanvasPushHorizontal(var Frame:TFrameImage; MaxWidth,MaxHeight,Position:Integer); overload;
Procedure CanvasPushVertical(var Frame:TFrameImage; MaxWidth,MaxHeight,Position:Integer); overload;
Procedure CanvasCreateEmptyHorizontalQueue(var Frame:TFrameImage; MaxWidth,Position:Integer; PaletteColour:Byte);
Procedure CanvasCreateEmptyVerticalQueue(var Frame:TFrameImage; MaxHeight,Position:Integer; PaletteColour:Byte);

// Canvas Resizing Procedures (Bitmap)
Procedure CanvasResize(var Bitmap:TBitmap; Width,Height,XBegin,YBegin,XEnd,YEnd:Integer); overload;
Procedure CanvasPullHorizontal(var Bitmap:TBitmap; MaxHeight,Position:Integer); overload;
Procedure CanvasPullVertical(var Bitmap:TBitmap; MaxWidth,Position:Integer); overload;
Procedure CanvasPushHorizontal(var Bitmap:TBitmap; MaxWidth,MaxHeight,Position:Integer); overload;
Procedure CanvasPushVertical(var Bitmap:TBitmap; MaxWidth,MaxHeight,Position:Integer); overload;

implementation

// Canvas Procedures (FrameImage)
Procedure CanvasResize(var Frame:TFrameImage; Width,Height,XBegin,YBegin,XEnd,YEnd:Integer; PaletteColour:byte);
begin
// The objective is to make XBegin, YBegin, XEnd and YEnd become 0.

// They are the ammount of canvas to be added or subtracted from
// the beggining and/or the end in horizontal and/or vertical positions.

   dec(Width);
   dec(Height);

   While XBegin < 0 do
   begin
      inc(Width);
      SetLength(Frame,Width+1,Height+1);
      CanvasPushHorizontal(Frame,Width,Height,1);
      CanvasCreateEmptyVerticalQueue(Frame,Height,0,PaletteColour);
      inc(XBegin);
   end;
   While (XBegin > 0) do
   begin
      dec(Width);
      CanvasPullHorizontal(Frame,Height,Width);
      SetLength(Frame,Width+1,Height+1);
      dec(XBegin);
   end;
   While (XEnd > 0) do
   begin
      inc(Width);
      SetLength(Frame,Width+1,Height+1);
      CanvasCreateEmptyVerticalQueue(Frame,Height,Width,PaletteColour);
      dec(xend);
   end;
   While (XEnd < 0) do
   begin
      dec(Width);
      SetLength(Frame,Width+1,Height+1);
      inc(xend);
   end;
   While (YBegin < 0) do
   begin
      inc(Height);
      SetLength(Frame,Width+1,Height+1);
      CanvasPushVertical(Frame,Width,Height,0);
      CanvasCreateEmptyHorizontalQueue(Frame,Width,0,PaletteColour);
      inc(ybegin);
   end;
   While (YBegin > 0) do
   begin
      CanvasPullVertical(Frame,Width,Height);
      dec(Height);
      SetLength(Frame,Width+1,Height+1);
      dec(ybegin);
   end;
   While (YEnd > 0) do
   begin
      inc(Height);
      SetLength(Frame,Width+1,Height+1);
      CanvasCreateEmptyHorizontalQueue(Frame,Width,Height,PaletteColour);
      dec(yend);
   end;
   While (YEnd < 0) do
   begin
      dec(Height);
      SetLength(Frame,Width+1,Height+1);
      inc(yend);
   end;
end;

// The four procedures below works in a recursive way.
Procedure CanvasPullHorizontal(var Frame:TFrameImage; MaxHeight,Position:Integer);
var
   y:integer;
begin
   // This works in a simple way:

   // If the position is -1 it does nothing
   // Otherwise, it copies the following position into the current one
   if Position >= 0 then
   begin
      CanvasPullHorizontal(Frame,MaxHeight,Position-1);
      // copy previous position to current one
      for y:= 0 to MaxHeight do
         Frame[position,y] := Frame[position+1,y];
   end;
end;

Procedure CanvasPushHorizontal(var Frame:TFrameImage; MaxWidth,MaxHeight,Position:Integer);
var
   y:integer;
begin
   // This works in a simple way:

   // If the position is bigger than the max width, it does nothing
   // Otherwise, it copies the previous position into the current one
   if Position <= MaxWidth then
   begin
      CanvasPushHorizontal(Frame,MaxWidth,MaxHeight,Position+1);
      // copy previous position to current one
      for y:= 0 to MaxHeight do
         Frame[position,y] := Frame[position-1,y];
   end;
end;

Procedure CanvasPullVertical(var Frame:TFrameImage; MaxWidth,Position:Integer);
var
   x:integer;
begin
   // This works in a simple way:

   // If the position is -1 it does nothing
   // Otherwise, it copies the following position into the current one
   if Position >= 0 then
   begin
      CanvasPullVertical(Frame,MaxWidth,Position-1);
      // copy previous position to current one
      for x:= 0 to MaxWidth do
         Frame[x,position] := Frame[x,position+1];
   end;
end;

Procedure CanvasPushVertical(var Frame:TFrameImage; MaxWidth,MaxHeight,Position:Integer);
var
   x:integer;
begin
   // This works in a simple way:

   // If the position is bigger than the max height, it does nothing
   // Otherwise, it copies the previous position into the current one
   if Position <= MaxHeight then
   begin
      CanvasPushVertical(Frame,MaxWidth,MaxHeight,Position+1);
      // copy previous position to current one
      for x:= 0 to MaxWidth do
         Frame[x,position] := Frame[x,position-1];
   end;
end;

// Create empty queues, very easy to understand
Procedure CanvasCreateEmptyHorizontalQueue(var Frame:TFrameImage; MaxWidth,Position:Integer; PaletteColour:Byte);
var
   x:integer;
begin
   for x := 0 to MaxWidth do
      Frame[x,position] := PaletteColour;

end;

Procedure CanvasCreateEmptyVerticalQueue(var Frame:TFrameImage; MaxHeight,Position:Integer; PaletteColour:Byte);
var
   y:integer;
begin
   for y := 0 to MaxHeight do
      Frame[position,y] := PaletteColour;

end;


// Canvas Procedures (Bitmap)
Procedure CanvasResize(var Bitmap:TBitmap; Width,Height,XBegin,YBegin,XEnd,YEnd:Integer); overload;
begin
// The objective is to make XBegin, YBegin, XEnd and YEnd become 0.

// They are the ammount of canvas to be added or subtracted from
// the beggining and/or the end in horizontal and/or vertical positions.

   dec(Width);
   dec(Height);


   While XBegin < 0 do
   begin
      Bitmap.Width := Bitmap.Width + 1;
      inc(Width);
      Bitmap.Canvas.Brush.Color := Bitmap.Canvas.Pixels[0,0];
      CanvasPushHorizontal(Bitmap,Width,Height,1);
      Bitmap.Canvas.FillRect(Rect(0,0,0,Height));
      inc(XBegin);
   end;
   While (XBegin > 0) do
   begin
      CanvasPullHorizontal(Bitmap,Height,Width-1);
      Bitmap.Width := Bitmap.Width - 1;
      dec(Width);
      dec(XBegin);
   end;
   While (XEnd > 0) do
   begin
      Bitmap.Width := Bitmap.Width + 1;
      inc(width);
      Bitmap.Canvas.Brush.Color := Bitmap.Canvas.Pixels[0,0];
      Bitmap.Canvas.FillRect(Rect(Width,0,Width,Height));
      dec(xend);
   end;
   While (XEnd < 0) do
   begin
      Bitmap.Width := Bitmap.Width - 1;
      dec(width);
      inc(xend);
   end;
   While (YBegin < 0) do
   begin
      Bitmap.Height := Bitmap.Height + 1;
      inc(Height);
      CanvasPushVertical(Bitmap,Width,Height,1);
      Bitmap.Canvas.Brush.Color := Bitmap.Canvas.Pixels[0,0];
      Bitmap.Canvas.FillRect(Rect(0,0,Width,0));
      inc(ybegin);
   end;
   While (YBegin > 0) do
   begin
      CanvasPullVertical(Bitmap,Width,Height-1);
      Bitmap.Height := Bitmap.Height - 1;
      dec(height);
      dec(ybegin);
   end;
   While (YEnd > 0) do
   begin
      Bitmap.Height := Bitmap.Height + 1;
      inc(Height);
      Bitmap.Canvas.Brush.Color := Bitmap.Canvas.Pixels[0,0];
      Bitmap.Canvas.FillRect(Rect(0,Height,Width,Height));
      dec(yend);
   end;
   While (YEnd < 0) do
   begin
      Bitmap.Height := Bitmap.Height - 1;
      inc(yend);
   end;
end;

// The four procedures below works in a recursive way.
Procedure CanvasPullHorizontal(var Bitmap:TBitmap; MaxHeight,Position:Integer);
var
   y:integer;
begin
   // This works in a simple way:

   // If the position is -1 it does nothing
   // Otherwise, it copies the following position into the current one
   if Position >= 0 then
   begin
      CanvasPullHorizontal(Bitmap,MaxHeight,Position-1);
      // copy previous position to current one
      for y:= 0 to MaxHeight do
         Bitmap.Canvas.Pixels[position,y] := Bitmap.Canvas.Pixels[position+1,y];
   end;
end;

Procedure CanvasPushHorizontal(var Bitmap:TBitmap; MaxWidth,MaxHeight,Position:Integer);
var
   y:integer;
begin
   // This works in a simple way:

   // If the position is bigger than the max width, it does nothing
   // Otherwise, it copies the previous position into the current one
   if Position <= MaxWidth then
   begin
      CanvasPushHorizontal(Bitmap,MaxWidth,MaxHeight,Position+1);
      // copy previous position to current one
      for y:= 0 to MaxHeight do
         Bitmap.Canvas.Pixels[position,y] := Bitmap.Canvas.Pixels[position-1,y];
   end;
end;

Procedure CanvasPullVertical(var Bitmap:TBitmap; MaxWidth,Position:Integer);
var
   x:integer;
begin
   // This works in a simple way:

   // If the position is -1 it does nothing
   // Otherwise, it copies the following position into the current one
   if Position >= 0 then
   begin
      CanvasPullVertical(Bitmap,MaxWidth,Position-1);
      // copy previous position to current one
      for x:= 0 to MaxWidth do
         Bitmap.Canvas.Pixels[x,position] := Bitmap.Canvas.Pixels[x,position+1];
   end;
end;

Procedure CanvasPushVertical(var Bitmap:TBitmap; MaxWidth,MaxHeight,Position:Integer);
var
   x:integer;
begin
   // This works in a simple way:

   // If the position is bigger than the max height, it does nothing
   // Otherwise, it copies the previous position into the current one
   if Position <= MaxHeight then
   begin
      CanvasPushVertical(Bitmap,MaxWidth,MaxHeight,Position+1);
      // copy previous position to current one
      for x:= 0 to MaxWidth do
         Bitmap.Canvas.Pixels[x,position] := Bitmap.Canvas.Pixels[x,position-1];
   end;
end;

{

Function CanvasResize(Bitmap:TBitmap; XBegin,YBegin,XEnd,YEnd:Integer)TBitmap; overload;
var
X,Y : integer;
begin
Result := TBitmap.Create;
Result.Width := XEnd-XBegin;
Result.Height := YEnd-YBegin;

for x := 1 to Result.Width do
for y := 1 to Result.Height do
Result.Canvas.Pixels[x,y] := Bitmap.Canvas.Pixels[x+XBegin,y+YBegin];

end;

}


end.
