unit SHP_Frame;

interface

uses
     Windows, graphics, Classes, SHP_File, SHP_Shadows, Palette, Undo_Redo;

Procedure Insertblankframe(var SHP:TSHP;Const Frame : integer);
function Insertblankframe_shadow(var SHP:TSHP;Const Frame : integer): integer;
Procedure MoveSeveralFrameImagesUp(var SHP:TSHP; const Frame,Ammount : integer);
Procedure MoveFrameImagesUp(var SHP:TSHP; const Frame : integer);
Procedure ClearFrameImage(var SHP:TSHP;Const Frame : integer); overload;
Procedure ClearFrameImage(var UndoRedo: TUndoRedo; var SHP:TSHP;Const Frame : integer); overload;
Procedure MoveFrameImagesDown(var SHP:TSHP; const Frame : integer);
Procedure Deleteframe(var SHP:TSHP;Const Frame : integer);
Procedure Deleteframe_shadow(var SHP:TSHP;Const Frame : integer);

Function GetBMPOfFrameImage(const SHP:TSHP;Frame:integer;const Palette:TPalette):TBitmap;
Function GetBMPOfFrameImage_ShadowColour(const SHP:TSHP;Frame:integer;const Palette:TPalette; shadowcolour:byte):TBitmap;

implementation

Procedure ClearFrameImage(var SHP:TSHP;Const Frame : integer); overload;
var
x,y : integer;
begin

for x := 0 to SHP.Header.Width-1 do
for y := 0 to SHP.Header.Height-1 do
SHP.Data[Frame].FrameImage[x,y] := 0;
end;

Procedure ClearFrameImage(var UndoRedo: TUndoRedo; var SHP:TSHP;Const Frame : integer); overload;
var
x,y : integer;
begin

for x := 0 to SHP.Header.Width-1 do
for y := 0 to SHP.Header.Height-1 do
begin
AddToUndoMultiFrames(UndoRedo,Frame,x,y,SHP.Data[Frame].FrameImage[x,y]);
SHP.Data[Frame].FrameImage[x,y] := 0;
end;
end;

Procedure Insertblankframe(var SHP:TSHP;Const Frame : integer);
begin
MoveFrameImagesUp(SHP,Frame);
ClearFrameImage(SHP,Frame);
end;

function Insertblankframe_shadow(var SHP:TSHP;Const Frame : integer): integer;
var
owner,shadow : integer;
begin
if IsShadow(SHP,Frame) then
begin
shadow := Frame;
owner := GetShadowOposite(SHP,Frame);
end
else
begin
shadow := GetShadowFromOposite(SHP,Frame);
owner := Frame;
end;

MoveFrameImagesUp(SHP,owner);
ClearFrameImage(SHP,owner);

MoveFrameImagesUp(SHP,shadow+1);
ClearFrameImage(SHP,shadow+1);

result := owner;
end;

// 3.35: Imported from 3.4 to allow import on existing SHP.
Procedure MoveSeveralFrameImagesUp(var SHP:TSHP; const Frame,Ammount : integer);
var
   x : integer;
begin
   // Basic Check Up
   if Frame < 1 then exit;
   if Frame > (SHP.Header.NumImages+Ammount) then exit;

   // Set Up
   SHP.Header.NumImages := SHP.Header.NumImages+Ammount;
   SetLength(SHP.Data,SHP.Header.NumImages+1);
   for x := Ammount downto 0 do
   begin
      SetLength(SHP.Data[SHP.Header.NumImages-x].FrameImage,SHP.Header.Width,SHP.Header.Height);
   end;

   // Move stuff
   for x := SHP.Header.NumImages downto (Frame + Ammount) do
   begin
      SHP.Data[x].FrameImage := copy(SHP.Data[x - Ammount].FrameImage);
   end;
end;

Procedure MoveFrameImagesUp(var SHP:TSHP; const Frame : integer);
var
x,xx,yy,c : integer;
begin
if Frame <1 then
exit;

if Frame > SHP.Header.NumImages then
exit;

SHP.Header.NumImages := SHP.Header.NumImages+1;
SetLength(SHP.Data,SHP.Header.NumImages+1);
SetLength(SHP.Data[SHP.Header.NumImages].FrameImage,SHP.Header.Width,SHP.Header.Height);

c := 0;
for x := Frame to SHP.Header.NumImages-1 do
begin
for xx := 0 to SHP.Header.Width-1 do
for yy := 0 to SHP.Header.Height-1 do
SHP.Data[SHP.Header.NumImages-c].FrameImage[xx,yy] := SHP.Data[SHP.Header.NumImages-1-c].FrameImage[xx,yy];
c := c +1;
end;

end;

Procedure MoveFrameImagesDown(var SHP:TSHP; const Frame : integer);
var
x,xx,yy : integer;
begin
if Frame <1 then
exit;

if Frame > SHP.Header.NumImages then
exit;

for x := Frame to SHP.Header.NumImages-1 do
begin
for xx := 0 to SHP.Header.Width-1 do
for yy := 0 to SHP.Header.Height-1 do
SHP.Data[x].FrameImage[xx,yy] := SHP.Data[x+1].FrameImage[xx,yy];
end;

SHP.Header.NumImages := SHP.Header.NumImages-1;
SetLength(SHP.Data,SHP.Header.NumImages+1);


end;

Procedure Deleteframe(var SHP:TSHP;Const Frame : integer);
begin
MoveFrameImagesDown(SHP,Frame);
end;

Procedure Deleteframe_shadow(var SHP:TSHP;Const Frame : integer);
var
owner,shadow : integer;
begin
if IsShadow(SHP,Frame) then
begin
shadow := Frame;
owner := GetShadowOposite(SHP,Frame);
end
else
begin
shadow := GetShadowFromOposite(SHP,Frame);
owner := Frame;
end;

Deleteframe(SHP,owner);
Deleteframe(SHP,shadow-1);
end;

Function GetBMPOfFrameImage(const SHP:TSHP;Frame:integer;const Palette:TPalette):TBitmap;
var
BMP :TBitmap;
x,y : integer;
begin
BMP := TBitmap.Create;
//Result := BMP; // Assume Worst Case


     // Set image width n height
     BMP.Width := SHP.header.Width;
     BMP.Height := SHP.header.Height;

     // Clear the image of colour (fills with the transparent colour)
     BMP.Canvas.Brush.Color := palette[TRANSPARENT];
     BMP.Canvas.FillRect(rect(0,0,BMP.Width,BMP.Height));

     // Populate the image pixel by pixel
     for y := 0 to SHP.header.Height-1 do
     for x := 0 to SHP.header.Width-1 do
     begin

     if shp.data[Frame].frameimage[x,y] <> TRANSPARENT then // Stops it drawing transparent colours, stops shadows oposite form drawing over shadow
     BMP.Canvas.Pixels[x,y] := palette[shp.data[Frame].frameimage[x,y]];
     end;

Result := BMP;

end;

Function GetBMPOfFrameImage_ShadowColour(const SHP:TSHP;Frame:integer;const Palette:TPalette; shadowcolour:byte):TBitmap;
var
BMP :TBitmap;
x,y : integer;
begin
BMP := TBitmap.Create;


     // Set image width n height
     BMP.Width := SHP.header.Width;
     BMP.Height := SHP.header.Height;

     // Clear the image of colour (fills with the transparent colour)
     BMP.Canvas.Brush.Color := palette[0];
     BMP.Canvas.FillRect(rect(0,0,BMP.Width,BMP.Height));

     // Populate the image pixel by pixel
     for y := 0 to SHP.header.Height-1 do
     for x := 0 to SHP.header.Width-1 do
     begin

     if shp.data[Frame].frameimage[x,y] <> 0 then // Stops it drawing transparent colours, stops shadows oposite form drawing over shadow
     BMP.Canvas.Pixels[x,y] := palette[shadowcolour];
     end;

Result := BMP;
end;

end.
