unit SHP_Shadows;

interface

uses
    SHP_File;

Function IsShadow(SHP : TSHP; Frame:integer) : boolean;
function GetOposite(var SHP:TSHP;Const Frame : integer): integer;
Function GetShadowOposite(SHP:TSHP; Frame:integer) : integer;
Function GetShadowFromOposite(SHP:TSHP; Frame:integer) : integer;
Function HasShadows(SHP:TSHP) : boolean;

implementation

Function IsShadow(SHP : TSHP; Frame:integer) : boolean;
var
   shadow_start : integer;
begin
   result := false;
   // Shadows start half way through the file +1 frame
   shadow_start := (SHP.Header.NumImages div 2)+1;

   // Check to see if current frame is above or equal to the shadow start value
   if frame >= shadow_start then
      result := true;

   if (SHP.SHPType = stCameo) or (SHP.SHPGame = sgTD) or (SHP.SHPGame = sgRA1) then // Check if it is not a unit/building/animation.
      result := false; // Only Units/buildings/animations have shadows
end;

Function GetShadowOposite(SHP:TSHP; Frame:integer) : integer;
var
   shadow_start : integer;
begin
   // Shadows start half way through the file
   shadow_start := (SHP.Header.NumImages div 2);

if not IsShadow(SHP,Frame) then
   result := 0 // Error;
else
   result := Frame-shadow_start;
end;

Function GetShadowFromOposite(SHP:TSHP; Frame:integer) : integer;
var
shadow_start : integer;
begin
   // Shadows start half way through the file
   shadow_start := (SHP.Header.NumImages div 2);

   result := Frame+shadow_start;
end;

function GetOposite(var SHP:TSHP;Const Frame : integer): integer;
begin
   if IsShadow(SHP,Frame) then
      result := GetShadowOposite(SHP,Frame)
   else
      result := GetShadowFromOposite(SHP,Frame);
end;

Function HasShadows(SHP:TSHP) : boolean;
begin
   Result := True; // Assume True
   if (SHP.SHPType = stcameo) or (SHP.SHPType = sttem) or (SHP.SHPType = stsno) or (SHP.SHPType = stAnimation) then
      Result := False;
   if (SHP.SHPGame = sgTD) or (SHP.SHPGame = sgRA1) then
      Result := False;
end;

end.
