{ ****************************************************************** }
{                                                                    }
{   VCL component TSHPVisualPalette                                  }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\program files\component create\shpvisualpalette.cd }
{   on 5 Jan 2004 at 14:37                                           }
{                                                                    }
{   Copyright  2003 by Stuart Carey                                 }
{                                                                    }
{ ****************************************************************** }

unit SHPVisualPalette;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Extctrls,SHP_Engine_Image,Palette;

type
  TSHPVisualPalette = class(TPaintBox)
    private
      { Private fields of TSHPVisualPalette }
        { Storage for property ActiveColour }
        FActiveColour : byte;
        { Storage for property ActiveColour }
        FSColour : byte;
        { Storage for property ActiveColour }
        FMaxPalette: word;
        { Storage for property PaletteSet }
        FPaletteSet : Boolean;
        { Storage for property PaletteSet }
        FIsEditable : Boolean;

      { Private methods of TSHPVisualPalette }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        procedure WMSize(var Message: TWMSize); message WM_SIZE;

    protected
      { Protected fields of TSHPVisualPalette }

      { Protected methods of TSHPVisualPalette }
        procedure Click; override;
        procedure Loaded; override;
        procedure Paint; override;

    public
      { Public fields and properties of TSHPVisualPalette }

      { Public methods of TSHPVisualPalette }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TSHPVisualPalette }
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property ActiveColour : byte
             read FActiveColour write FActiveColour
             default 0;
        property PaletteSet : Boolean
             read FPaletteSet write FPaletteSet
             default False;
        property IsEditable : Boolean
             read FIsEditable write FIsEditable
             default False;
        property SColour : byte
             read FSColour write FSColour
             default 0;
        property MaxPalette : word
             read FMaxPalette write FMaxPalette
             default 0;
  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TSHPVisualPalette with Samples as its
       default page on the Delphi component palette }
     RegisterComponents('Samples', [TSHPVisualPalette]);
end;

{ Method to set variable and property values and create objects }
procedure TSHPVisualPalette.AutoInitialize;
begin
     FActiveColour := 0;
     FPaletteSet := False;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TSHPVisualPalette.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Override OnClick handler from TPaintBox }
procedure TSHPVisualPalette.Click;
begin
     { Code to execute before activating click
       behavior of component's parent class }

     { Activate click behavior of parent }
     inherited Click;

     { Code to execute after click behavior
       of parent }

end;

constructor TSHPVisualPalette.Create(AOwner: TComponent);
begin
     { Call the Create method of the parent class }
     inherited Create(AOwner);

     { AutoInitialize sets the initial values of variables and      }
     { properties; also, it creates objects for properties of       }
     { standard Delphi object types (e.g., TFont, TTimer,           }
     { TPicture) and for any variables marked as objects.           }
     { AutoInitialize method is generated by Component Create.      }
     AutoInitialize;

     { Code to perform other tasks when the component is created }
     Width := 160;
     Height := 262;
end;

destructor TSHPVisualPalette.Destroy;
begin
     { AutoDestroy, which is generated by Component Create, frees any   }
     { objects created by AutoInitialize.                               }
     AutoDestroy;

     { Here, free any other dynamic objects that the component methods  }
     { created but have not yet freed.  Also perform any other clean-up }
     { operations needed before the component is destroyed.             }

     { Last, free the component by calling the Destroy method of the    }
     { parent class.                                                    }
     inherited Destroy;
end;

procedure TSHPVisualPalette.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }
     Width := 160;
     Height := 262;
end;

procedure TSHPVisualPalette.Paint;
var colwidth, rowheight: Real;
    i, j, idx: Integer;
    r: TRect;
begin
     { Make this component look like its parent component by calling
       its parent's Paint method. }
     inherited Paint;

     colwidth := Width / 8;
     rowheight := Height / 32;
     idx := 0;
     Canvas.Brush.Color := clbtnface;
     Canvas.FillRect(rect(0,0,Width,Height));
     for i := 0 to 8 do begin
         r.Left := (i * Round(colwidth));

         r.Right := (r.Left + Round(colwidth));
         for j := 0 to 31 do begin
             r.Top := (j * Round(rowheight));
             r.Bottom := (r.Top + Round(rowheight));
             if idx < MaxPalette then
             with Canvas do begin

                  if isEditable then
                  Brush.Color := SHPPalette[idx]
                  else
                  Brush.Color := colourtogray(SHPPalette[idx]);

                  if (Idx = SColour) then begin // the current pen
                     Pen.Color := OpositeColour(SHPPalette[idx]);
                     //Pen.Mode := pmNotXOR;
                     Rectangle(r.Left,r.Top,r.Right,r.Bottom);
                     MoveTo(r.Left,r.Top);
                     LineTo(r.Right,r.Bottom);
                     MoveTo(r.Right,r.Top);
                     LineTo(r.Left,r.Bottom);
                  end else
                  FillRect(r);
             end;
             Inc(Idx);
         end;
     end;
     
     
end;

procedure TSHPVisualPalette.WMSize(var Message: TWMSize);
var
     W, H: Integer;
begin
     inherited;

     { Copy the new width and height of the component
       so we can use SetBounds to change both at once }
     W := 160;
     H := 262;

     { Code to check and adjust W and H }

     { Update the component size if we adjusted W or H }
        inherited SetBounds(Left, Top, 160, 262);

     Width := 160;
     Height := 262;

     { Code to update dimensions of any owned sub-components
       by reading their Height and Width properties and updating
       via their SetBounds methods }

     Message.Result := 0;
end;


end.
