/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.Syntax.Lexer;

import com.Ostermiller.Syntax.Lexer.Token;

public class PlainToken
extends Token {
    public static final int TEXT = 512;
    public static final int WHITE_SPACE = 3584;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;

    public PlainToken(int n2, String string, int n3, int n4, int n5) {
        this(n2, string, n3, n4, n5, -1);
    }

    public PlainToken(int n2, String string, int n3, int n4, int n5, int n6) {
        this.ID = n2;
        this.contents = new String(string);
        this.lineNumber = n3;
        this.charBegin = n4;
        this.charEnd = n5;
        this.state = n6;
    }

    public int getState() {
        return this.state;
    }

    public int getID() {
        return this.ID;
    }

    public String getContents() {
        return new String(this.contents);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharBegin() {
        return this.charBegin;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isText() {
        return this.ID >> 8 == 2;
    }

    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    public boolean isError() {
        return false;
    }

    public boolean isComment() {
        return false;
    }

    public String getDescription() {
        if (this.isText()) {
            return "text";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        return "unknown";
    }

    public String errorString() {
        return "";
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

