/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.drawing.BStoreContainer;
import jxl.biff.drawing.BlipStoreEntry;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Dgg;
import jxl.biff.drawing.DggContainer;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;
import jxl.biff.drawing.MsoDrawingGroupRecord;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.SplitMenuColors;
import jxl.read.biff.Record;
import jxl.write.biff.File;

public class DrawingGroup
implements EscherStream {
    private byte[] drawingData;
    private EscherContainer escherData;
    private BStoreContainer bstoreContainer;
    private boolean initialized;
    private ArrayList drawings;
    private int numBlips;
    private int numCharts;
    private int drawingGroupId;
    private Origin origin;
    private HashMap imageFiles;
    public static final Origin READ = new Origin();
    public static final Origin WRITE = new Origin();
    public static final Origin READ_WRITE = new Origin();

    public DrawingGroup(Origin o2) {
        this.origin = o2;
        this.initialized = o2 == WRITE;
        this.drawings = new ArrayList();
        this.imageFiles = new HashMap();
    }

    public void add(MsoDrawingGroupRecord mso) {
        this.addData(mso.getData());
    }

    public void add(Record cont) {
        this.addData(cont.getData());
    }

    private void addData(byte[] msodata) {
        if (this.drawingData == null) {
            this.drawingData = new byte[msodata.length];
            System.arraycopy(msodata, 0, this.drawingData, 0, msodata.length);
            return;
        }
        byte[] newdata = new byte[this.drawingData.length + msodata.length];
        System.arraycopy(this.drawingData, 0, newdata, 0, this.drawingData.length);
        System.arraycopy(msodata, 0, newdata, this.drawingData.length, msodata.length);
        this.drawingData = newdata;
    }

    final void addDrawing(Drawing d2) {
        this.drawings.add(d2);
    }

    public void add(Chart c2) {
        ++this.numCharts;
    }

    public void add(Drawing d2) {
        Drawing refImage;
        if (this.origin == READ) {
            this.origin = READ_WRITE;
            this.numBlips = this.getBStoreContainer().getNumBlips();
            Dgg dgg = (Dgg)this.escherData.getChildren()[0];
            this.drawingGroupId = dgg.getCluster((int)1).drawingGroupId - this.numBlips - 1;
        }
        if ((refImage = (Drawing)this.imageFiles.get(d2.getImageFile().getPath())) == null) {
            this.drawings.add(d2);
            d2.setDrawingGroup(this);
            d2.setObjectId(this.numBlips + 1, this.numBlips + 1);
            ++this.numBlips;
            this.imageFiles.put(d2.getImageFile().getPath(), d2);
        } else {
            refImage.setReferenceCount(refImage.getReferenceCount() + 1);
            d2.setDrawingGroup(this);
            d2.setObjectId(refImage.getObjectId(), refImage.getBlipId());
        }
    }

    public void remove(Drawing d2) {
        if (this.origin == READ) {
            this.origin = READ_WRITE;
            this.numBlips = this.getBStoreContainer().getNumBlips();
            Dgg dgg = (Dgg)this.escherData.getChildren()[0];
            this.drawingGroupId = dgg.getCluster((int)1).drawingGroupId - this.numBlips - 1;
        }
        EscherRecord[] children = this.getBStoreContainer().getChildren();
        BlipStoreEntry bse = (BlipStoreEntry)children[d2.getBlipId() - 1];
        bse.dereference();
        if (bse.getReferenceCount() == 0) {
            this.getBStoreContainer().remove(bse);
            Iterator i2 = this.drawings.iterator();
            while (i2.hasNext()) {
                Drawing drawing = (Drawing)i2.next();
                if (drawing.getBlipId() <= d2.getBlipId()) continue;
                drawing.setObjectId(drawing.getObjectId(), drawing.getBlipId() - 1);
            }
            --this.numBlips;
        }
    }

    private void initialize() {
        EscherRecordData er = new EscherRecordData(this, 0);
        Assert.verify(er.isContainer());
        this.escherData = new EscherContainer(er);
        Assert.verify(this.escherData.getLength() == this.drawingData.length);
        Assert.verify(this.escherData.getType() == EscherRecordType.DGG_CONTAINER);
        this.initialized = true;
    }

    private BStoreContainer getBStoreContainer() {
        if (this.bstoreContainer == null) {
            EscherRecord[] children;
            if (!this.initialized) {
                this.initialize();
            }
            Assert.verify((children = this.escherData.getChildren())[1].getType() == EscherRecordType.BSTORE_CONTAINER);
            this.bstoreContainer = (BStoreContainer)children[1];
        }
        return this.bstoreContainer;
    }

    public byte[] getData() {
        return this.drawingData;
    }

    public void write(File outputFile) throws IOException {
        DggContainer dggContainer;
        if (this.origin == WRITE) {
            dggContainer = new DggContainer();
            Dgg dgg = new Dgg(this.numBlips + this.numCharts + 1, this.numBlips);
            dgg.addCluster(1, 0);
            dgg.addCluster(this.numBlips + 1, 0);
            dggContainer.add(dgg);
            BStoreContainer bstoreContainer = new BStoreContainer(this.drawings.size());
            Iterator i2 = this.drawings.iterator();
            while (i2.hasNext()) {
                Drawing d2 = (Drawing)i2.next();
                BlipStoreEntry bse = new BlipStoreEntry(d2);
                bstoreContainer.add(bse);
            }
            dggContainer.add(bstoreContainer);
            Opt opt = new Opt();
            dggContainer.add(opt);
            SplitMenuColors splitMenuColors = new SplitMenuColors();
            dggContainer.add(splitMenuColors);
            this.drawingData = dggContainer.getData();
        } else if (this.origin == READ_WRITE) {
            dggContainer = new DggContainer();
            Dgg dgg = new Dgg(this.numBlips + this.numCharts + 1, this.numBlips);
            dgg.addCluster(1, 0);
            dgg.addCluster(this.drawingGroupId + this.numBlips + 1, 0);
            dggContainer.add(dgg);
            BStoreContainer bstoreContainer = new BStoreContainer(this.numBlips);
            BStoreContainer readBStoreContainer = this.getBStoreContainer();
            EscherRecord[] children = readBStoreContainer.getChildren();
            for (int i3 = 0; i3 < children.length; ++i3) {
                BlipStoreEntry bse = (BlipStoreEntry)children[i3];
                bstoreContainer.add(bse);
            }
            Iterator i4 = this.drawings.iterator();
            while (i4.hasNext()) {
                Drawing d3 = (Drawing)i4.next();
                if (d3.getOrigin() == Drawing.READ) continue;
                BlipStoreEntry bse = new BlipStoreEntry(d3);
                bstoreContainer.add(bse);
            }
            dggContainer.add(bstoreContainer);
            Opt opt = new Opt();
            opt.addProperty(191, false, false, 524296);
            opt.addProperty(385, false, false, 0x8000009);
            opt.addProperty(448, false, false, 0x8000040);
            dggContainer.add(opt);
            SplitMenuColors splitMenuColors = new SplitMenuColors();
            dggContainer.add(splitMenuColors);
            this.drawingData = dggContainer.getData();
        }
        MsoDrawingGroupRecord msodg = new MsoDrawingGroupRecord(this.drawingData);
        outputFile.write(msodg);
    }

    final int getNumberOfBlips() {
        return this.numBlips;
    }

    private static class Origin {
        private Origin() {
        }
    }
}

