/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;

public final class CompoundFile
extends BaseCompoundFile {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$CompoundFile == null ? (class$jxl$read$biff$CompoundFile = CompoundFile.class$("jxl.read.biff.CompoundFile")) : class$jxl$read$biff$CompoundFile);
    private byte[] data;
    private int numBigBlockDepotBlocks;
    private int sbdStartBlock;
    private int rootStartBlock;
    private int extensionBlock;
    private int numExtensionBlocks;
    private byte[] rootEntry;
    private int[] bigBlockChain;
    private int[] smallBlockChain;
    private int[] bigBlockDepotBlocks;
    private ArrayList propertySets;
    private WorkbookSettings settings;
    static /* synthetic */ Class class$jxl$read$biff$CompoundFile;

    public CompoundFile(byte[] d2, WorkbookSettings ws) throws BiffException {
        this.data = d2;
        this.settings = ws;
        for (int i2 = 0; i2 < IDENTIFIER.length; ++i2) {
            if (this.data[i2] == IDENTIFIER[i2]) continue;
            throw new BiffException(BiffException.unrecognizedOLEFile);
        }
        this.propertySets = new ArrayList();
        this.numBigBlockDepotBlocks = IntegerHelper.getInt(this.data[44], this.data[45], this.data[46], this.data[47]);
        this.sbdStartBlock = IntegerHelper.getInt(this.data[60], this.data[61], this.data[62], this.data[63]);
        this.rootStartBlock = IntegerHelper.getInt(this.data[48], this.data[49], this.data[50], this.data[51]);
        this.extensionBlock = IntegerHelper.getInt(this.data[68], this.data[69], this.data[70], this.data[71]);
        this.numExtensionBlocks = IntegerHelper.getInt(this.data[72], this.data[73], this.data[74], this.data[75]);
        this.bigBlockDepotBlocks = new int[this.numBigBlockDepotBlocks];
        int pos = 76;
        int bbdBlocks = this.numBigBlockDepotBlocks;
        if (this.numExtensionBlocks != 0) {
            bbdBlocks = 109;
        }
        for (int i3 = 0; i3 < bbdBlocks; ++i3) {
            this.bigBlockDepotBlocks[i3] = IntegerHelper.getInt(d2[pos], d2[pos + 1], d2[pos + 2], d2[pos + 3]);
            pos += 4;
        }
        for (int j2 = 0; j2 < this.numExtensionBlocks; ++j2) {
            pos = (this.extensionBlock + 1) * 512;
            int blocksToRead = Math.min(this.numBigBlockDepotBlocks - bbdBlocks, 127);
            for (int i4 = bbdBlocks; i4 < bbdBlocks + blocksToRead; ++i4) {
                this.bigBlockDepotBlocks[i4] = IntegerHelper.getInt(d2[pos], d2[pos + 1], d2[pos + 2], d2[pos + 3]);
                pos += 4;
            }
            if ((bbdBlocks += blocksToRead) >= this.numBigBlockDepotBlocks) continue;
            this.extensionBlock = IntegerHelper.getInt(d2[pos], d2[pos + 1], d2[pos + 2], d2[pos + 3]);
        }
        this.readBigBlockDepot();
        this.readSmallBlockDepot();
        this.rootEntry = this.readData(this.rootStartBlock);
        this.readPropertySets();
    }

    private void readBigBlockDepot() {
        int pos = 0;
        int index = 0;
        this.bigBlockChain = new int[this.numBigBlockDepotBlocks * 512 / 4];
        for (int i2 = 0; i2 < this.numBigBlockDepotBlocks; ++i2) {
            pos = (this.bigBlockDepotBlocks[i2] + 1) * 512;
            for (int j2 = 0; j2 < 128; ++j2) {
                this.bigBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
            }
        }
    }

    private void readSmallBlockDepot() {
        int pos = 0;
        int index = 0;
        int sbdBlock = this.sbdStartBlock;
        this.smallBlockChain = new int[0];
        while (sbdBlock != -2) {
            int[] oldChain = this.smallBlockChain;
            this.smallBlockChain = new int[this.smallBlockChain.length + 128];
            System.arraycopy(oldChain, 0, this.smallBlockChain, 0, oldChain.length);
            pos = (sbdBlock + 1) * 512;
            for (int j2 = 0; j2 < 128; ++j2) {
                this.smallBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
            }
            sbdBlock = this.bigBlockChain[sbdBlock];
        }
    }

    private void readPropertySets() {
        byte[] d2 = null;
        for (int offset = 0; offset < this.rootEntry.length; offset += 128) {
            d2 = new byte[128];
            System.arraycopy(this.rootEntry, offset, d2, 0, d2.length);
            BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage(d2);
            this.propertySets.add(ps);
        }
    }

    public byte[] getStream(String streamName) throws BiffException {
        BaseCompoundFile.PropertyStorage ps = this.getPropertyStorage(streamName);
        if (ps.size >= 4096 || streamName.equalsIgnoreCase("root entry")) {
            return this.getBigBlockStream(ps);
        }
        return this.getSmallBlockStream(ps);
    }

    private BaseCompoundFile.PropertyStorage getPropertyStorage(String name) throws BiffException {
        Iterator i2 = this.propertySets.iterator();
        boolean found = false;
        BaseCompoundFile.PropertyStorage ps = null;
        while (!found && i2.hasNext()) {
            ps = (BaseCompoundFile.PropertyStorage)i2.next();
            if (!ps.name.equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            throw new BiffException(BiffException.streamNotFound);
        }
        return ps;
    }

    private byte[] getBigBlockStream(BaseCompoundFile.PropertyStorage ps) {
        int count;
        int numBlocks = ps.size / 512;
        if (ps.size % 512 != 0) {
            ++numBlocks;
        }
        byte[] streamData = new byte[numBlocks * 512];
        int block = ps.startBlock;
        int pos = 0;
        for (count = 0; block != -2 && count < numBlocks; ++count) {
            pos = (block + 1) * 512;
            System.arraycopy(this.data, pos, streamData, count * 512, 512);
            block = this.bigBlockChain[block];
        }
        if (block != -2 && count == numBlocks) {
            logger.warn("Property storage size inconsistent with block chain.");
        }
        return streamData;
    }

    private byte[] getSmallBlockStream(BaseCompoundFile.PropertyStorage ps) throws BiffException {
        BaseCompoundFile.PropertyStorage rootps = null;
        try {
            rootps = this.getPropertyStorage("root entry");
        }
        catch (BiffException e2) {
            rootps = (BaseCompoundFile.PropertyStorage)this.propertySets.get(0);
        }
        byte[] rootdata = this.readData(rootps.startBlock);
        byte[] sbdata = new byte[]{};
        int block = ps.startBlock;
        boolean count = false;
        int pos = 0;
        while (block != -2) {
            byte[] olddata = sbdata;
            sbdata = new byte[olddata.length + 64];
            System.arraycopy(olddata, 0, sbdata, 0, olddata.length);
            pos = block * 64;
            System.arraycopy(rootdata, pos, sbdata, olddata.length, 64);
            block = this.smallBlockChain[block];
        }
        return sbdata;
    }

    private byte[] readData(int bl) {
        int block = bl;
        int pos = 0;
        byte[] entry = new byte[]{};
        while (block != -2) {
            byte[] oldEntry = entry;
            entry = new byte[oldEntry.length + 512];
            System.arraycopy(oldEntry, 0, entry, 0, oldEntry.length);
            pos = (block + 1) * 512;
            System.arraycopy(this.data, pos, entry, oldEntry.length, 512);
            block = this.bigBlockChain[block];
        }
        return entry;
    }

    public String[] getPropertySetNames() {
        String[] sets = new String[this.propertySets.size()];
        for (int i2 = 0; i2 < sets.length; ++i2) {
            BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile.PropertyStorage)this.propertySets.get(i2);
            sets[i2] = ps.name;
        }
        return sets;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

