/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.Range;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.RecordData;
import jxl.biff.Type;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.BlankCell;
import jxl.read.biff.BooleanRecord;
import jxl.read.biff.BottomMarginRecord;
import jxl.read.biff.CellValue;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DateFormulaRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.DefaultColumnWidthRecord;
import jxl.read.biff.DefaultRowHeightRecord;
import jxl.read.biff.DimensionRecord;
import jxl.read.biff.ErrorRecord;
import jxl.read.biff.File;
import jxl.read.biff.FooterRecord;
import jxl.read.biff.FormulaRecord;
import jxl.read.biff.HeaderRecord;
import jxl.read.biff.HorizontalPageBreaksRecord;
import jxl.read.biff.HyperlinkRecord;
import jxl.read.biff.LabelRecord;
import jxl.read.biff.LabelSSTRecord;
import jxl.read.biff.LeftMarginRecord;
import jxl.read.biff.MarginRecord;
import jxl.read.biff.MergedCellsRecord;
import jxl.read.biff.MulBlankCell;
import jxl.read.biff.MulBlankRecord;
import jxl.read.biff.MulRKRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.NumberRecord;
import jxl.read.biff.NumberValue;
import jxl.read.biff.PLSRecord;
import jxl.read.biff.PaneRecord;
import jxl.read.biff.PasswordRecord;
import jxl.read.biff.PrintGridLinesRecord;
import jxl.read.biff.PrintHeadersRecord;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.RKHelper;
import jxl.read.biff.RKRecord;
import jxl.read.biff.RStringRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RightMarginRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SCLRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SetupRecord;
import jxl.read.biff.SharedFormulaRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.TopMarginRecord;
import jxl.read.biff.Window2Record;
import jxl.read.biff.WorkbookParser;

final class SheetReader {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$SheetReader == null ? (class$jxl$read$biff$SheetReader = SheetReader.class$("jxl.read.biff.SheetReader")) : class$jxl$read$biff$SheetReader);
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private Range[] mergedCells;
    private ArrayList charts;
    private ArrayList drawings;
    private boolean nineteenFour;
    private HeaderRecord header;
    private FooterRecord footer;
    private PLSRecord plsRecord;
    private WorkspaceInformationRecord workspaceOptions;
    private int[] rowBreaks;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private WorkbookParser workbook;
    private SheetImpl sheet;
    static /* synthetic */ Class class$jxl$read$biff$SheetReader;

    SheetReader(File f2, SSTRecord sst, FormattingRecords fr, BOFRecord sb, BOFRecord wb, boolean nf, WorkbookParser wp, int sp, SheetImpl sh) {
        this.excelFile = f2;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.sheetBof = sb;
        this.workbookBof = wb;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.charts = new ArrayList();
        this.drawings = new ArrayList();
        this.nineteenFour = nf;
        this.workbook = wp;
        this.startPosition = sp;
        this.sheet = sh;
        this.settings = new SheetSettings();
        this.workbookSettings = this.workbook.getSettings();
    }

    private void addCell(Cell cell) {
        if (cell.getRow() < this.numRows && cell.getColumn() < this.numCols) {
            if (this.cells[cell.getRow()][cell.getColumn()] != null) {
                StringBuffer sb = new StringBuffer();
                CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow(), sb);
                logger.warn("Cell " + sb.toString() + " already contains data");
            }
            this.cells[cell.getRow()][cell.getColumn()] = cell;
        }
    }

    final void read() {
        Record r2 = null;
        BaseSharedFormulaRecord sharedFormula = null;
        boolean sharedFormulaAdded = false;
        boolean cont = true;
        this.excelFile.setPos(this.startPosition);
        MsoDrawingRecord msoRecord = null;
        ObjRecord objRecord = null;
        Window2Record window2Record = null;
        PrintGridLinesRecord printGridLinesRecord = null;
        PrintHeadersRecord printHeadersRecord = null;
        while (cont) {
            MarginRecord m2;
            CellValue lr;
            RecordData pr;
            RecordData br;
            RecordData dr;
            r2 = this.excelFile.next();
            if (r2.getType() == Type.UNKNOWN && r2.getCode() == 0) {
                System.err.print("Warning:  biff code zero found");
                if (r2.getLength() == 10) {
                    logger.warn("Biff code zero found - trying a dimension record.");
                    r2.setType(Type.DIMENSION);
                } else {
                    logger.warn("Biff code zero found - Ignoring.");
                }
            }
            if (r2.getType() == Type.DIMENSION) {
                dr = null;
                dr = this.workbookBof.isBiff8() ? new DimensionRecord(r2) : new DimensionRecord(r2, DimensionRecord.biff7);
                this.numRows = ((DimensionRecord)dr).getNumberOfRows();
                this.numCols = ((DimensionRecord)dr).getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
                continue;
            }
            if (r2.getType() == Type.LABELSST) {
                LabelSSTRecord label = new LabelSSTRecord(r2, this.sharedStrings, this.formattingRecords, this.sheet);
                this.addCell(label);
                continue;
            }
            if (r2.getType() == Type.RK || r2.getType() == Type.RK2) {
                RKRecord rkr = new RKRecord(r2, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(rkr.getXFIndex())) {
                    DateRecord dc = new DateRecord(rkr, rkr.getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dc);
                    continue;
                }
                this.addCell(rkr);
                continue;
            }
            if (r2.getType() == Type.HLINK) {
                HyperlinkRecord hr = new HyperlinkRecord(r2, this.sheet, this.workbookSettings);
                this.hyperlinks.add(hr);
                continue;
            }
            if (r2.getType() == Type.MERGEDCELLS) {
                MergedCellsRecord mc = new MergedCellsRecord(r2, this.sheet);
                if (this.mergedCells == null) {
                    this.mergedCells = mc.getRanges();
                    continue;
                }
                Range[] newMergedCells = new Range[this.mergedCells.length + mc.getRanges().length];
                System.arraycopy(this.mergedCells, 0, newMergedCells, 0, this.mergedCells.length);
                System.arraycopy(mc.getRanges(), 0, newMergedCells, this.mergedCells.length, mc.getRanges().length);
                this.mergedCells = newMergedCells;
                continue;
            }
            if (r2.getType() == Type.MULRK) {
                MulRKRecord mulrk = new MulRKRecord(r2);
                int num = mulrk.getNumberOfColumns();
                int ixf = 0;
                for (int i2 = 0; i2 < num; ++i2) {
                    ixf = mulrk.getXFIndex(i2);
                    NumberValue nv = new NumberValue(mulrk.getRow(), mulrk.getFirstColumn() + i2, RKHelper.getDouble(mulrk.getRKNumber(i2)), ixf, this.formattingRecords, this.sheet);
                    if (this.formattingRecords.isDate(ixf)) {
                        DateRecord dc = new DateRecord(nv, ixf, this.formattingRecords, this.nineteenFour, this.sheet);
                        this.addCell(dc);
                        continue;
                    }
                    nv.setNumberFormat(this.formattingRecords.getNumberFormat(ixf));
                    this.addCell(nv);
                }
                continue;
            }
            if (r2.getType() == Type.NUMBER) {
                NumberRecord nr = new NumberRecord(r2, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(nr.getXFIndex())) {
                    DateRecord dc = new DateRecord(nr, nr.getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dc);
                    continue;
                }
                this.addCell(nr);
                continue;
            }
            if (r2.getType() == Type.BOOLERR) {
                br = new BooleanRecord(r2, this.formattingRecords, this.sheet);
                if (((BooleanRecord)br).isError()) {
                    ErrorRecord er = new ErrorRecord(((BooleanRecord)br).getRecord(), this.formattingRecords, this.sheet);
                    this.addCell(er);
                    continue;
                }
                this.addCell((Cell)((Object)br));
                continue;
            }
            if (r2.getType() == Type.PRINTGRIDLINES) {
                printGridLinesRecord = new PrintGridLinesRecord(r2);
                this.settings.setPrintGridLines(printGridLinesRecord.getPrintGridLines());
                continue;
            }
            if (r2.getType() == Type.PRINTHEADERS) {
                printHeadersRecord = new PrintHeadersRecord(r2);
                this.settings.setPrintHeaders(printHeadersRecord.getPrintHeaders());
                continue;
            }
            if (r2.getType() == Type.WINDOW2) {
                window2Record = new Window2Record(r2);
                this.settings.setShowGridLines(window2Record.getShowGridLines());
                this.settings.setDisplayZeroValues(window2Record.getDisplayZeroValues());
                this.settings.setSelected();
                continue;
            }
            if (r2.getType() == Type.PANE) {
                pr = new PaneRecord(r2);
                if (window2Record == null || !window2Record.getFrozen() || !window2Record.getFrozenNotSplit()) continue;
                this.settings.setVerticalFreeze(((PaneRecord)pr).getRowsVisible());
                this.settings.setHorizontalFreeze(((PaneRecord)pr).getColumnsVisible());
                continue;
            }
            if (r2.getType() == Type.CONTINUE || r2.getType() == Type.NOTE || r2.getType() == Type.ARRAY) continue;
            if (r2.getType() == Type.PROTECT) {
                pr = new ProtectRecord(r2);
                this.settings.setProtected(((ProtectRecord)pr).isProtected());
                continue;
            }
            if (r2.getType() == Type.SHAREDFORMULA) {
                SharedFormulaRecord sfr = new SharedFormulaRecord(r2, sharedFormula, this.workbook, this.workbook, this.sheet);
                this.sharedFormulas.add(sfr);
                sharedFormula = null;
                continue;
            }
            if (r2.getType() == Type.FORMULA || r2.getType() == Type.FORMULA2) {
                NumberFormulaRecord nfr;
                FormulaRecord fr = new FormulaRecord(r2, this.excelFile, this.formattingRecords, this.workbook, this.workbook, this.sheet, this.workbookSettings);
                if (fr.isShared()) {
                    BaseSharedFormulaRecord prevSharedFormula = sharedFormula;
                    sharedFormula = (BaseSharedFormulaRecord)fr.getFormula();
                    sharedFormulaAdded = this.addToSharedFormulas(sharedFormula);
                    if (sharedFormulaAdded) {
                        sharedFormula = prevSharedFormula;
                    }
                    if (sharedFormulaAdded || prevSharedFormula == null) continue;
                    this.addCell(this.revertSharedFormula(prevSharedFormula));
                    continue;
                }
                Cell cell = fr.getFormula();
                if (fr.getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((nfr = (NumberFormulaRecord)fr.getFormula()).getXFIndex())) {
                    cell = new DateFormulaRecord(nfr, this.formattingRecords, this.workbook, this.workbook, this.nineteenFour, this.sheet);
                }
                this.addCell(cell);
                continue;
            }
            if (r2.getType() == Type.LABEL) {
                lr = null;
                lr = this.workbookBof.isBiff8() ? new LabelRecord(r2, this.formattingRecords, this.sheet, this.workbookSettings) : new LabelRecord(r2, this.formattingRecords, this.sheet, this.workbookSettings, LabelRecord.biff7);
                this.addCell(lr);
                continue;
            }
            if (r2.getType() == Type.RSTRING) {
                lr = null;
                Assert.verify(!this.workbookBof.isBiff8());
                lr = new RStringRecord(r2, this.formattingRecords, this.sheet, this.workbookSettings, RStringRecord.biff7);
                this.addCell(lr);
                continue;
            }
            if (r2.getType() == Type.NAME) continue;
            if (r2.getType() == Type.PASSWORD) {
                pr = new PasswordRecord(r2);
                this.settings.setPasswordHash(((PasswordRecord)pr).getPasswordHash());
                continue;
            }
            if (r2.getType() == Type.ROW) {
                RowRecord rr = new RowRecord(r2);
                if (rr.isDefaultHeight() && !rr.isCollapsed() && !rr.isZeroHeight()) continue;
                this.rowProperties.add(rr);
                continue;
            }
            if (r2.getType() == Type.BLANK) {
                BlankCell bc = new BlankCell(r2, this.formattingRecords, this.sheet);
                this.addCell(bc);
                continue;
            }
            if (r2.getType() == Type.MULBLANK) {
                MulBlankRecord mulblank = new MulBlankRecord(r2);
                int num = mulblank.getNumberOfColumns();
                for (int i3 = 0; i3 < num; ++i3) {
                    int ixf = mulblank.getXFIndex(i3);
                    MulBlankCell mbc = new MulBlankCell(mulblank.getRow(), mulblank.getFirstColumn() + i3, ixf, this.formattingRecords, this.sheet);
                    this.addCell(mbc);
                }
                continue;
            }
            if (r2.getType() == Type.SCL) {
                SCLRecord scl = new SCLRecord(r2);
                this.settings.setZoomFactor(scl.getZoomFactor());
                continue;
            }
            if (r2.getType() == Type.COLINFO) {
                ColumnInfoRecord cir = new ColumnInfoRecord(r2);
                this.columnInfosArray.add(cir);
                continue;
            }
            if (r2.getType() == Type.HEADER) {
                if (this.workbookBof.isBiff8()) {
                    this.header = new HeaderRecord(r2, this.workbookSettings);
                    continue;
                }
                this.header = new HeaderRecord(r2, this.workbookSettings, HeaderRecord.biff7);
                continue;
            }
            if (r2.getType() == Type.FOOTER) {
                if (this.workbookBof.isBiff8()) {
                    this.footer = new FooterRecord(r2, this.workbookSettings);
                    continue;
                }
                this.footer = new FooterRecord(r2, this.workbookSettings, FooterRecord.biff7);
                continue;
            }
            if (r2.getType() == Type.SETUP) {
                SetupRecord sr = new SetupRecord(r2);
                if (sr.isPortrait()) {
                    this.settings.setOrientation(PageOrientation.PORTRAIT);
                } else {
                    this.settings.setOrientation(PageOrientation.LANDSCAPE);
                }
                this.settings.setPaperSize(PaperSize.getPaperSize(sr.getPaperSize()));
                this.settings.setHeaderMargin(sr.getHeaderMargin());
                this.settings.setFooterMargin(sr.getFooterMargin());
                this.settings.setScaleFactor(sr.getScaleFactor());
                this.settings.setPageStart(sr.getPageStart());
                this.settings.setFitWidth(sr.getFitWidth());
                this.settings.setFitHeight(sr.getFitHeight());
                this.settings.setHorizontalPrintResolution(sr.getHorizontalPrintResolution());
                this.settings.setVerticalPrintResolution(sr.getVerticalPrintResolution());
                this.settings.setCopies(sr.getCopies());
                if (this.workspaceOptions == null) continue;
                this.settings.setFitToPages(this.workspaceOptions.getFitToPages());
                continue;
            }
            if (r2.getType() == Type.WSBOOL) {
                this.workspaceOptions = new WorkspaceInformationRecord(r2);
                continue;
            }
            if (r2.getType() == Type.DEFCOLWIDTH) {
                DefaultColumnWidthRecord dcwr = new DefaultColumnWidthRecord(r2);
                this.settings.setDefaultColumnWidth(dcwr.getWidth());
                continue;
            }
            if (r2.getType() == Type.DEFAULTROWHEIGHT) {
                DefaultRowHeightRecord drhr = new DefaultRowHeightRecord(r2);
                if (drhr.getHeight() == 0) continue;
                this.settings.setDefaultRowHeight(drhr.getHeight());
                continue;
            }
            if (r2.getType() == Type.LEFTMARGIN) {
                m2 = new LeftMarginRecord(r2);
                this.settings.setLeftMargin(m2.getMargin());
                continue;
            }
            if (r2.getType() == Type.RIGHTMARGIN) {
                m2 = new RightMarginRecord(r2);
                this.settings.setRightMargin(m2.getMargin());
                continue;
            }
            if (r2.getType() == Type.TOPMARGIN) {
                m2 = new TopMarginRecord(r2);
                this.settings.setTopMargin(m2.getMargin());
                continue;
            }
            if (r2.getType() == Type.BOTTOMMARGIN) {
                m2 = new BottomMarginRecord(r2);
                this.settings.setBottomMargin(m2.getMargin());
                continue;
            }
            if (r2.getType() == Type.HORIZONTALPAGEBREAKS) {
                dr = null;
                dr = this.workbookBof.isBiff8() ? new HorizontalPageBreaksRecord(r2) : new HorizontalPageBreaksRecord(r2, HorizontalPageBreaksRecord.biff7);
                this.rowBreaks = ((HorizontalPageBreaksRecord)dr).getRowBreaks();
                continue;
            }
            if (r2.getType() == Type.PLS) {
                this.plsRecord = new PLSRecord(r2);
                continue;
            }
            if (r2.getType() == Type.OBJ) {
                objRecord = new ObjRecord(r2);
                if (objRecord.getType() != ObjRecord.PICTURE) continue;
                Drawing drawing = new Drawing(msoRecord, objRecord, this.workbook.getDrawingGroup());
                this.drawings.add(drawing);
                msoRecord = null;
                objRecord = null;
                continue;
            }
            if (r2.getType() == Type.MSODRAWING) {
                msoRecord = new MsoDrawingRecord(r2);
                continue;
            }
            if (r2.getType() == Type.BOF) {
                br = new BOFRecord(r2);
                Assert.verify(!((BOFRecord)br).isWorksheet());
                int startpos = this.excelFile.getPos() - r2.getLength() - 4;
                Record r22 = this.excelFile.next();
                while (r22.getCode() != Type.EOF.value) {
                    r22 = this.excelFile.next();
                }
                if (((BOFRecord)br).isChart()) {
                    Chart chart = new Chart(msoRecord, objRecord, startpos, this.excelFile.getPos(), this.excelFile, this.workbookSettings);
                    this.charts.add(chart);
                    this.workbook.getDrawingGroup().add(chart);
                    msoRecord = null;
                    objRecord = null;
                }
                if (!this.sheetBof.isChart()) continue;
                cont = false;
                continue;
            }
            if (r2.getType() != Type.EOF) continue;
            cont = false;
        }
        this.excelFile.restorePos();
        Iterator i4 = this.sharedFormulas.iterator();
        while (i4.hasNext()) {
            SharedFormulaRecord sfr = (SharedFormulaRecord)i4.next();
            Cell[] sfnr = sfr.getFormulas(this.formattingRecords, this.nineteenFour);
            for (int sf = 0; sf < sfnr.length; ++sf) {
                this.addCell(sfnr[sf]);
            }
        }
        if (!sharedFormulaAdded && sharedFormula != null) {
            this.addCell(this.revertSharedFormula(sharedFormula));
        }
    }

    private boolean addToSharedFormulas(BaseSharedFormulaRecord fr) {
        Iterator i2 = this.sharedFormulas.iterator();
        boolean added = false;
        SharedFormulaRecord sfr = null;
        while (i2.hasNext() && !added) {
            sfr = (SharedFormulaRecord)i2.next();
            added = sfr.add(fr);
        }
        return added;
    }

    private Cell revertSharedFormula(BaseSharedFormulaRecord f2) {
        int pos = this.excelFile.getPos();
        this.excelFile.setPos(f2.getFilePos());
        FormulaRecord fr = new FormulaRecord(f2.getRecord(), this.excelFile, this.formattingRecords, this.workbook, this.workbook, FormulaRecord.ignoreSharedFormula, this.sheet, this.workbookSettings);
        Cell cell = fr.getFormula();
        if (fr.getFormula().getType() == CellType.NUMBER_FORMULA) {
            NumberFormulaRecord nfr = (NumberFormulaRecord)fr.getFormula();
            if (this.formattingRecords.isDate(fr.getXFIndex())) {
                cell = new DateFormulaRecord(nfr, this.formattingRecords, this.workbook, this.workbook, this.nineteenFour, this.sheet);
            }
        }
        this.excelFile.setPos(pos);
        return cell;
    }

    final int getNumRows() {
        return this.numRows;
    }

    final int getNumCols() {
        return this.numCols;
    }

    final Cell[][] getCells() {
        return this.cells;
    }

    final ArrayList getRowProperties() {
        return this.rowProperties;
    }

    final ArrayList getColumnInfosArray() {
        return this.columnInfosArray;
    }

    final ArrayList getHyperlinks() {
        return this.hyperlinks;
    }

    final ArrayList getCharts() {
        return this.charts;
    }

    final ArrayList getDrawings() {
        return this.drawings;
    }

    final Range[] getMergedCells() {
        return this.mergedCells;
    }

    final HeaderRecord getHeader() {
        return this.header;
    }

    final FooterRecord getFooter() {
        return this.footer;
    }

    final SheetSettings getSettings() {
        return this.settings;
    }

    final int[] getRowBreaks() {
        return this.rowBreaks;
    }

    final WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    final PLSRecord getPLS() {
        return this.plsRecord;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

