/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.io.OutputStream;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;

final class CompoundFile
extends BaseCompoundFile {
    private OutputStream out;
    private byte[] excelData;
    private int size;
    private int requiredSize;
    private int numBigBlockDepotBlocks;
    private int numExtensionBlocks;
    private int extensionBlock;
    private int excelDataBlocks;
    private int rootStartBlock;
    private int excelDataStartBlock;
    private int bbdStartBlock;
    private int bbdPos;
    private byte[] bigBlockDepot;

    public CompoundFile(byte[] data, int l2, OutputStream os) {
        this.size = l2;
        this.excelData = data;
        int blocks = l2 / 512 + 1;
        this.requiredSize = l2 < 4096 ? 4096 : blocks * 512;
        this.out = os;
        this.excelDataBlocks = this.requiredSize / 512;
        int blockChainLength = 109;
        int totalBlocks = this.excelDataBlocks + 8 + 8 + 1 + 1;
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)totalBlocks / 128.0);
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)(totalBlocks += this.numBigBlockDepotBlocks) / 128.0);
        if (this.numBigBlockDepotBlocks > blockChainLength - 1) {
            this.extensionBlock = 0;
            int bbdBlocksLeft = this.numBigBlockDepotBlocks - blockChainLength + 1;
            this.numExtensionBlocks = (int)Math.ceil((double)bbdBlocksLeft / 127.0);
            this.numBigBlockDepotBlocks = (int)Math.ceil((double)(totalBlocks += this.numExtensionBlocks) / 128.0);
        } else {
            this.extensionBlock = -2;
            this.numExtensionBlocks = 0;
        }
        this.excelDataStartBlock = this.numExtensionBlocks;
        this.bbdStartBlock = this.excelDataStartBlock + this.excelDataBlocks + 16;
        this.rootStartBlock = this.excelDataStartBlock + this.excelDataBlocks + 16 + this.numBigBlockDepotBlocks;
    }

    public void write() throws IOException {
        this.writeHeader();
        this.writeExcelData();
        this.writeBigBlockDepot();
        this.writePropertySets();
    }

    private void writeExcelData() throws IOException {
        this.out.write(this.excelData, 0, this.size);
        byte[] padding = new byte[this.requiredSize - this.size];
        this.out.write(padding);
        padding = new byte[4096];
        this.out.write(padding);
        this.out.write(padding);
    }

    private void writeHeader() throws IOException {
        int i2;
        byte[] headerBlock = new byte[512];
        byte[] extensionBlockData = new byte[512 * this.numExtensionBlocks];
        System.arraycopy(IDENTIFIER, 0, headerBlock, 0, IDENTIFIER.length);
        headerBlock[24] = 62;
        headerBlock[26] = 3;
        headerBlock[28] = -2;
        headerBlock[29] = -1;
        headerBlock[30] = 9;
        headerBlock[32] = 6;
        headerBlock[57] = 16;
        IntegerHelper.getFourBytes(this.numBigBlockDepotBlocks, headerBlock, 44);
        IntegerHelper.getFourBytes(-2, headerBlock, 60);
        IntegerHelper.getFourBytes(this.extensionBlock, headerBlock, 68);
        IntegerHelper.getFourBytes(this.numExtensionBlocks, headerBlock, 72);
        IntegerHelper.getFourBytes(this.rootStartBlock, headerBlock, 48);
        int pos = 76;
        int blocksToWrite = Math.min(this.numBigBlockDepotBlocks, 109);
        boolean extensionBlock = false;
        int blocksWritten = 0;
        for (i2 = 0; i2 < blocksToWrite; ++i2) {
            IntegerHelper.getFourBytes(this.bbdStartBlock + i2, headerBlock, pos);
            pos += 4;
            ++blocksWritten;
        }
        for (i2 = pos; i2 < 512; ++i2) {
            headerBlock[i2] = -1;
        }
        this.out.write(headerBlock);
        pos = 0;
        for (int extBlock = 0; extBlock < this.numExtensionBlocks; ++extBlock) {
            blocksToWrite = Math.min(this.numBigBlockDepotBlocks - blocksWritten, 127);
            for (int j2 = 0; j2 < blocksToWrite; ++j2) {
                IntegerHelper.getFourBytes(this.bbdStartBlock + blocksWritten + j2, extensionBlockData, pos);
                pos += 4;
            }
            int nextBlock = (blocksWritten += blocksToWrite) == this.numBigBlockDepotBlocks ? -2 : extBlock + 1;
            IntegerHelper.getFourBytes(nextBlock, extensionBlockData, pos);
            pos += 4;
        }
        if (this.numExtensionBlocks > 0) {
            for (i2 = pos; i2 < extensionBlockData.length; ++i2) {
                extensionBlockData[i2] = -1;
            }
            this.out.write(extensionBlockData);
        }
    }

    private void checkBbdPos() throws IOException {
        if (this.bbdPos >= 512) {
            this.out.write(this.bigBlockDepot);
            this.bigBlockDepot = new byte[512];
            this.bbdPos = 0;
        }
    }

    private void writeBigBlockDepot() throws IOException {
        int summaryInfoBlock;
        int i2;
        int bbdBlocks;
        this.bigBlockDepot = new byte[512];
        this.bbdPos = 0;
        for (int i3 = 0; i3 < this.numExtensionBlocks; ++i3) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        int blockNumber = this.excelDataStartBlock + 1;
        for (int blocksToWrite = this.excelDataBlocks - 1; blocksToWrite > 0; blocksToWrite -= bbdBlocks) {
            bbdBlocks = Math.min(blocksToWrite, (512 - this.bbdPos) / 4);
            for (i2 = 0; i2 < bbdBlocks; ++i2) {
                IntegerHelper.getFourBytes(blockNumber, this.bigBlockDepot, this.bbdPos);
                this.bbdPos += 4;
                ++blockNumber;
            }
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        for (i2 = summaryInfoBlock = this.excelDataStartBlock + this.excelDataBlocks; i2 < summaryInfoBlock + 7; ++i2) {
            IntegerHelper.getFourBytes(i2 + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        for (i2 = summaryInfoBlock + 8; i2 < summaryInfoBlock + 15; ++i2) {
            IntegerHelper.getFourBytes(i2 + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        for (i2 = 0; i2 < this.numBigBlockDepotBlocks; ++i2) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        if (this.bbdPos != 0) {
            for (i2 = this.bbdPos; i2 < 512; ++i2) {
                this.bigBlockDepot[i2] = -1;
            }
            this.out.write(this.bigBlockDepot);
        }
    }

    private void writePropertySets() throws IOException {
        byte[] propertySetStorage = new byte[512];
        int pos = 0;
        BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("Root Entry");
        ps.setType(5);
        ps.setStartBlock(-2);
        ps.setSize(0);
        ps.setPrevious(-1);
        ps.setNext(-1);
        ps.setDirectory(2);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, 128);
        pos += 128;
        ps = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("Workbook");
        ps.setType(2);
        ps.setStartBlock(this.excelDataStartBlock);
        ps.setSize(this.requiredSize);
        ps.setPrevious(-1);
        ps.setNext(-1);
        ps.setDirectory(-1);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, 128);
        pos += 128;
        ps = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("\u0005SummaryInformation");
        ps.setType(2);
        ps.setStartBlock(this.excelDataStartBlock + this.excelDataBlocks);
        ps.setSize(4096);
        ps.setPrevious(1);
        ps.setNext(3);
        ps.setDirectory(-1);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, 128);
        pos += 128;
        ps = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage("\u0005DocumentSummaryInformation");
        ps.setType(2);
        ps.setStartBlock(this.excelDataStartBlock + this.excelDataBlocks + 8);
        ps.setSize(4096);
        ps.setPrevious(-1);
        ps.setNext(-1);
        ps.setDirectory(-1);
        System.arraycopy(ps.data, 0, propertySetStorage, pos, 128);
        pos += 128;
        this.out.write(propertySetStorage);
    }
}

