/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.SheetSettings;
import jxl.biff.DoubleHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;

class SetupRecord
extends WritableRecordData {
    private byte[] data;
    private double headerMargin;
    private double footerMargin;
    private PageOrientation orientation;
    private int paperSize;
    private int scaleFactor;
    private int pageStart;
    private int fitWidth;
    private int fitHeight;
    private int horizontalPrintResolution;
    private int verticalPrintResolution;
    private int copies;

    public SetupRecord() {
        super(Type.SETUP);
        this.orientation = PageOrientation.PORTRAIT;
        this.headerMargin = 0.5;
        this.footerMargin = 0.5;
        this.paperSize = PaperSize.A4.getValue();
        this.horizontalPrintResolution = 300;
        this.verticalPrintResolution = 300;
        this.copies = 1;
    }

    public SetupRecord(SheetSettings s2) {
        super(Type.SETUP);
        this.orientation = s2.getOrientation();
        this.headerMargin = s2.getHeaderMargin();
        this.footerMargin = s2.getFooterMargin();
        this.paperSize = s2.getPaperSize().getValue();
        this.horizontalPrintResolution = s2.getHorizontalPrintResolution();
        this.verticalPrintResolution = s2.getVerticalPrintResolution();
        this.fitWidth = s2.getFitWidth();
        this.fitHeight = s2.getFitHeight();
        this.pageStart = s2.getPageStart();
        this.scaleFactor = s2.getScaleFactor();
        this.copies = s2.getCopies();
    }

    public SetupRecord(jxl.read.biff.SetupRecord sr) {
        super(Type.SETUP);
        this.orientation = sr.isPortrait() ? PageOrientation.PORTRAIT : PageOrientation.LANDSCAPE;
        this.paperSize = sr.getPaperSize();
        this.headerMargin = sr.getHeaderMargin();
        this.footerMargin = sr.getFooterMargin();
        this.scaleFactor = sr.getScaleFactor();
        this.pageStart = sr.getPageStart();
        this.fitWidth = sr.getFitWidth();
        this.fitHeight = sr.getFitHeight();
        this.horizontalPrintResolution = sr.getHorizontalPrintResolution();
        this.verticalPrintResolution = sr.getVerticalPrintResolution();
        this.copies = sr.getCopies();
    }

    public void setOrientation(PageOrientation o2) {
        this.orientation = o2;
    }

    public void setMargins(double hm, double fm) {
        this.headerMargin = hm;
        this.footerMargin = fm;
    }

    public void setPaperSize(PaperSize ps) {
        this.paperSize = ps.getValue();
    }

    public byte[] getData() {
        this.data = new byte[34];
        IntegerHelper.getTwoBytes(this.paperSize, this.data, 0);
        IntegerHelper.getTwoBytes(this.scaleFactor, this.data, 2);
        IntegerHelper.getTwoBytes(this.pageStart, this.data, 4);
        IntegerHelper.getTwoBytes(this.fitWidth, this.data, 6);
        IntegerHelper.getTwoBytes(this.fitHeight, this.data, 8);
        if (this.orientation == PageOrientation.PORTRAIT) {
            IntegerHelper.getTwoBytes(2, this.data, 10);
        }
        IntegerHelper.getTwoBytes(this.horizontalPrintResolution, this.data, 12);
        IntegerHelper.getTwoBytes(this.verticalPrintResolution, this.data, 14);
        DoubleHelper.getIEEEBytes(this.headerMargin, this.data, 16);
        DoubleHelper.getIEEEBytes(this.footerMargin, this.data, 24);
        IntegerHelper.getTwoBytes(this.copies, this.data, 32);
        return this.data;
    }
}

