/*
 * Decompiled with CFR 0.152.
 */
package com.Ostermiller.Syntax.Lexer;

import com.Ostermiller.Syntax.Lexer.Token;

public class PropertiesToken
extends Token {
    public static final int EQUAL = 258;
    public static final int COLON = 259;
    public static final int LINE_CONTINUE = 260;
    public static final int NAME = 1280;
    public static final int VALUE = 1536;
    public static final int COMMENT = 3328;
    public static final int WHITE_SPACE = 3584;
    public static final int MID_TOKEN_WHITE_SPACE = 3585;
    private int ID;
    private String contents;
    private int lineNumber;
    private int charBegin;
    private int charEnd;
    private int state;

    public PropertiesToken(int n2, String string, int n3, int n4, int n5) {
        this(n2, string, n3, n4, n5, -1);
    }

    public PropertiesToken(int n2, String string, int n3, int n4, int n5, int n6) {
        this.ID = n2;
        this.contents = new String(string);
        this.lineNumber = n3;
        this.charBegin = n4;
        this.charEnd = n5;
        this.state = n6;
    }

    public int getState() {
        return this.state;
    }

    public int getID() {
        return this.ID;
    }

    public String getContents() {
        return new String(this.contents);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getCharBegin() {
        return this.charBegin;
    }

    public int getCharEnd() {
        return this.charEnd;
    }

    public boolean isSeparator() {
        return this.ID >> 8 == 1;
    }

    public boolean isName() {
        return this.ID >> 8 == 5;
    }

    public boolean isValue() {
        return this.ID >> 8 == 6;
    }

    public boolean isComment() {
        return this.ID >> 8 == 13;
    }

    public boolean isWhiteSpace() {
        return this.ID >> 8 == 14;
    }

    public boolean isError() {
        return this.ID >> 8 == 15;
    }

    public String getDescription() {
        if (this.isSeparator()) {
            return "separator";
        }
        if (this.isName()) {
            return "name";
        }
        if (this.isValue()) {
            return "value";
        }
        if (this.isComment()) {
            return "comment";
        }
        if (this.isWhiteSpace()) {
            return "whitespace";
        }
        if (this.isError()) {
            return "error";
        }
        return "unknown";
    }

    public String errorString() {
        return "";
    }

    public String toString() {
        return "Token #" + Integer.toHexString(this.ID) + ": " + this.getDescription() + " Line " + this.lineNumber + " from " + this.charBegin + " to " + this.charEnd + " : " + this.contents;
    }
}

