/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import common.Logger;
import java.util.HashMap;
import java.util.Locale;
import jxl.biff.formula.FunctionNames;

public final class WorkbookSettings {
    private static Logger logger = Logger.getLogger(class$jxl$WorkbookSettings == null ? (class$jxl$WorkbookSettings = WorkbookSettings.class$("jxl.WorkbookSettings")) : class$jxl$WorkbookSettings);
    private int initialFileSize = 0x500000;
    private int arrayGrowSize = 0x100000;
    private boolean drawingsDisabled;
    private boolean namesDisabled;
    private boolean formulaReferenceAdjustDisabled;
    private boolean gcDisabled;
    private boolean rationalizationDisabled;
    private Locale locale;
    private FunctionNames functionNames;
    private String encoding;
    private HashMap localeFunctionNames = new HashMap();
    private static final int defaultInitialFileSize = 0x500000;
    private static final int defaultArrayGrowSize = 0x100000;
    static /* synthetic */ Class class$jxl$WorkbookSettings;

    public WorkbookSettings() {
        try {
            boolean suppressWarnings = Boolean.getBoolean("jxl.nowarnings");
            this.setSuppressWarnings(suppressWarnings);
            this.drawingsDisabled = Boolean.getBoolean("jxl.nodrawings");
            this.namesDisabled = Boolean.getBoolean("jxl.nonames");
            this.gcDisabled = Boolean.getBoolean("jxl.nogc");
            this.rationalizationDisabled = Boolean.getBoolean("jxl.norat");
            this.formulaReferenceAdjustDisabled = Boolean.getBoolean("jxl.noformulaadjust");
            this.encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException e2) {
            logger.warn("Error accessing system properties.", e2);
        }
        try {
            this.locale = System.getProperty("jxl.lang") == null || System.getProperty("jxl.country") == null ? Locale.getDefault() : new Locale(System.getProperty("jxl.lang"), System.getProperty("jxl.country"));
            if (System.getProperty("jxl.encoding") != null) {
                this.encoding = System.getProperty("jxl.encoding");
            }
        }
        catch (SecurityException e3) {
            logger.warn("Error accessing system properties.", e3);
            this.locale = Locale.getDefault();
        }
    }

    public void setArrayGrowSize(int sz) {
        this.arrayGrowSize = sz;
    }

    public int getArrayGrowSize() {
        return this.arrayGrowSize;
    }

    public void setInitialFileSize(int sz) {
        this.initialFileSize = sz;
    }

    public int getInitialFileSize() {
        return this.initialFileSize;
    }

    public boolean getDrawingsDisabled() {
        return this.drawingsDisabled;
    }

    public boolean getGCDisabled() {
        return this.gcDisabled;
    }

    public boolean getNamesDisabled() {
        return this.namesDisabled;
    }

    public void setNamesDisabled(boolean b2) {
        this.namesDisabled = b2;
    }

    public void setRationalization(boolean r2) {
        this.rationalizationDisabled = !r2;
    }

    public boolean getRationalizationDisabled() {
        return this.rationalizationDisabled;
    }

    public void setSuppressWarnings(boolean w) {
        logger.setSuppressWarnings(w);
    }

    public boolean getFormulaAdjust() {
        return !this.formulaReferenceAdjustDisabled;
    }

    public void setFormulaAdjust(boolean b2) {
        this.formulaReferenceAdjustDisabled = !b2;
    }

    public void setLocale(Locale l2) {
        this.locale = l2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public FunctionNames getFunctionNames() {
        if (this.functionNames == null) {
            this.functionNames = (FunctionNames)this.localeFunctionNames.get(this.locale);
            if (this.functionNames == null) {
                this.functionNames = new FunctionNames(this.locale);
                this.localeFunctionNames.put(this.locale, this.functionNames);
            }
        }
        return this.functionNames;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

