/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import jxl.CellReferenceHelper;
import jxl.CellView;
import jxl.Range;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.write.Boolean;
import jxl.write.DateFormat;
import jxl.write.DateFormats;
import jxl.write.DateTime;
import jxl.write.Formula;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.NumberFormat;
import jxl.write.NumberFormats;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;

public class Write {
    private String filename;
    private WritableWorkbook workbook;

    public Write(String fn) {
        this.filename = fn;
    }

    public void write() throws IOException, WriteException {
        WorkbookSettings ws = new WorkbookSettings();
        ws.setLocale(new Locale("en", "EN"));
        this.workbook = Workbook.createWorkbook(new File(this.filename), ws);
        WritableSheet s2 = this.workbook.createSheet("Number Formats", 0);
        WritableSheet s3 = this.workbook.createSheet("Date Formats", 1);
        WritableSheet s1 = this.workbook.createSheet("Label Formats", 2);
        WritableSheet s4 = this.workbook.createSheet("Borders", 3);
        WritableSheet s5 = this.workbook.createSheet("Labels", 4);
        WritableSheet s6 = this.workbook.createSheet("Formulas", 5);
        WritableSheet s7 = this.workbook.createSheet("Images", 6);
        this.writeLabelFormatSheet(s1);
        this.writeNumberFormatSheet(s2);
        this.writeDateFormatSheet(s3);
        this.writeBordersSheet(s4);
        this.writeLabelsSheet(s5);
        this.writeFormulaSheet(s6);
        this.writeImageSheet(s7);
        this.workbook.setColourRGB(Colour.LIME, 255, 0, 0);
        this.workbook.write();
        this.workbook.close();
    }

    private void writeNumberFormatSheet(WritableSheet s2) throws WriteException {
        int col;
        int row;
        WritableCellFormat wrappedText = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        wrappedText.setWrap(true);
        s2.setColumnView(0, 20);
        s2.setColumnView(4, 20);
        s2.setColumnView(5, 20);
        s2.setColumnView(6, 20);
        Label l2 = new Label(0, 0, "+/- Pi - default format", (CellFormat)wrappedText);
        s2.addCell(l2);
        Number n2 = new Number(1, 0, 3.1415926535);
        s2.addCell(n2);
        n2 = new Number(2, 0, -3.1415926535);
        s2.addCell(n2);
        l2 = new Label(0, 1, "+/- Pi - integer format", (CellFormat)wrappedText);
        s2.addCell(l2);
        WritableCellFormat cf1 = new WritableCellFormat(NumberFormats.INTEGER);
        n2 = new Number(1, 1, 3.1415926535, (CellFormat)cf1);
        s2.addCell(n2);
        n2 = new Number(2, 1, -3.1415926535, (CellFormat)cf1);
        s2.addCell(n2);
        l2 = new Label(0, 2, "+/- Pi - float 2dps", (CellFormat)wrappedText);
        s2.addCell(l2);
        WritableCellFormat cf2 = new WritableCellFormat(NumberFormats.FLOAT);
        n2 = new Number(1, 2, 3.1415926535, (CellFormat)cf2);
        s2.addCell(n2);
        n2 = new Number(2, 2, -3.1415926535, (CellFormat)cf2);
        s2.addCell(n2);
        l2 = new Label(0, 3, "+/- Pi - custom 3dps", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat dp3 = new NumberFormat("#.###");
        WritableCellFormat dp3cell = new WritableCellFormat(dp3);
        n2 = new Number(1, 3, 3.1415926535, (CellFormat)dp3cell);
        s2.addCell(n2);
        n2 = new Number(2, 3, -3.1415926535, (CellFormat)dp3cell);
        s2.addCell(n2);
        l2 = new Label(0, 4, "+/- Pi - custom &3.14", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat pounddp2 = new NumberFormat("&#.00");
        WritableCellFormat pounddp2cell = new WritableCellFormat(pounddp2);
        n2 = new Number(1, 4, 3.1415926535, (CellFormat)pounddp2cell);
        s2.addCell(n2);
        n2 = new Number(2, 4, -3.1415926535, (CellFormat)pounddp2cell);
        s2.addCell(n2);
        l2 = new Label(0, 5, "+/- Pi - custom Text #.### Text", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat textdp4 = new NumberFormat("Text#.####Text");
        WritableCellFormat textdp4cell = new WritableCellFormat(textdp4);
        n2 = new Number(1, 5, 3.1415926535, (CellFormat)textdp4cell);
        s2.addCell(n2);
        n2 = new Number(2, 5, -3.1415926535, (CellFormat)textdp4cell);
        s2.addCell(n2);
        l2 = new Label(4, 0, "+/- Bilko default format");
        s2.addCell(l2);
        n2 = new Number(5, 0, 1.5042699E7);
        s2.addCell(n2);
        n2 = new Number(6, 0, -1.5042699E7);
        s2.addCell(n2);
        l2 = new Label(4, 1, "+/- Bilko float format");
        s2.addCell(l2);
        WritableCellFormat cfi1 = new WritableCellFormat(NumberFormats.FLOAT);
        n2 = new Number(5, 1, 1.5042699E7, (CellFormat)cfi1);
        s2.addCell(n2);
        n2 = new Number(6, 1, -1.5042699E7, (CellFormat)cfi1);
        s2.addCell(n2);
        l2 = new Label(4, 2, "+/- Thousands separator");
        s2.addCell(l2);
        WritableCellFormat cfi2 = new WritableCellFormat(NumberFormats.THOUSANDS_INTEGER);
        n2 = new Number(5, 2, 1.5042699E7, (CellFormat)cfi2);
        s2.addCell(n2);
        n2 = new Number(6, 2, -1.5042699E7, (CellFormat)cfi2);
        s2.addCell(n2);
        l2 = new Label(4, 3, "+/- Accounting red - added 0.01");
        s2.addCell(l2);
        WritableCellFormat cfi3 = new WritableCellFormat(NumberFormats.ACCOUNTING_RED_FLOAT);
        n2 = new Number(5, 3, 1.504269901E7, (CellFormat)cfi3);
        s2.addCell(n2);
        n2 = new Number(6, 3, -1.504269901E7, (CellFormat)cfi3);
        s2.addCell(n2);
        l2 = new Label(4, 4, "+/- Percent");
        s2.addCell(l2);
        WritableCellFormat cfi4 = new WritableCellFormat(NumberFormats.PERCENT_INTEGER);
        n2 = new Number(5, 4, 1.5042699E7, (CellFormat)cfi4);
        s2.addCell(n2);
        n2 = new Number(6, 4, -1.5042699E7, (CellFormat)cfi4);
        s2.addCell(n2);
        l2 = new Label(4, 5, "+/- Exponential - 2dps");
        s2.addCell(l2);
        WritableCellFormat cfi5 = new WritableCellFormat(NumberFormats.EXPONENTIAL);
        n2 = new Number(5, 5, 1.5042699E7, (CellFormat)cfi5);
        s2.addCell(n2);
        n2 = new Number(6, 5, -1.5042699E7, (CellFormat)cfi5);
        s2.addCell(n2);
        l2 = new Label(4, 6, "+/- Custom exponentional - 3dps", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat edp3 = new NumberFormat("0.000E0");
        WritableCellFormat edp3Cell = new WritableCellFormat(edp3);
        n2 = new Number(5, 6, 1.5042699E7, (CellFormat)edp3Cell);
        s2.addCell(n2);
        n2 = new Number(6, 6, -1.5042699E7, (CellFormat)edp3Cell);
        s2.addCell(n2);
        l2 = new Label(4, 7, "Custom neg brackets", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat negbracks = new NumberFormat("#,##0;(#,##0)");
        WritableCellFormat negbrackscell = new WritableCellFormat(negbracks);
        n2 = new Number(5, 7, 1.5042699E7, (CellFormat)negbrackscell);
        s2.addCell(n2);
        n2 = new Number(6, 7, -1.5042699E7, (CellFormat)negbrackscell);
        s2.addCell(n2);
        l2 = new Label(4, 8, "Custom neg brackets 2", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat negbracks2 = new NumberFormat("#,##0;(#,##0)a");
        WritableCellFormat negbrackscell2 = new WritableCellFormat(negbracks2);
        n2 = new Number(5, 8, 1.5042699E7, (CellFormat)negbrackscell2);
        s2.addCell(n2);
        n2 = new Number(6, 8, -1.5042699E7, (CellFormat)negbrackscell2);
        s2.addCell(n2);
        l2 = new Label(4, 9, "Custom percent", (CellFormat)wrappedText);
        s2.addCell(l2);
        NumberFormat cuspercent = new NumberFormat("0.0%");
        WritableCellFormat cuspercentf = new WritableCellFormat(cuspercent);
        n2 = new Number(5, 9, 3.14159265, (CellFormat)cuspercentf);
        s2.addCell(n2);
        l2 = new Label(0, 10, "Boolean - TRUE");
        s2.addCell(l2);
        Boolean b2 = new Boolean(1, 10, true);
        s2.addCell(b2);
        l2 = new Label(0, 11, "Boolean - FALSE");
        s2.addCell(l2);
        b2 = new Boolean(1, 11, false);
        s2.addCell(b2);
        for (row = 0; row < 100; ++row) {
            for (col = 8; col < 108; ++col) {
                n2 = new Number(col, row, (double)(col + row));
                s2.addCell(n2);
            }
        }
        for (row = 101; row < 3000; ++row) {
            for (col = 0; col < 25; ++col) {
                n2 = new Number(col, row, (double)(col + row));
                s2.addCell(n2);
            }
        }
    }

    private void writeDateFormatSheet(WritableSheet s2) throws WriteException {
        WritableCellFormat wrappedText = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
        wrappedText.setWrap(true);
        s2.setColumnView(0, 20);
        s2.setColumnView(2, 20);
        s2.setColumnView(3, 20);
        s2.getSettings().setFitWidth(2);
        s2.getSettings().setFitHeight(2);
        Calendar c2 = Calendar.getInstance();
        c2.set(1975, 4, 31, 15, 21, 45);
        c2.set(14, 660);
        Date date = c2.getTime();
        c2.set(1900, 0, 1, 0, 0, 0);
        c2.set(14, 0);
        Date date2 = c2.getTime();
        Date date3 = new Date(0L);
        c2.set(1918, 10, 11, 10, 0, 0);
        Date date4 = c2.getTime();
        c2.set(1900, 0, 2, 0, 0, 0);
        Date date5 = c2.getTime();
        c2.set(1901, 0, 1, 0, 0, 0);
        Date date6 = c2.getTime();
        c2.set(1900, 4, 31, 0, 0, 0);
        Date date7 = c2.getTime();
        c2.set(1900, 1, 1, 0, 0, 0);
        Date date8 = c2.getTime();
        c2.set(1900, 0, 31, 0, 0, 0);
        Date date9 = c2.getTime();
        c2.set(1900, 2, 1, 0, 0, 0);
        Date date10 = c2.getTime();
        c2.set(1900, 1, 27, 0, 0, 0);
        Date date11 = c2.getTime();
        c2.set(1900, 1, 28, 0, 0, 0);
        Date date12 = c2.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm:ss.SSS");
        Label l2 = new Label(0, 0, "All dates are " + sdf.format(date), (CellFormat)wrappedText);
        s2.addCell(l2);
        l2 = new Label(0, 1, "Built in formats", (CellFormat)wrappedText);
        s2.addCell(l2);
        l2 = new Label(2, 1, "Custom formats");
        s2.addCell(l2);
        WritableCellFormat cf1 = new WritableCellFormat(DateFormats.FORMAT1);
        DateTime dt = new DateTime(0, 2, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT2);
        dt = new DateTime(0, 3, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT3);
        dt = new DateTime(0, 4, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT4);
        dt = new DateTime(0, 5, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT5);
        dt = new DateTime(0, 6, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT6);
        dt = new DateTime(0, 7, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT7);
        dt = new DateTime(0, 8, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT8);
        dt = new DateTime(0, 9, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(0, 10, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT10);
        dt = new DateTime(0, 11, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT11);
        dt = new DateTime(0, 12, date, (CellFormat)cf1);
        s2.addCell(dt);
        cf1 = new WritableCellFormat(DateFormats.FORMAT12);
        dt = new DateTime(0, 13, date, (CellFormat)cf1);
        s2.addCell(dt);
        DateFormat df = new DateFormat("dd MM yyyy");
        cf1 = new WritableCellFormat(df);
        l2 = new Label(2, 2, "dd MM yyyy");
        s2.addCell(l2);
        dt = new DateTime(3, 2, date, (CellFormat)cf1);
        s2.addCell(dt);
        df = new DateFormat("dd MMM yyyy");
        cf1 = new WritableCellFormat(df);
        l2 = new Label(2, 3, "dd MMM yyyy");
        s2.addCell(l2);
        dt = new DateTime(3, 3, date, (CellFormat)cf1);
        s2.addCell(dt);
        df = new DateFormat("hh:mm");
        cf1 = new WritableCellFormat(df);
        l2 = new Label(2, 4, "hh:mm");
        s2.addCell(l2);
        dt = new DateTime(3, 4, date, (CellFormat)cf1);
        s2.addCell(dt);
        df = new DateFormat("hh:mm:ss");
        cf1 = new WritableCellFormat(df);
        l2 = new Label(2, 5, "hh:mm:ss");
        s2.addCell(l2);
        dt = new DateTime(3, 5, date, (CellFormat)cf1);
        s2.addCell(dt);
        df = new DateFormat("H:mm:ss a");
        cf1 = new WritableCellFormat(df);
        l2 = new Label(2, 5, "H:mm:ss a");
        s2.addCell(l2);
        dt = new DateTime(3, 5, date, (CellFormat)cf1);
        s2.addCell(dt);
        df = new DateFormat("mm:ss.SSS");
        cf1 = new WritableCellFormat(df);
        l2 = new Label(2, 6, "mm:ss.SSS");
        s2.addCell(l2);
        dt = new DateTime(3, 6, date, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(0, 16, "Zero date " + sdf.format(date2), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(0, 17, date2, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 16, "Zero date + 1 " + sdf.format(date5), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 17, date5, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 19, sdf.format(date6), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 20, date6, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 22, sdf.format(date7), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 23, date7, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 25, sdf.format(date8), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 26, date8, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 28, sdf.format(date9), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 29, date9, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 28, sdf.format(date9), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 29, date9, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 31, sdf.format(date10), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 32, date10, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 34, sdf.format(date11), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 35, date11, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(3, 37, sdf.format(date12), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(3, 38, date12, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(0, 19, "Zero UTC date " + sdf.format(date3), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(0, 20, date3, (CellFormat)cf1);
        s2.addCell(dt);
        l2 = new Label(0, 22, "Armistice date " + sdf.format(date4), (CellFormat)wrappedText);
        s2.addCell(l2);
        cf1 = new WritableCellFormat(DateFormats.FORMAT9);
        dt = new DateTime(0, 23, date4, (CellFormat)cf1);
        s2.addCell(dt);
    }

    private void writeLabelFormatSheet(WritableSheet s1) throws WriteException {
        Label l2;
        s1.setColumnView(0, 60);
        Label lr = new Label(0, 0, "Arial Fonts");
        s1.addCell(lr);
        lr = new Label(1, 0, "10pt");
        s1.addCell(lr);
        lr = new Label(2, 0, "Normal");
        s1.addCell(lr);
        lr = new Label(3, 0, "12pt");
        s1.addCell(lr);
        WritableFont arial12pt = new WritableFont(WritableFont.ARIAL, 12);
        WritableCellFormat arial12format = new WritableCellFormat(arial12pt);
        arial12format.setWrap(true);
        lr = new Label(4, 0, "Normal", (CellFormat)arial12format);
        s1.addCell(lr);
        WritableFont arial10ptBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        WritableCellFormat arial10BoldFormat = new WritableCellFormat(arial10ptBold);
        lr = new Label(2, 2, "BOLD", (CellFormat)arial10BoldFormat);
        s1.addCell(lr);
        WritableFont arial12ptBold = new WritableFont(WritableFont.ARIAL, 12, WritableFont.BOLD);
        WritableCellFormat arial12BoldFormat = new WritableCellFormat(arial12ptBold);
        lr = new Label(4, 2, "BOLD", (CellFormat)arial12BoldFormat);
        s1.addCell(lr);
        WritableFont arial10ptItalic = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, true);
        WritableCellFormat arial10ItalicFormat = new WritableCellFormat(arial10ptItalic);
        lr = new Label(2, 4, "Italic", (CellFormat)arial10ItalicFormat);
        s1.addCell(lr);
        WritableFont arial12ptItalic = new WritableFont(WritableFont.ARIAL, 12, WritableFont.NO_BOLD, true);
        WritableCellFormat arial12ptItalicFormat = new WritableCellFormat(arial12ptItalic);
        lr = new Label(4, 4, "Italic", (CellFormat)arial12ptItalicFormat);
        s1.addCell(lr);
        WritableFont times10pt = new WritableFont(WritableFont.TIMES, 10);
        WritableCellFormat times10format = new WritableCellFormat(times10pt);
        lr = new Label(0, 7, "Times Fonts", (CellFormat)times10format);
        s1.addCell(lr);
        lr = new Label(1, 7, "10pt", (CellFormat)times10format);
        s1.addCell(lr);
        lr = new Label(2, 7, "Normal", (CellFormat)times10format);
        s1.addCell(lr);
        lr = new Label(3, 7, "12pt", (CellFormat)times10format);
        s1.addCell(lr);
        WritableFont times12pt = new WritableFont(WritableFont.TIMES, 12);
        WritableCellFormat times12format = new WritableCellFormat(times12pt);
        lr = new Label(4, 7, "Normal", (CellFormat)times12format);
        s1.addCell(lr);
        WritableFont times10ptBold = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD);
        WritableCellFormat times10BoldFormat = new WritableCellFormat(times10ptBold);
        lr = new Label(2, 9, "BOLD", (CellFormat)times10BoldFormat);
        s1.addCell(lr);
        WritableFont times12ptBold = new WritableFont(WritableFont.TIMES, 12, WritableFont.BOLD);
        WritableCellFormat times12BoldFormat = new WritableCellFormat(times12ptBold);
        lr = new Label(4, 9, "BOLD", (CellFormat)times12BoldFormat);
        s1.addCell(lr);
        s1.setColumnView(6, 22);
        s1.setColumnView(7, 22);
        s1.setColumnView(8, 22);
        s1.setColumnView(9, 22);
        lr = new Label(0, 11, "Underlining");
        s1.addCell(lr);
        WritableFont arial10ptUnderline = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.SINGLE);
        WritableCellFormat arialUnderline = new WritableCellFormat(arial10ptUnderline);
        lr = new Label(6, 11, "Underline", (CellFormat)arialUnderline);
        s1.addCell(lr);
        WritableFont arial10ptDoubleUnderline = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.DOUBLE);
        WritableCellFormat arialDoubleUnderline = new WritableCellFormat(arial10ptDoubleUnderline);
        lr = new Label(7, 11, "Double Underline", (CellFormat)arialDoubleUnderline);
        s1.addCell(lr);
        WritableFont arial10ptSingleAcc = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.SINGLE_ACCOUNTING);
        WritableCellFormat arialSingleAcc = new WritableCellFormat(arial10ptSingleAcc);
        lr = new Label(8, 11, "Single Accounting Underline", (CellFormat)arialSingleAcc);
        s1.addCell(lr);
        WritableFont arial10ptDoubleAcc = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.DOUBLE_ACCOUNTING);
        WritableCellFormat arialDoubleAcc = new WritableCellFormat(arial10ptDoubleAcc);
        lr = new Label(9, 11, "Double Accounting Underline", (CellFormat)arialDoubleAcc);
        s1.addCell(lr);
        WritableFont times14ptBoldUnderline = new WritableFont(WritableFont.TIMES, 14, WritableFont.BOLD, false, UnderlineStyle.SINGLE);
        WritableCellFormat timesBoldUnderline = new WritableCellFormat(times14ptBoldUnderline);
        lr = new Label(6, 12, "Times 14 Bold Underline", (CellFormat)timesBoldUnderline);
        s1.addCell(lr);
        WritableFont arial18ptBoldItalicUnderline = new WritableFont(WritableFont.ARIAL, 18, WritableFont.BOLD, true, UnderlineStyle.SINGLE);
        WritableCellFormat arialBoldItalicUnderline = new WritableCellFormat(arial18ptBoldItalicUnderline);
        lr = new Label(6, 13, "Arial 18 Bold Italic Underline", (CellFormat)arialBoldItalicUnderline);
        s1.addCell(lr);
        lr = new Label(0, 15, "Script styles");
        s1.addCell(lr);
        WritableFont superscript = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.SUPERSCRIPT);
        WritableCellFormat superscriptFormat = new WritableCellFormat(superscript);
        lr = new Label(1, 15, "superscript", (CellFormat)superscriptFormat);
        s1.addCell(lr);
        WritableFont subscript = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK, ScriptStyle.SUBSCRIPT);
        WritableCellFormat subscriptFormat = new WritableCellFormat(subscript);
        lr = new Label(2, 15, "subscript", (CellFormat)subscriptFormat);
        s1.addCell(lr);
        lr = new Label(0, 17, "Colours");
        s1.addCell(lr);
        WritableFont red = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.RED);
        WritableCellFormat redFormat = new WritableCellFormat(red);
        lr = new Label(2, 17, "Red", (CellFormat)redFormat);
        s1.addCell(lr);
        WritableFont blue = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE);
        WritableCellFormat blueFormat = new WritableCellFormat(blue);
        lr = new Label(2, 18, "Blue", (CellFormat)blueFormat);
        s1.addCell(lr);
        WritableFont lime = new WritableFont(WritableFont.ARIAL);
        lime.setColour(Colour.LIME);
        WritableCellFormat limeFormat = new WritableCellFormat(lime);
        limeFormat.setWrap(true);
        lr = new Label(4, 18, "Modified palette - was lime, now red", (CellFormat)limeFormat);
        s1.addCell(lr);
        WritableCellFormat greyBackground = new WritableCellFormat();
        greyBackground.setWrap(true);
        greyBackground.setBackground(Colour.GRAY_50);
        lr = new Label(2, 19, "Grey background", (CellFormat)greyBackground);
        s1.addCell(lr);
        WritableFont yellow = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.YELLOW);
        WritableCellFormat yellowOnBlue = new WritableCellFormat(yellow);
        yellowOnBlue.setWrap(true);
        yellowOnBlue.setBackground(Colour.BLUE);
        lr = new Label(2, 20, "Blue background, yellow foreground", (CellFormat)yellowOnBlue);
        s1.addCell(lr);
        lr = new Label(0, 22, "Null label");
        s1.addCell(lr);
        lr = new Label(2, 22, null);
        s1.addCell(lr);
        lr = new Label(0, 24, "A very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nA very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nA very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nA very long label, more than 255 characters\nRejoice O shores\nSing O bells\nBut I with mournful tread\nWalk the deck my captain lies\nFallen cold and dead\nSummer surprised, coming over the Starnbergersee\nWith a shower of rain. We stopped in the Colonnade\nAnd sat and drank coffee an talked for an hour\n", (CellFormat)arial12format);
        s1.addCell(lr);
        WritableCellFormat vertical = new WritableCellFormat();
        vertical.setOrientation(Orientation.VERTICAL);
        lr = new Label(0, 26, "Vertical orientation", (CellFormat)vertical);
        s1.addCell(lr);
        WritableCellFormat plus_90 = new WritableCellFormat();
        plus_90.setOrientation(Orientation.PLUS_90);
        lr = new Label(1, 26, "Plus 90", (CellFormat)plus_90);
        s1.addCell(lr);
        WritableCellFormat minus_90 = new WritableCellFormat();
        minus_90.setOrientation(Orientation.MINUS_90);
        lr = new Label(2, 26, "Minus 90", (CellFormat)minus_90);
        s1.addCell(lr);
        lr = new Label(0, 28, "Modified row height");
        s1.addCell(lr);
        s1.setRowView(28, 24);
        lr = new Label(0, 29, "Collapsed row");
        s1.addCell(lr);
        s1.setRowView(29, true);
        try {
            l2 = new Label(0, 30, "Hyperlink to home page");
            s1.addCell(l2);
            URL url = new URL("http://www.andykhan.com/jexcelapi");
            WritableHyperlink wh = new WritableHyperlink(0, 30, 8, 31, url);
            s1.addHyperlink(wh);
            WritableHyperlink wh2 = new WritableHyperlink(7, 30, 9, 31, url);
            s1.addHyperlink(wh2);
            l2 = new Label(4, 2, "File hyperlink to documentation");
            s1.addCell(l2);
            File file = new File("../jexcelapi/docs/index.html");
            wh = new WritableHyperlink(0, 32, 8, 32, file);
            s1.addHyperlink(wh);
            wh = new WritableHyperlink(0, 34, 8, 34, "Link to another cell", s1, 0, 180, 1, 181);
            s1.addHyperlink(wh);
        }
        catch (MalformedURLException e2) {
            System.err.println(e2.toString());
        }
        l2 = new Label(5, 35, "Merged cells", (CellFormat)timesBoldUnderline);
        s1.mergeCells(5, 35, 8, 37);
        s1.addCell(l2);
        l2 = new Label(5, 38, "More merged cells");
        s1.addCell(l2);
        Range r2 = s1.mergeCells(5, 38, 8, 41);
        s1.insertRow(40);
        s1.removeRow(39);
        s1.unmergeCells(r2);
        WritableCellFormat wcf = new WritableCellFormat();
        wcf.setAlignment(Alignment.CENTRE);
        l2 = new Label(5, 42, "Centred across merged cells", (CellFormat)wcf);
        s1.addCell(l2);
        s1.mergeCells(5, 42, 10, 42);
        wcf = new WritableCellFormat();
        wcf.setBorder(Border.ALL, BorderLineStyle.THIN);
        wcf.setBackground(Colour.GRAY_25);
        l2 = new Label(3, 44, "Merged with border", (CellFormat)wcf);
        s1.addCell(l2);
        s1.mergeCells(3, 44, 4, 46);
        WritableFont courier10ptFont = new WritableFont(WritableFont.COURIER, 10);
        WritableCellFormat courier10pt = new WritableCellFormat(courier10ptFont);
        l2 = new Label(0, 49, "Courier fonts", (CellFormat)courier10pt);
        s1.addCell(l2);
        WritableFont tahoma12ptFont = new WritableFont(WritableFont.TAHOMA, 12);
        WritableCellFormat tahoma12pt = new WritableCellFormat(tahoma12ptFont);
        l2 = new Label(0, 50, "Tahoma fonts", (CellFormat)tahoma12pt);
        s1.addCell(l2);
        WritableFont.FontName wingdingsFont = WritableFont.createFont("Wingdings 2");
        WritableFont wingdings210ptFont = new WritableFont(wingdingsFont, 10);
        WritableCellFormat wingdings210pt = new WritableCellFormat(wingdings210ptFont);
        l2 = new Label(0, 51, "Bespoke Windgdings 2", (CellFormat)wingdings210pt);
        s1.addCell(l2);
        WritableCellFormat shrinkToFit = new WritableCellFormat(times12pt);
        shrinkToFit.setShrinkToFit(true);
        l2 = new Label(3, 53, "Shrunk to fit", (CellFormat)shrinkToFit);
        s1.addCell(l2);
        l2 = new Label(3, 55, "Some long wrapped text in a mergec cell", (CellFormat)arial12format);
        s1.addCell(l2);
        s1.mergeCells(3, 55, 4, 55);
    }

    private void writeBordersSheet(WritableSheet s2) throws WriteException {
        s2.getSettings().setProtected(true);
        s2.setColumnView(1, 15);
        s2.setColumnView(2, 15);
        s2.setColumnView(4, 15);
        WritableCellFormat thickLeft = new WritableCellFormat();
        thickLeft.setBorder(Border.LEFT, BorderLineStyle.THICK);
        Label lr = new Label(1, 0, "Thick left", (CellFormat)thickLeft);
        s2.addCell(lr);
        WritableCellFormat dashedRight = new WritableCellFormat();
        dashedRight.setBorder(Border.RIGHT, BorderLineStyle.DASHED);
        lr = new Label(2, 0, "Dashed right", (CellFormat)dashedRight);
        s2.addCell(lr);
        WritableCellFormat doubleTop = new WritableCellFormat();
        doubleTop.setBorder(Border.TOP, BorderLineStyle.DOUBLE);
        lr = new Label(1, 2, "Double top", (CellFormat)doubleTop);
        s2.addCell(lr);
        WritableCellFormat hairBottom = new WritableCellFormat();
        hairBottom.setBorder(Border.BOTTOM, BorderLineStyle.HAIR);
        lr = new Label(2, 2, "Hair bottom", (CellFormat)hairBottom);
        s2.addCell(lr);
        WritableCellFormat allThin = new WritableCellFormat();
        allThin.setBorder(Border.ALL, BorderLineStyle.THIN);
        lr = new Label(4, 2, "All thin", (CellFormat)allThin);
        s2.addCell(lr);
        WritableCellFormat twoBorders = new WritableCellFormat();
        twoBorders.setBorder(Border.TOP, BorderLineStyle.THICK);
        twoBorders.setBorder(Border.LEFT, BorderLineStyle.THICK);
        lr = new Label(6, 2, "Two borders", (CellFormat)twoBorders);
        s2.addCell(lr);
        lr = new Label(20, 20, "Dislocated cell - after a page break");
        s2.addCell(lr);
        s2.getSettings().setPaperSize(PaperSize.A3);
        s2.getSettings().setOrientation(PageOrientation.LANDSCAPE);
        s2.getSettings().setHeaderMargin(2.0);
        s2.getSettings().setFooterMargin(2.0);
        s2.getSettings().setTopMargin(3.0);
        s2.getSettings().setBottomMargin(3.0);
        s2.setHeader(null, "Page Header", null);
        s2.setFooter(null, null, "page &P");
        s2.addRowPageBreak(18);
        s2.insertRow(17);
        s2.insertRow(17);
        s2.removeRow(17);
        s2.addRowPageBreak(30);
        lr = new Label(10, 1, "Hidden column");
        s2.addCell(lr);
        lr = new Label(3, 8, "Hidden row");
        s2.addCell(lr);
        s2.setRowView(8, true);
    }

    private void writeLabelsSheet(WritableSheet ws) throws WriteException {
        ws.getSettings().setProtected(true);
        ws.getSettings().setPassword("jxl");
        ws.getSettings().setVerticalFreeze(5);
        WritableFont wf = new WritableFont(WritableFont.ARIAL, 12);
        wf.setItalic(true);
        WritableCellFormat wcf = new WritableCellFormat(wf);
        CellView cv = new CellView();
        cv.setDimension(25);
        cv.setFormat(wcf);
        ws.setColumnView(0, cv);
        ws.setColumnView(1, 15);
        for (int i2 = 0; i2 < 61; ++i2) {
            Label l1 = new Label(0, i2, "Common Label");
            Label l2 = new Label(1, i2, "Distinct label number " + i2);
            ws.addCell(l1);
            ws.addCell(l2);
        }
        Label l3 = new Label(0, 61, "Common Label", (CellFormat)wcf);
        Label l4 = new Label(1, 61, "1-1234567890", (CellFormat)wcf);
        Label l5 = new Label(2, 61, "2-1234567890", (CellFormat)wcf);
        ws.addCell(l3);
        ws.addCell(l4);
        ws.addCell(l5);
        for (int i3 = 62; i3 < 200; ++i3) {
            Label l1 = new Label(0, i3, "Common Label");
            Label l2 = new Label(1, i3, "Distinct label number " + i3);
            ws.addCell(l1);
            ws.addCell(l2);
        }
        wf = new WritableFont(WritableFont.TIMES, 10, WritableFont.BOLD);
        wf.setColour(Colour.RED);
        wcf = new WritableCellFormat(wf);
        wcf.setWrap(true);
        Label l2 = new Label(0, 205, "Different format", (CellFormat)wcf);
        ws.addCell(l2);
    }

    private void writeFormulaSheet(WritableSheet ws) throws WriteException {
        Number nc = new Number(0, 0, 15.0);
        ws.addCell(nc);
        nc = new Number(0, 1, 16.0);
        ws.addCell(nc);
        nc = new Number(0, 2, 10.0);
        ws.addCell(nc);
        nc = new Number(0, 3, 12.0);
        ws.addCell(nc);
        ws.setColumnView(2, 20);
        WritableCellFormat wcf = new WritableCellFormat();
        wcf.setAlignment(Alignment.RIGHT);
        wcf.setWrap(true);
        CellView cv = new CellView();
        cv.setDimension(25);
        cv.setFormat(wcf);
        ws.setColumnView(3, cv);
        Formula f2 = null;
        Label l2 = null;
        f2 = new Formula(2, 0, "A1+A2");
        ws.addCell(f2);
        l2 = new Label(3, 0, "a1+a2");
        ws.addCell(l2);
        f2 = new Formula(2, 1, "A2 * 3");
        ws.addCell(f2);
        l2 = new Label(3, 1, "A2 * 3");
        ws.addCell(l2);
        f2 = new Formula(2, 2, "A2+A1/2.5");
        ws.addCell(f2);
        l2 = new Label(3, 2, "A2+A1/2.5");
        ws.addCell(l2);
        f2 = new Formula(2, 3, "3+(a1+a2)/2.5");
        ws.addCell(f2);
        l2 = new Label(3, 3, "3+(a1+a2)/2.5");
        ws.addCell(l2);
        f2 = new Formula(2, 4, "(a1+a2)/2.5");
        ws.addCell(f2);
        l2 = new Label(3, 4, "(a1+a2)/2.5");
        ws.addCell(l2);
        f2 = new Formula(2, 5, "15+((a1+a2)/2.5)*17");
        ws.addCell(f2);
        l2 = new Label(3, 5, "15+((a1+a2)/2.5)*17");
        ws.addCell(l2);
        f2 = new Formula(2, 6, "SUM(a1:a4)");
        ws.addCell(f2);
        l2 = new Label(3, 6, "SUM(a1:a4)");
        ws.addCell(l2);
        f2 = new Formula(2, 7, "SUM(a1:a4)/4");
        ws.addCell(f2);
        l2 = new Label(3, 7, "SUM(a1:a4)/4");
        ws.addCell(l2);
        f2 = new Formula(2, 8, "AVERAGE(A1:A4)");
        ws.addCell(f2);
        l2 = new Label(3, 8, "AVERAGE(a1:a4)");
        ws.addCell(l2);
        f2 = new Formula(2, 9, "MIN(5,4,1,2,3)");
        ws.addCell(f2);
        l2 = new Label(3, 9, "MIN(5,4,1,2,3)");
        ws.addCell(l2);
        f2 = new Formula(2, 10, "ROUND(3.14159265, 3)");
        ws.addCell(f2);
        l2 = new Label(3, 10, "ROUND(3.14159265, 3)");
        ws.addCell(l2);
        f2 = new Formula(2, 11, "MAX(SUM(A1:A2), A1*A2, POWER(A1, 2))");
        ws.addCell(f2);
        l2 = new Label(3, 11, "MAX(SUM(A1:A2), A1*A2, POWER(A1, 2))");
        ws.addCell(l2);
        f2 = new Formula(2, 12, "IF(A2>A1, \"A2 bigger\", \"A1 bigger\")");
        ws.addCell(f2);
        l2 = new Label(3, 12, "IF(A2>A1, \"A2 bigger\", \"A1 bigger\")");
        ws.addCell(l2);
        f2 = new Formula(2, 13, "IF(A2<=A1, \"A2 smaller\", \"A1 smaller\")");
        ws.addCell(f2);
        l2 = new Label(3, 13, "IF(A2<=A1, \"A2 smaller\", \"A1 smaller\")");
        ws.addCell(l2);
        f2 = new Formula(2, 14, "IF(A3<=10, \"<= 10\")");
        ws.addCell(f2);
        l2 = new Label(3, 14, "IF(A3<=10, \"<= 10\")");
        ws.addCell(l2);
        f2 = new Formula(2, 15, "SUM(1,2,3,4,5)");
        ws.addCell(f2);
        l2 = new Label(3, 15, "SUM(1,2,3,4,5)");
        ws.addCell(l2);
        f2 = new Formula(2, 16, "HYPERLINK(\"http://www.andykhan.com/jexcelapi\", \"JExcelApi Home Page\")");
        ws.addCell(f2);
        l2 = new Label(3, 16, "HYPERLINK(\"http://www.andykhan.com/jexcelapi\", \"JExcelApi Home Page\")");
        ws.addCell(l2);
        f2 = new Formula(2, 17, "3*4+5");
        ws.addCell(f2);
        l2 = new Label(3, 17, "3*4+5");
        ws.addCell(l2);
        f2 = new Formula(2, 18, "\"Plain text formula\"");
        ws.addCell(f2);
        l2 = new Label(3, 18, "Plain text formula");
        ws.addCell(l2);
        f2 = new Formula(2, 19, "SUM(a1,a2,-a3,a4)");
        ws.addCell(f2);
        l2 = new Label(3, 19, "SUM(a1,a2,-a3,a4)");
        ws.addCell(l2);
        f2 = new Formula(2, 20, "2*-(a1+a2)");
        ws.addCell(f2);
        l2 = new Label(3, 20, "2*-(a1+a2)");
        ws.addCell(l2);
        f2 = new Formula(2, 21, "Number Formats!B1/2");
        ws.addCell(f2);
        l2 = new Label(3, 21, "Number Formats!B1/2");
        ws.addCell(l2);
        f2 = new Formula(2, 22, "IF(F22=0, 0, F21/F22)");
        ws.addCell(f2);
        l2 = new Label(3, 22, "IF(F22=0, 0, F21/F22)");
        ws.addCell(l2);
        f2 = new Formula(2, 22, "RAND()");
        ws.addCell(f2);
        l2 = new Label(3, 22, "RAND()");
        ws.addCell(l2);
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        buf.append(this.workbook.getSheet(0).getName());
        buf.append("'!");
        buf.append(CellReferenceHelper.getCellReference(9, 18));
        buf.append("*25");
        f2 = new Formula(2, 23, buf.toString());
        ws.addCell(f2);
        l2 = new Label(3, 23, buf.toString());
        ws.addCell(l2);
        wcf = new WritableCellFormat(DateFormats.DEFAULT);
        f2 = new Formula(2, 24, "NOW()", (CellFormat)wcf);
        ws.addCell(f2);
        l2 = new Label(3, 24, "NOW()");
        ws.addCell(l2);
        f2 = new Formula(2, 25, "$A$2+A3");
        ws.addCell(f2);
        l2 = new Label(3, 25, "$A$2+A3");
        ws.addCell(l2);
        f2 = new Formula(2, 26, "IF(COUNT(A1:A9,B1:B9)=0,\"\",COUNT(A1:A9,B1:B9))");
        ws.addCell(f2);
        l2 = new Label(3, 26, "IF(COUNT(A1:A9,B1:B9)=0,\"\",COUNT(A1:A9,B1:B9))");
        ws.addCell(l2);
        f2 = new Formula(2, 27, "SUM(A1,A2,A3,A4)");
        ws.addCell(f2);
        l2 = new Label(3, 27, "SUM(A1,A2,A3,A4)");
        ws.addCell(l2);
    }

    private void writeImageSheet(WritableSheet ws) throws WriteException {
        Label l2 = new Label(0, 0, "Weald & Downland Open Air Museum, Sussex");
        ws.addCell(l2);
        WritableImage wi = new WritableImage(0.0, 3.0, 5.0, 7.0, new File("resources/wealdanddownland.png"));
        ws.addImage(wi);
        l2 = new Label(0, 12, "Merchant Adventurers Hall, York");
        ws.addCell(l2);
        wi = new WritableImage(5.0, 12.0, 4.0, 10.0, new File("resources/merchantadventurers.png"));
        ws.addImage(wi);
    }
}

