/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.FormatRecord;
import jxl.biff.FormattingRecords;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.PaletteRecord;
import jxl.biff.RangeImpl;
import jxl.biff.RecordData;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.MsoDrawingGroupRecord;
import jxl.biff.formula.ExternalSheet;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BiffException;
import jxl.read.biff.BoundsheetRecord;
import jxl.read.biff.ExternalSheetRecord;
import jxl.read.biff.File;
import jxl.read.biff.NameRecord;
import jxl.read.biff.NineteenFourRecord;
import jxl.read.biff.PasswordException;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.Record;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.SupbookRecord;

public class WorkbookParser
extends Workbook
implements ExternalSheet,
WorkbookMethods {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$WorkbookParser == null ? (class$jxl$read$biff$WorkbookParser = WorkbookParser.class$("jxl.read.biff.WorkbookParser")) : class$jxl$read$biff$WorkbookParser);
    private File excelFile;
    private int bofs;
    private boolean nineteenFour;
    private SSTRecord sharedStrings;
    private ArrayList boundsheets;
    private FormattingRecords formattingRecords;
    private Fonts fonts;
    private ArrayList sheets;
    private SheetImpl lastSheet;
    private int lastSheetIndex;
    private HashMap namedRecords;
    private ArrayList nameTable;
    private ExternalSheetRecord externSheet;
    private ArrayList supbooks;
    private BOFRecord workbookBof;
    private MsoDrawingGroupRecord msoDrawingGroup;
    private boolean wbProtected;
    private WorkbookSettings settings;
    private DrawingGroup drawingGroup;
    static /* synthetic */ Class class$jxl$read$biff$WorkbookParser;

    public WorkbookParser(File f2, WorkbookSettings s2) {
        this.excelFile = f2;
        this.boundsheets = new ArrayList(10);
        this.fonts = new Fonts();
        this.formattingRecords = new FormattingRecords(this.fonts);
        this.sheets = new ArrayList(10);
        this.supbooks = new ArrayList(10);
        this.namedRecords = new HashMap();
        this.lastSheetIndex = -1;
        this.wbProtected = false;
        this.settings = s2;
    }

    public Sheet[] getSheets() {
        Sheet[] sheetArray = new Sheet[this.getNumberOfSheets()];
        for (int i2 = 0; i2 < this.getNumberOfSheets(); ++i2) {
            sheetArray[i2] = (Sheet)this.sheets.get(i2);
        }
        return sheetArray;
    }

    public Sheet getReadSheet(int index) {
        return this.getSheet(index);
    }

    public Sheet getSheet(int index) {
        if (this.lastSheet != null && this.lastSheetIndex == index) {
            return this.lastSheet;
        }
        if (this.lastSheet != null) {
            this.lastSheet.clear();
            if (!this.settings.getGCDisabled()) {
                System.gc();
            }
        }
        this.lastSheet = (SheetImpl)this.sheets.get(index);
        this.lastSheetIndex = index;
        this.lastSheet.readSheet();
        return this.lastSheet;
    }

    public Sheet getSheet(String name) {
        int pos = 0;
        boolean found = false;
        Iterator i2 = this.boundsheets.iterator();
        BoundsheetRecord br = null;
        while (i2.hasNext() && !found) {
            br = (BoundsheetRecord)i2.next();
            if (br.getName().equals(name)) {
                found = true;
                continue;
            }
            ++pos;
        }
        return found ? this.getSheet(pos) : null;
    }

    public int getExternalSheetIndex(int index) {
        if (this.workbookBof.isBiff7()) {
            return index;
        }
        Assert.verify(this.externSheet != null);
        int firstTab = this.externSheet.getFirstTabIndex(index);
        int lastTab = this.externSheet.getLastTabIndex(index);
        Assert.verify(firstTab == lastTab);
        return firstTab;
    }

    public String getExternalSheetName(int index) {
        int lastTab;
        if (this.workbookBof.isBiff7()) {
            BoundsheetRecord br = (BoundsheetRecord)this.boundsheets.get(index);
            return br.getName();
        }
        int supbookIndex = this.externSheet.getSupbookIndex(index);
        SupbookRecord sr = (SupbookRecord)this.supbooks.get(supbookIndex);
        int firstTab = this.externSheet.getFirstTabIndex(index);
        Assert.verify(firstTab == (lastTab = this.externSheet.getLastTabIndex(index)));
        if (sr.getType() == SupbookRecord.INTERNAL) {
            BoundsheetRecord br = (BoundsheetRecord)this.boundsheets.get(firstTab);
            return br.getName();
        }
        if (sr.getType() == SupbookRecord.EXTERNAL) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(sr.getFileName());
            sb.append(']');
            sb.append(sr.getSheetName(firstTab));
            return sb.toString();
        }
        return "[UNKNOWN]";
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() {
        if (this.lastSheet != null) {
            this.lastSheet.clear();
        }
        this.excelFile.clear();
        if (!this.settings.getGCDisabled()) {
            System.gc();
        }
    }

    final void addSheet(Sheet s2) {
        this.sheets.add(s2);
    }

    protected void parse() throws BiffException, PasswordException {
        BOFRecord bof;
        Record r2 = null;
        this.workbookBof = bof = new BOFRecord(this.excelFile.next());
        ++this.bofs;
        if (!bof.isBiff8() && !bof.isBiff7()) {
            throw new BiffException(BiffException.unrecognizedBiffVersion);
        }
        if (!bof.isWorkbookGlobals()) {
            throw new BiffException(BiffException.expectedGlobals);
        }
        ArrayList<Record> continueRecords = new ArrayList<Record>();
        this.nameTable = new ArrayList();
        while (this.bofs == 1) {
            WritableRecordData fr;
            RecordData nr;
            Record nextrec;
            r2 = this.excelFile.next();
            if (r2.getType() == Type.SST) {
                continueRecords.clear();
                nextrec = this.excelFile.peek();
                while (nextrec.getType() == Type.CONTINUE) {
                    continueRecords.add(this.excelFile.next());
                    nextrec = this.excelFile.peek();
                }
                Object[] rec = continueRecords.toArray();
                Record[] records = new Record[rec.length];
                System.arraycopy(rec, 0, records, 0, rec.length);
                this.sharedStrings = new SSTRecord(r2, records, this.settings);
                continue;
            }
            if (r2.getType() == Type.FILEPASS) {
                throw new PasswordException();
            }
            if (r2.getType() == Type.NAME) {
                nr = null;
                nr = bof.isBiff8() ? new NameRecord(r2, this.settings, this.namedRecords.size()) : new NameRecord(r2, this.settings, this.namedRecords.size(), NameRecord.biff7);
                this.namedRecords.put(((NameRecord)nr).getName(), nr);
                this.nameTable.add(nr);
                continue;
            }
            if (r2.getType() == Type.FONT) {
                fr = null;
                fr = bof.isBiff8() ? new FontRecord(r2, this.settings) : new FontRecord(r2, this.settings, FontRecord.biff7);
                this.fonts.addFont((FontRecord)fr);
                continue;
            }
            if (r2.getType() == Type.PALETTE) {
                PaletteRecord palette = new PaletteRecord(r2);
                this.formattingRecords.setPalette(palette);
                continue;
            }
            if (r2.getType() == Type.NINETEENFOUR) {
                nr = new NineteenFourRecord(r2);
                this.nineteenFour = ((NineteenFourRecord)nr).is1904();
                continue;
            }
            if (r2.getType() == Type.FORMAT) {
                fr = null;
                fr = bof.isBiff8() ? new FormatRecord(r2, this.settings, FormatRecord.biff8) : new FormatRecord(r2, this.settings, FormatRecord.biff7);
                try {
                    this.formattingRecords.addFormat((DisplayFormat)((Object)fr));
                }
                catch (NumFormatRecordsException e2) {
                    Assert.verify(false, e2.getMessage());
                }
                continue;
            }
            if (r2.getType() == Type.XF) {
                XFRecord xfr = null;
                xfr = bof.isBiff8() ? new XFRecord(r2, XFRecord.biff8) : new XFRecord(r2, XFRecord.biff7);
                try {
                    this.formattingRecords.addStyle(xfr);
                }
                catch (NumFormatRecordsException e3) {
                    Assert.verify(false, e3.getMessage());
                }
                continue;
            }
            if (r2.getType() == Type.BOUNDSHEET) {
                BoundsheetRecord br = null;
                br = bof.isBiff8() ? new BoundsheetRecord(r2) : new BoundsheetRecord(r2, BoundsheetRecord.biff7);
                if (!br.isSheet() && !br.isChart()) continue;
                this.boundsheets.add(br);
                continue;
            }
            if (r2.getType() == Type.EXTERNSHEET) {
                if (bof.isBiff8()) {
                    this.externSheet = new ExternalSheetRecord(r2, this.settings);
                    continue;
                }
                this.externSheet = new ExternalSheetRecord(r2, this.settings, ExternalSheetRecord.biff7);
                continue;
            }
            if (r2.getType() == Type.SUPBOOK) {
                SupbookRecord sr = new SupbookRecord(r2, this.settings);
                this.supbooks.add(sr);
                continue;
            }
            if (r2.getType() == Type.PROTECT) {
                ProtectRecord pr = new ProtectRecord(r2);
                this.wbProtected = pr.isProtected();
                continue;
            }
            if (r2.getType() == Type.MSODRAWINGGROUP) {
                this.msoDrawingGroup = new MsoDrawingGroupRecord(r2);
                if (this.drawingGroup == null) {
                    this.drawingGroup = new DrawingGroup(DrawingGroup.READ);
                }
                this.drawingGroup.add(this.msoDrawingGroup);
                nextrec = this.excelFile.peek();
                while (nextrec.getType() == Type.CONTINUE) {
                    this.drawingGroup.add(this.excelFile.next());
                    nextrec = this.excelFile.peek();
                }
                continue;
            }
            if (r2.getType() != Type.EOF) continue;
            --this.bofs;
        }
        bof = null;
        if (this.excelFile.hasNext() && (r2 = this.excelFile.next()).getType() == Type.BOF) {
            bof = new BOFRecord(r2);
        }
        while (bof != null && this.getNumberOfSheets() < this.boundsheets.size()) {
            BoundsheetRecord br;
            SheetImpl s2;
            if (!bof.isBiff8() && !bof.isBiff7()) {
                throw new BiffException(BiffException.unrecognizedBiffVersion);
            }
            if (bof.isWorksheet()) {
                s2 = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bof, this.workbookBof, this.nineteenFour, this);
                br = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
                s2.setName(br.getName());
                s2.setHidden(br.isHidden());
                this.addSheet(s2);
            } else if (bof.isChart()) {
                s2 = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bof, this.workbookBof, this.nineteenFour, this);
                br = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
                s2.setName(br.getName());
                s2.setHidden(br.isHidden());
                this.addSheet(s2);
            } else {
                logger.warn("BOF is unrecognized");
                while (this.excelFile.hasNext() && r2.getType() != Type.EOF) {
                    r2 = this.excelFile.next();
                }
            }
            bof = null;
            if (!this.excelFile.hasNext() || (r2 = this.excelFile.next()).getType() != Type.BOF) continue;
            bof = new BOFRecord(r2);
        }
    }

    public FormattingRecords getFormattingRecords() {
        return this.formattingRecords;
    }

    public ExternalSheetRecord getExternalSheetRecord() {
        return this.externSheet;
    }

    public MsoDrawingGroupRecord getMsoDrawingGroupRecord() {
        return this.msoDrawingGroup;
    }

    public SupbookRecord[] getSupbookRecords() {
        SupbookRecord[] sr = new SupbookRecord[this.supbooks.size()];
        for (int i2 = 0; i2 < sr.length; ++i2) {
            sr[i2] = (SupbookRecord)this.supbooks.get(i2);
        }
        return sr;
    }

    public NameRecord[] getNameRecords() {
        NameRecord[] na = new NameRecord[this.nameTable.size()];
        for (int i2 = 0; i2 < this.nameTable.size(); ++i2) {
            na[i2] = (NameRecord)this.nameTable.get(i2);
        }
        return na;
    }

    public Fonts getFonts() {
        return this.fonts;
    }

    public Cell findCellByName(String name) {
        NameRecord nr = (NameRecord)this.namedRecords.get(name);
        if (nr == null) {
            return null;
        }
        NameRecord.NameRange[] ranges = nr.getRanges();
        Sheet s2 = this.getSheet(ranges[0].getFirstSheet());
        Cell cell = s2.getCell(ranges[0].getFirstColumn(), ranges[0].getFirstRow());
        return cell;
    }

    public Range[] findByName(String name) {
        NameRecord nr = (NameRecord)this.namedRecords.get(name);
        if (nr == null) {
            return null;
        }
        NameRecord.NameRange[] ranges = nr.getRanges();
        Range[] cellRanges = new Range[ranges.length];
        for (int i2 = 0; i2 < ranges.length; ++i2) {
            cellRanges[i2] = new RangeImpl(this, this, ranges[i2].getFirstSheet(), ranges[i2].getFirstColumn(), ranges[i2].getFirstRow(), ranges[i2].getLastSheet(), ranges[i2].getLastColumn(), ranges[i2].getLastRow());
        }
        return cellRanges;
    }

    public BOFRecord getWorkbookBof() {
        return this.workbookBof;
    }

    public boolean isProtected() {
        return this.wbProtected;
    }

    public WorkbookSettings getSettings() {
        return this.settings;
    }

    public int getExternalSheetIndex(String sheetName) {
        return 0;
    }

    public String getName(int index) {
        Assert.verify(index >= 0 && index < this.nameTable.size());
        return ((NameRecord)this.nameTable.get(index)).getName();
    }

    public int getNameIndex(String name) {
        NameRecord nr = (NameRecord)this.namedRecords.get(name);
        return nr != null ? nr.getIndex() : 0;
    }

    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

