/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class SupbookRecord
extends WritableRecordData {
    private SupbookType type;
    private byte[] data;
    private int numSheets;
    private String fileName;
    private String[] sheetNames;
    public static final SupbookType INTERNAL = new SupbookType();
    public static final SupbookType EXTERNAL = new SupbookType();
    public static final SupbookType ADDIN = new SupbookType();
    public static final SupbookType LINK = new SupbookType();
    public static final SupbookType UNKNOWN = new SupbookType();

    public SupbookRecord(int sheets) {
        super(Type.SUPBOOK);
        this.numSheets = sheets;
        this.data = new byte[4];
        IntegerHelper.getTwoBytes(sheets, this.data, 0);
        this.data[2] = 1;
        this.data[3] = 4;
        this.type = INTERNAL;
    }

    public SupbookRecord(jxl.read.biff.SupbookRecord sr) {
        super(Type.SUPBOOK);
        if (sr.getType() == jxl.read.biff.SupbookRecord.INTERNAL) {
            this.initInternal(sr);
        } else if (sr.getType() == jxl.read.biff.SupbookRecord.EXTERNAL) {
            this.initExternal(sr);
        }
    }

    private void initInternal(jxl.read.biff.SupbookRecord sr) {
        this.numSheets = sr.getNumberOfSheets();
        this.data = new byte[4];
        IntegerHelper.getTwoBytes(this.numSheets, this.data, 0);
        this.data[2] = 1;
        this.data[3] = 4;
        this.type = INTERNAL;
    }

    private void initExternal(jxl.read.biff.SupbookRecord sr) {
        this.numSheets = sr.getNumberOfSheets();
        this.fileName = sr.getFileName();
        this.sheetNames = new String[this.numSheets];
        int totalSheetNameLength = 0;
        for (int i2 = 0; i2 < this.numSheets; ++i2) {
            this.sheetNames[i2] = sr.getSheetName(i2);
            totalSheetNameLength += this.sheetNames[i2].length();
        }
        int dataLength = 6 + this.fileName.length() + this.numSheets * 3 + totalSheetNameLength * 2;
        this.data = new byte[dataLength];
        IntegerHelper.getTwoBytes(this.numSheets, this.data, 0);
        int pos = 2;
        IntegerHelper.getTwoBytes(this.fileName.length() + 1, this.data, pos);
        this.data[pos + 2] = 0;
        this.data[pos + 3] = 1;
        StringHelper.getBytes(this.fileName, this.data, pos + 4);
        pos += 4 + this.fileName.length();
        for (int i3 = 0; i3 < this.sheetNames.length; ++i3) {
            IntegerHelper.getTwoBytes(this.sheetNames[i3].length(), this.data, pos);
            this.data[pos + 2] = 1;
            StringHelper.getUnicodeBytes(this.sheetNames[i3], this.data, pos + 3);
            pos += 3 + this.sheetNames[i3].length() * 2;
        }
        this.type = EXTERNAL;
    }

    public byte[] getData() {
        return this.data;
    }

    public SupbookType getType() {
        return this.type;
    }

    public int getNumberOfSheets() {
        return this.numSheets;
    }

    private static class SupbookType {
        private SupbookType() {
        }
    }
}

