/**
 * 顶部工具栏
 */

import { toast } from 'amis'
import cls from 'classnames'
import { observer } from 'mobx-react'
import React from 'react'

import { useRootStore } from '@/stores'

import { StyledHeader } from './styled'

export default observer((props) => {
  const { isEditMode, setMode } = useRootStore()

  const { history } = props

  return (
    <StyledHeader>
      <ul>
        {isEditMode ? (
          <>
            <li onClick={() => setMode('stage')}>预览</li>
            <li
              className={cls({ disabled: !history.hasPreFrame })}
              onClick={() => history.goBack()}
            >
              撤销
            </li>
            <li
              className={cls({ disabled: !history.hasNextFrame })}
              onClick={() => history.goNext()}
            >
              恢复撤销
            </li>
          </>
        ) : (
          <li onClick={() => setMode('edit')}>退出预览</li>
        )}
        <li onClick={() => toast.info('保存功能暂不可用')}>保存</li>
      </ul>
    </StyledHeader>
  )
})
