---
id: faq
title: 常见问题
---

### Ovine 与其他 Admin 框架的区别是什么？

Ovine 只是一种 Amis 框架的上层封装。 Amis 与其他各大 Admin 框架（或者 UI 框架）的区别就是 Ovine 与他们的区别。 请阅读 [Amis 是什么?](https://baidu.github.io/amis/docs/index)

### Ovine 与 Amis 的区别是什么？

- 项目类型不同
  - Amis 是一个提供最基本的 Json 渲染为组件的底层功能，是基础库。**非常强大**
  - Ovine 仅在上层封装了一些额外的功能，因此保留了 Amis 的所有功能。可理解为 Ovine 是 Amis 库的一个应用框架
- 打包工具不同
  - Amis 使用 Fis3 作为开发工具
  - Ovine 使用 Webpack 作为开发工具，符合主流前端生态，减少学习成本
- 使用方式不一样
  - Amis 需要自己搭建一系列开发环境，官方虽然提供了 [Amis-Admin](https://github.com/fex-team/amis-admin) 一个 Demo 启动项目，不过很基础，要实现 Ovine 类似功能，需要花费很多时间
  - Ovine 集成了管理系统常用功能的封装。并且开箱即用，降低了 Amis 的使用门槛，同时远离搭建开发环境的烦恼
- 扩展性
  - Amis 扩展性极强，毕竟是基础库，没有特定应用上的约束
  - 由于 Ovine 实现了集成一些功能，因此就多了一些限制，也仅仅是使用 Ovine 功能的限制，但并不会限制你如何去扩展你的应用

### 关于使用 `Ovine` 的后顾之忧？

Ovine 在 Amis 的基础上做了一些封装，使得 Amis 更加容易上手。现阶段，已有一批开发者在使用了 Ovine，并完成了项目的顺利上线。此外 Ovine 官方正在持续跟进项目，热心解决开发者遇到的任何问题。 非常希望你将 Ovine 做为下一个 Admin 项目的备选方案。如果你觉得 Ovine 还不错，将它推荐给更多人吧～

### `Ovine` 长期方向是什么？

以 `Amis` 框架为基础，以 [`爱速搭`](https://suda.baidu.com/)、[`飞冰`](https://ice.work/) 为参照，以零成本快速搭建一个以**管理系统为主**的低代码平台体系，实现前端页面在线编辑、预览、发布。并提供一套可扩展的自定义功能接口，以满足部分特定的需求。

- #### OvineHerd 平台项目 Beta 版本

  [源码地址](https://github.com/CareyToboo/ovine-herd) [预览地址](http://ovine.igroupes.com/platform/center/org/127350080645627904/login)(测试账号 demo110/demo110)，如需内测可以联系 Q 群，将提供独立账号。

  这是平台的基础版本，功能暂不完善，但是可以提前先体验，采用 [qiankun](https://qiankun.umijs.org/) 微前端框架 与 Ovine 开发。

- #### 演示项目 JAVA-API

  [源码地址](https://github.com/CareyToboo/ovine-java-api)

### Ovine 适合谁?

- 适合`企业内部`运营管理后台
- 适合需要`强大权限`管理的后台
- 适合成`百上千个`crud 操作的后台
- 适合对自定义 UI 要求`不是极其高`的后台
- 适合喜欢偷懒的前端开发
- 适合喜欢钻研的后端开发
- 适合外包项目、私活
- 最后，我希望它适合你，节约你宝贵的时间 ^\_^ ～

### Ovine 基本都是 Json 配置，自定义扩展性有保障吗？

凡是配置 UI 的库都会有类似的问题。如果我的需求，所有的存在配置项，都解决不了怎么办？或者产品提出了刁钻的需求，是不是就不能实现了，要换一个系统了！！**完全不存在这个问题**， Amis 实际上就是一系列 React 组件，使用 Json 配置渲染出来了而已。Amis 本质上还是一个 React 组件。Ovine 也是一样，它在 Amis 基础上集成了一系列功能。如果这些配置都满足不了需求，那么直接不用配置，自己纯 DIY 写就行了。React 能实现的，Ovine 就可以。所以不存在这个问题～

### 完全没有用过 React 能用 Ovine 吗？

国内 Vue 非常火，我都没有接触过 React，但是也觉得 Ovine 这的框架想尝试。是不是能够上手？

主要参考以下两点

- 你要做的项目是不是纯企业内部系统，很多功能都可以商量，达到目的就行了。还是面向 C 端用户的中台项目，很多功能都是特别个性化的。那么 Ovine 不适合你了。
- 你是否有想上手 React 的想法，或者能够抽时间去学习。 Ovine 写 Admin,基本上不需要写自定义组件，但是难免有特殊情况，如果没有想了解 React 的打算，Ovine 也不推荐了。

那么换句话说，Ovine 是否可以支持用 Vue 写自定义组件呢？这个后期可以考虑，如果实在有很多 Vue 开发者有这个需要，那么集成一下 Vue 依赖包就行了。

### 是否考虑像 Amis 一样，提供 JsSdk 支持？

Ovine 将不会支持 JsSdk，总归现在写前端项目一般都用主流的开发框架模块化开发，因此，JsSdk 的形式，受限太多了。如果你确实有类似的需求，可以参考 Amis 官方在持续维护 [Amis JsSdk](https://baidu.github.io/amis/docs/start/getting-started#sdk) 。

### 能否在已经存在 Admin 项目中内嵌 Ovine？

不行。Ovine 是一套完整的集成的应用框架，因此只能，使用官方的开发工具。不能嵌入现存的 Admin 系统中。不过你可以采取以下方案解决这个问题。

- 总归项目是要是要重构或者升级的，如果原始项目架构特别老旧，导致需求难以快速实现，早就有重构的打算。那么干脆抽几个周末，将原始项目升级为 Ovine 项目。配合后端修改一下权限实现，还能增强原始项目权限模块。
- 使用 [Amis 官方 npm 包](https://baidu.github.io/amis/docs/start/getting-started)， Amis 包支持 Json 渲染组件，可快速接入已有项目中。
- 使用 [Amis 官方 JsSdk](https://baidu.github.io/amis/docs/start/getting-started#sdk)，引入对应的 Js,Css 文件，可以在任何前端项目中直接使用 Json 渲染组件。

### 是否支持多语言化？

Amis 已经支持组件多语言，Ovine 在下几个版本中，即将支持。

### 是否考虑添加可视化 UI 编辑器？

已经默认集成 AMIS-EDITOR，且与 Ovine 兼容

---

## Dev 开发相关的问题

### Dev 报 "文件找不到" 异常

项目里使用了动态文件加载。当你新 **添加/移动/删除** `pages/xx/index` 文件时，Webpack Lazy Import 缓存的之前文件丢失找不到了，就会报这个错。目前没有想到什么好方法解决。**重新跑下 Dev 命令就好了。**如果比较反感这个问题，建议如果有很多页面，先规划好目录结构，一次性全部将所有文件建好，然后修改文件内容即可。

### Dev 热更新存在问题

本项目基于 Amis 而 它又是 Fis3 作为开发工具。Ovine 使用的 React-hot-loader 与 Webpack Hot Reload 方式，加了一个热更新的功能。很因为很多都是组件都是层层封装为 JSON 渲染，再加上路由懒加载，某个环节就导致热更模块没有匹配上。

- 虽然页面虽然闪了下，数据也刷新了，但是代码改动没有在界面上更新过来。如果遇到这样的情况，可以自己手动刷新一下就好了。
- 每次改了文件，页面就刷新，就行完全不存在热更新功能一样。遇到这样的情况，可能是热更文件时，导致某个组件代码报错，热更新就会失效，就会每次改动代码就自动刷新页面。

### Dev 控制台为何一堆警告信息

Amis 的 React 组件依赖包太旧了，几年前的，现在 React 都 16.13+了。可能很多依赖包都是基于 React 15.X 开发的。难免一些警告，无视就好。
