﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Microsoft.WindowsAPICodePack.Shell;
using Microsoft.WindowsAPICodePack.ShellExtensions;
using System.Drawing.Imaging;
using System.IO;    
//Created : 21/08/2013
//Author  :Naimish

namespace WindowsFormsApplication1
{
    public partial class Form1 : Form
    {

        ShellFile shellFile = null;
        Image img = null;
        string filename = null;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
          
            
        }

        

        private void GenerateThumbnail(string pdf, int pagenumber)
        {
            if (pdf == string.Empty) return;

            try
            {
                filename = pdf;
                shellFile = ShellFile.FromFilePath(filename);
                Bitmap bitmap = shellFile.Thumbnail.ExtraLargeBitmap;
                img = bitmap.GetThumbnailImage(100, 150, null, IntPtr.Zero);
                pictureBox1.Image = img;

                //bitmap.Save(@"C:\thumbnail.Jpeg", ImageFormat.Jpeg);
                //pictureBox1.Image = shellFile.Thumbnail.ExtraLargeBitmap;
                lblDblClick.Visible = true;
                             
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message);

            }
            finally
            {
                
            }
         }

        private void button1_Click(object sender, EventArgs e)
        {
            using (OpenFileDialog dlg = new OpenFileDialog())
            {
                dlg.Title = "Select PDF File...";
                dlg.Filter = "PDF File (*.PDF)|*.pdf";
                
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    txtPdf.Text = dlg.FileName;
                    Application.DoEvents();

                    GenerateThumbnail(txtPdf.Text, 1);
                }
            }
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
           //shellFile.Dispose();
           // img.Dispose();
            new Form1().Close();
            
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (txtPdf.Text == string.Empty) return;
            using (SaveFileDialog dlg = new SaveFileDialog())
            {
                dlg.Title = "Save PDF Thumbnail Image";
                dlg.Filter = "Jpeg Image (*.jpg)|*.jpg";
                dlg.OverwritePrompt = true;

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    pictureBox1.Image.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Jpeg);
                }
            }
        }

        private void pictureBox1_DoubleClick(object sender, EventArgs e)
        {
            //FileStream fs = new FileStream(@"C\hello.pdf", FileMode.Open);
            System.Diagnostics.Process.Start(filename);
        }

        
    }
}
