<?php
/**
* FILE_NAME : admin_global.fun.php
*
* @copyright www.shuangyulin.com
* @author 双鱼林  Design
* @package 后台全局函数
* @subpackage
* @version QQ:287307421或254540457
*/

/**
 * 递归方式的对变量中的特殊字符进行转义
 *
 * @access  public
 * @param   mix     $value
 *
 * @return  mix
 */
function addslashes_deep($value)
{
    if (empty($value))
    {
        return $value;
    }
    else
    {
        return is_array($value) ? array_map('addslashes_deep', $value) : addslashes($value);
    }
}

/**
 * 后台提示信息，跳转窗口
 *
 * @param   string   $msg        显示信息
 * @param   string   $gourl      跳转的url
 *
 * @return  string
 */
function showmsg($msg, $gourl='goback') {
 	global $smarty;
 	$smarty->caching = false;
 	$smarty->assign("msg",$msg);
 	$smarty->assign("gourl",$gourl);
 	$smarty->display("showmsg.html");
 	
 	exit();
}

/**
 * 自定义 header 函数，直接将页面重定向
 *
 * @param   string  string  内容
 *
 * @return  void
 */
function web_header($string, $replace = true, $http_response_code = 0) {
    $string = str_replace(array("\r", "\n"), array('', ''), $string);

    if (preg_match('/^\s*location:/is', $string)) {
        @header($string . "\n", $replace);
        exit();
    }

    if (empty($http_response_code) || PHP_VERSION < '4.3') {
        @header($string, $replace);
    } else {
        @header($string, $replace, $http_response_code);
    }
}

/**
 * 查询所有分类
 *
 * @access      public
 * @param       string      tablename       查询的数据表名
 * @param       int         id              根id，默认为0
 * @return      array
 */
function tree($tablename, $id = 0) {
	global $DB, $dbprefix, $temcates;
	$sql = "SELECT * from {$dbprefix}$tablename where parentid = $id ORDER BY displayorder";
	$row = $DB->query($sql);
	while ($rows = $DB->fetch_array($row)) {
		$temcates[] = $rows;
		tree($tablename, $rows['catid']);
	}
	return $temcates;
}
	
/**
 * 查询所有父级分类
 *
 * @access      public
 * @param       string      tablename       查询的数据表名
 * @param       int         id              根id，默认为0
 * @param       int         cid             附加id，默认为0
 * @return      array
 */
function selcate($tablename, $cid = 0) {
	global $DB, $dbprefix, $temcates;
	
	$sql = "SELECT catid,name from {$dbprefix}$tablename where parentid = 0";
	$row = $DB->query($sql);
	while ($rows = $DB->fetch_array($row)) {
		$temcates[] = $rows;
		
		if ($cid == 0) {
			$ssql = "SELECT catid, name from {$dbprefix}$tablename where parentid = '".$rows['catid']."'";
			$srow = $DB->query($ssql);
			while ($srows = $DB->fetch_array($srow)) {
				$temcates[] = $srows;
			}
		}
	}
	return $temcates;
}
	
/**
 * 删除分类
 *
 * @access      public
 * @param       string      tablename       查询的数据表名
 * @param       int         id              分类id
 * @return      TRUE/FLASE
 */
function delcate($tablename, $id) {
	global $DB, $dbprefix;
	
	$sql = "SELECT * from {$dbprefix}$tablename where parentid = $id";
	$row = $DB->query($sql);
	if ($row) {
		while ($rows = $DB->fetch_array($row)) {
			delcate($tablename, $rows['catid']);
		}
	}
	$delsql = "DELETE FROM {$dbprefix}$tablename where catid = $id";
	$DB->query($delsql);
}

/**
 * 建立文件目录
 *
 * @access      public
 * @param       string      dir       文件目录
 * @return      TRUE/FLASE
 */
function createdir($dir) {
	
	if (!is_dir($dir)) {
		$temp = explode('/',$dir);
		$cur_dir = '';
		
		for($i=0;$i<count($temp);$i++) {
			$cur_dir .= $temp[$i].'/';
			if (!is_dir($cur_dir)) {
				@mkdir($cur_dir,0777);
				@fopen("$cur_dir/index.htm","a");
			}
		}
	}
}

/**
 * 设置管理员的session内容
 *
 * @access  public
 * @param   integer $user_id        管理员编号
 * @param   string  $username       管理员姓名
 * @param   string  $action_list    权限列表
 * @param   string  $last_time      最后登录时间
 * @return  void
 */
function set_admin_session($admin_id, $admin_name, $admin_pass, $last_login)
{
    $_SESSION['admin_id']   = $admin_id;
    $_SESSION['admin_name'] = $admin_name;
    $_SESSION['admin_pass'] = $admin_pass;
    $_SESSION['last_login'] = $last_login; // 用于保存最后一次登录系统的时间
}

/**
 * 删除管理员的session内容
 *
 * @access  public
 * @param   integer $user_id        管理员编号
 * @param   string  $username       管理员姓名
 * @param   string  $action_list    权限列表
 * @param   string  $last_time      最后登录时间
 * @return  void
 */
function unset_admin_session()
{
    unset($_SESSION['admin_id']);
    unset($_SESSION['admin_name']);
    unset($_SESSION['admin_pass']);
    unset($_SESSION['last_login']);
}


?>