<?php
/******************************
'类名：Miniature
'名称：图片缩略类
'描述：支持gif,jpeg,jpg,png
'******************************/

class Miniature
{
/*
0:不显示错误
1:显示错误
2:显示错误和错误原型
3:显示错误，错误原型，停止程序继续执行
*/
var $Debug;//错误显示级别，分别有0,1,2,3级别

var $Image;//图片对象
var $ImageType;//图片类型，1 = GIF，2 = JPG，3 = PNG
var $ImageWidth;//宽度
var $ImageHeight;//高度

/*私有变量声明，类内部使用，不公开*/
var $fontFile;//字体文件
function Miniature()
{
   $this->Debug=3;
   $this->ImageType=2;
}

//读取图片
function ReadImage($img)
{
  $imgInfo=@getimagesize($img);//取得图片信息
   if(!$imgInfo)
   {$this->ShowError("读取图片错误","ReadImage(\"$img\")");}

   $this->ImageType=$imgInfo[2];//取得图片类型
   switch(strtolower($this->ImageType))
   {
    case 1:
     $this->Image=@imagecreatefromgif($img);
       break;
    case 2:
     $this->Image=@imagecreatefromjpeg($img);
       break;
    case 3:
     $this->Image=@imagecreatefrompng($img);
       break;
    default:
     $this->Image=@imagecreatefromjpeg($img);
   }
   if(!$this->Image)
   {$this->ShowError("读取图片错误","ReadImage(\"$img\")");}

   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//剪切图片
function CutImage($imgX,$imgY,$imgWidth,$imgHeight)
{
   $newImg=$this->createImage($imgWidth,$imgHeight);
   if(!$newImg)
   {$this->ShowError("创建图片错误","CutImage($imgX,$imgY,$imgWidth,$imgHeight)");}
   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,$imgX,$imgY,
    $imgWidth,$imgHeight,$imgWidth,$imgHeight
    ) or $this->ShowError("剪切图片错误","CutImage($imgX,$imgY,$imgWidth,$imgHeight)");

   $this->Image=$newImg;

   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//长和宽都按统一的百分比缩小
//$nPer:百分比数
function ResizedByPer($nWidthPer,$nHeightPer)
{
   $w=$this->ImageWidth*($nWidthPer/100);//计算宽百份数
   $h=$this->ImageHeight*($nHeightPer/100);//计算高百份数
   $newImg=$this->createImage($w,$h);
   if(!$newImg)
   {$this->ShowError("创建图片错误","ResizedByPer($nPer)");}

   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,0,0,
    $w,$h,$this->ImageWidth,$this->ImageHeight
    ) or $this->ShowError("缩小图片错误","ResizedByPer($nPer)");

   $this->Image=$newImg;
   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//按固定的长和宽缩小(此方法可能会出现图片变形情况)
function ResizedByWH($nWidth,$nHeight)
{
   $newImg=$this->createImage($nWidth,$nHeight);
   if(!$newImg)
   {$this->ShowError("创建图片错误","ResizedByWH($nWidth,$nHeight)");}

   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,0,0,
    $nWidth,$nHeight,$this->ImageWidth,$this->ImageHeight
    ) or $this->ShowError("缩小图片错误","ResizedByWH($nWidth,$nHeight)");

   $this->Image=$newImg;
   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//按长和宽进行智能缩小，而不会使图片缩小后出现变形情况
function ResizeImage($nWidth,$nHeight)
{
   //计算宽和高的比例
   $p1=$nWidth/$nHeight;
   $p2=$this->ImageWidth/$this->ImageHeight;

   $w=0;$h=0;
   if($p1 < $p2)
   {
    //按宽度来计算新图片的宽和高
    $w=$nWidth;
    $h=$nWidth*(1/$p2);
   }
   else
   {
    //按高度来计算新图片的宽和高
    $h=$nHeight;
    $w=$nHeight*$p2;
   }

   $nWidth=$w;
   $nHeight=$h;
   $newImg=$this->createImage($nWidth,$nHeight);
   if(!$newImg)
   {$this->ShowError("创建图片错误","ResizeImage($nWidth,$nHeight)");}

   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,0,0,
    $nWidth,$nHeight,$this->ImageWidth,$this->ImageHeight
    ) or $this->ShowError("缩小图片错误","ResizeImage($nWidth,$nHeight)");

   $this->Image=$newImg;
   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//按一定的角度旋转图片
function RotateImage($nAngle)
{
   $w=$this->ImageWidth;
   $h=$this->ImageHeight;

  $newImg=@imagecreatetruecolor($w,$h);
   if(!$newImg)
   {$this->ShowError("创建图片错误","RotateImage($nAngle)");}
   //重新处理图片,否则在旋转gif,png时会有问题,偶也不知道原理-_-!
   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,0,0,
    $w,$h,$w,$h
    ) or $this->ShowError("旋转图片错误","RotateImage($nAngle)");
   $this->Image=$newImg;

   if($nAngle==90 ||$nAngle==270)
   {
   $newImg=@imagecreatetruecolor($h,$w);
   }
   else
   {
   $newImg=@imagecreatetruecolor($w,$h);
   }
   if(!$newImg)
   {$this->ShowError("创建图片错误","RotateImage($nAngle)");}

   switch($nAngle)
   {
    case 90:
     for($i=1;$i<=$w;$i++)//从1开始
     {
        for($j=1;$j<=$h;$j++)//从1开始
      {
       imagesetpixel($newImg,$h-$j-1,$i,imagecolorat($this->Image,$i,$j));    
      }
       }
     break;
    case 180:
     for($i=1;$i<=$w;$i++)//从1开始
     {
        for($j=1;$j<=$h;$j++)//从1开始
      {
       imagesetpixel($newImg,$i,$h-$j-1,imagecolorat($this->Image,$i,$j));    
      }
       }
     break;
    case 270:
     for($i=1;$i<=$w;$i++)//从1开始
     {
        for($j=1;$j<=$h;$j++)//从1开始
      {
       imagesetpixel($newImg,$j,$w-$i-1,imagecolorat($this->Image,$i,$j));    
      }
       }
     break;
   }

   $this->Image=$newImg;
   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//按水平翻转
function TurnL()
{
   $w=$this->ImageWidth;
   $h=$this->ImageHeight;
  $newImg=@imagecreatetruecolor($w,$h);
   if(!$newImg)
   {$this->ShowError("创建图片错误","TurnL()");}

   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,$w-1,0,
    $w,$h,-$w,$h
    ) or $this->ShowError("水平翻转图片错误","TurnL()");

   $this->Image=$newImg;
   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//按垂直翻转
function TurnV()
{
   $w=$this->ImageWidth;
   $h=$this->ImageHeight;
  $newImg=@imagecreatetruecolor($w,$h);
   if(!$newImg)
   {$this->ShowError("创建图片错误","TurnV()");}

   @imagecopyresampled(
    $newImg,$this->Image,
    0,0,0,$h-1,
    $w,$h,$w,-$h
    ) or $this->ShowError("垂直翻转图片错误","TurnV()");

   $this->Image=$newImg;
   //重新取得图片宽度和高度
   $this->ImageWidth=imagesx($this->Image);//取得图片宽度
   $this->ImageHeight=imagesy($this->Image);//取得图片高度
}

//添加边框
//$x,$y:起始x,y点
//$nWidth,$nHeight:长和宽
//$nBorderWidth:边框大小,单位:px
//$arrColor:边框颜色,数组
function CreateBorder($x,$y,$nWidth,$nHeight,$nBorderWidth,$arrColor)
{
   $borderColor=imagecolorallocate(
    $this->Image,
    $arrColor[0],
    $arrColor[1],
    $arrColor[2]
    );//可以在此改变边框颜色
   imagesetthickness($this->Image,$nBorderWidth);//设置边框宽度
        imagerectangle($this->Image,$x,$y,$nWidth,$nHeight,$borderColor);
}

//设置透明图片
//$num:其值从 0 到 127。0 表示完全不透明，127 表示完全透明。
function SetAlpha($num){}

//加载字体文件
function LoadFont($_fontFile)
{
   $this->fontFile=$_fontFile;
}

//往图片添加字体
//$text:字符
//$fontSize:字体大小
//$posX,$posY:字体在图象的(x,y)点
//$arrFontColor:字体颜色，可以是数组array(r,g,b),也可以为十六进制颜色值如：#FF0000
//$angle:字体角度，默认为0
function AddText($text,$fontSize,$posX,$posY,$arrFontColor,$angle=0)
{
     //将16进制转为数组array(r,g,b)
   if(strlen($arrFontColor)==7)
   {
    $r=hexdec(substr($arrFontColor,1,2));
            $g=hexdec(substr($arrFontColor,3,2));
            $b=hexdec(substr($arrFontColor,5));
    $arrFontColor=array($r,$g,$b);
   }
   $c=$arrFontColor;
   $fontColor=imagecolorallocate($this->Image,$c[0],$c[1],$c[2]);
   //进行编码转换,php4.x需要开启iconv库
   if(function_exists("iconv"))$text=iconv('GB2312','UTF-8',$text);

   if(!$this->fontFile)//如果不加载字体，则使用默认字体
   {
   $f=@imagestring($this->Image,$fontSize,$posX,$posY,$text,$fontColor);
   }
   else//如果加载字体则使用改字体显示
   {
   $f=@imagettftext(
     $this->Image,
     $fontSize,
     $angle,
     $posX,
     $posY,
     $fontColor,
     $this->fontFile,
     $text
     );
   }

   if(!$f)
   {
    $this->ShowError(
    "添加字体错误","AddText(\"$text\",$fontSize,$posX,$poxY,$arrFontColor,$angle)"
    );
   }
}

//创建图片,私有方法,类内部使用
function createImage($nWidth,$nHeight)
{
   if($this->ImageType==1 || $this->ImageType==3)//如果是gif图片
   {
   $im=@imagecreate($nWidth,$nHeight);
   }
   else//如果是其他图片
   {
   $im=@imagecreatetruecolor($nWidth,$nHeight);
   }
   //使背景图象透明,这个很重要,不设置会使有透明背景的gif,png产生黑色图片
   @imagecolorallocatealpha($im,255,255,255,127);
   return $im;
}

//保存图片
function SaveImage($imagePath,$imageName)
{
   //文件全路径
   $p=$imagePath.$imageName;

   switch($this->ImageType)
   {
    case 1:
    $im=@imagegif($this->Image,$p.".gif");
       break;
    case 2:
    $im=@imagejpeg($this->Image,$p.".jpeg",100);
       break;
    case 3:
     imagesavealpha ($this->Image, true);
    $im=@imagepng($this->Image,$p.".png");
       break;
    case 4:
    $im=@imagejpeg($this->Image,$p.".jpg",100);
       break;
    default:
    $im=@imagejpeg($this->Image,$p.".jpeg",100);
   }

   if(!$im)
   {
    $this->ShowError("保存图片错误","SaveImage(\"$imagePath\",\"$imageName\")");
   }
}

//直接输出(在浏览器端)图片
function ShowImage()
{
   switch(strtolower($this->ImageType))
   {
    case 1:
    $im=@imagegif($this->Image);break;
    case 2:
    $im=@imagejpeg($this->Image,"",100);break;
    case 3:
     imagesavealpha ($this->Image, true);
    $im=@imagepng($this->Image);break;
    default:
    $im=@imagejpeg($this->Image,"",100);break;
   }
   if(!$im)
   {
    $this->ShowError("显示图片错误","ShowImage()");
   }
}

//销毁图片
function DestroyImage()
{
   @imagedestroy($this->Image);
}

//显示错误
function ShowError($errorMsg,$oriMethod)
{
   $cssstyle="style=\"";
        $cssstyle.="font:bold 12px 150%,'Arial';border:1px solid #CC3366;";
        $cssstyle.="width:50%;color:#990066;padding:2px;\"";
        $str="\n<ul ".$cssstyle.">\n";

   if($this->Debug==0)return;
   if($this->Debug>0)
   {
    $str.="<li>描述：".$errorMsg."</li>\n";
   }
   if($this->Debug>1)
   {
    $str.="<li>原型：".$oriMethod."</li>\n";
   }
   $str.="</ul>\n";
   echo $str;
   if($this->Debug==3)exit;
}
}
?>